/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;

public class DebugStack {
    private static final String stackElement = "    %s";

    public static void debug(IDebugger dbg, String cls, String mnm) {
        if (dbg.isDebug()) {
            Debug.debug(dbg, cls, mnm, "Stack trace");
            DebugStack.logStack(dbg, 500);
        }
    }

    public static void trace(IDebugger dbg, String cls, String mnm) {
        if (dbg.isTrace()) {
            Debug.trace(dbg, cls, mnm, "Stack trace");
            DebugStack.logStack(dbg, 600);
        }
    }

    public static void items(IDebugger dbg, String cls, String mnm) {
        if (dbg.isItems()) {
            Debug.items(dbg, cls, mnm, "Stack trace");
            DebugStack.logStack(dbg, 650);
        }
    }

    public static void setup(IDebugger dbg, String cls) {
        if (dbg.isDebug()) {
            Debug.setup(dbg, cls, "Stack trace");
            DebugStack.logStack(dbg, 500);
        }
    }

    private static void logStack(IDebugger dbg, int lvl) {
        Thread thread = Thread.currentThread();
        StackTraceElement[] elements = thread.getStackTrace();
        int i = 3;
        while (i < elements.length) {
            dbg.log(String.format(stackElement, elements[i].toString()), lvl);
            ++i;
        }
    }
}

