/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugMessage;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class DebugMessage
implements IDebugMessage {
    private final StringBuilder sb;
    private final String nlsMessage;
    private final List<String> nlsBindings;
    private String className;
    private String innerClassName;
    private String methodName;
    private boolean timeStamp;
    private boolean threadId;

    public DebugMessage() {
        this.nlsMessage = null;
        this.nlsBindings = null;
        this.sb = new StringBuilder();
    }

    public DebugMessage(String nlsMessage) {
        this.nlsMessage = nlsMessage;
        this.nlsBindings = new ArrayList<String>();
        this.sb = null;
    }

    public DebugMessage(String nlsMessage, Object[] bindings) {
        this.nlsMessage = nlsMessage;
        this.nlsBindings = new ArrayList<String>();
        if (bindings != null && bindings.length > 0) {
            Object[] objectArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                Object binding = objectArray[n2];
                this.nlsBindings.add(LogString.value(binding));
                ++n2;
            }
        }
        this.sb = null;
    }

    public DebugMessage(String className, boolean timeStamp) {
        this.className = className;
        this.timeStamp = timeStamp;
        this.nlsMessage = null;
        this.nlsBindings = null;
        this.sb = new StringBuilder();
    }

    public DebugMessage(String className, boolean timeStamp, boolean threadId) {
        this.className = className;
        this.timeStamp = timeStamp;
        this.threadId = threadId;
        this.nlsMessage = null;
        this.nlsBindings = null;
        this.sb = new StringBuilder();
    }

    public DebugMessage(String className, String methodName, boolean timeStamp) {
        this.className = className;
        this.methodName = methodName;
        this.timeStamp = timeStamp;
        this.nlsMessage = null;
        this.nlsBindings = null;
        this.sb = new StringBuilder();
    }

    public DebugMessage(String className, String methodName, boolean timeStamp, boolean threadId) {
        this.className = className;
        this.methodName = methodName;
        this.timeStamp = timeStamp;
        this.threadId = threadId;
        this.nlsMessage = null;
        this.nlsBindings = null;
        this.sb = new StringBuilder();
    }

    public DebugMessage(String className, String methodName, boolean timeStamp, String nlsMessage, Object ... bindings) {
        this.className = className;
        this.methodName = methodName;
        this.timeStamp = timeStamp;
        this.nlsMessage = nlsMessage;
        this.nlsBindings = new ArrayList<String>();
        if (bindings != null && bindings.length > 0) {
            Object[] objectArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                Object binding = objectArray[n2];
                this.nlsBindings.add(LogString.value(binding));
                ++n2;
            }
        }
        this.sb = null;
    }

    public DebugMessage(String className, String methodName, boolean timeStamp, boolean threadId, String nlsMessage, Object ... bindings) {
        this.className = className;
        this.methodName = methodName;
        this.timeStamp = timeStamp;
        this.threadId = threadId;
        this.nlsMessage = nlsMessage;
        this.nlsBindings = new ArrayList<String>();
        if (bindings != null && bindings.length > 0) {
            Object[] objectArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                Object binding = objectArray[n2];
                this.nlsBindings.add(LogString.value(binding));
                ++n2;
            }
        }
        this.sb = null;
    }

    @Override
    public final String getClassName() {
        return this.className;
    }

    @Override
    public final void setClassName(String className) {
        this.className = className;
    }

    @Override
    public final String getInnerClassName() {
        return this.innerClassName;
    }

    @Override
    public final void setInnerClassName(String innerClassName) {
        this.innerClassName = innerClassName;
    }

    @Override
    public final String getMethodName() {
        return this.methodName;
    }

    @Override
    public final void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public final boolean isTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public final void setTimeStamp(boolean timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public final boolean isThreadId() {
        return this.threadId;
    }

    @Override
    public final void setThreadId(boolean threadId) {
        this.threadId = threadId;
    }

    @Override
    public final void add(String s) {
        this.validateNLS();
        this.nlsBindings.add(LogField.value(s));
    }

    @Override
    public final String bind() {
        this.validateNLS();
        StringBuilder msg = new StringBuilder();
        if (this.isThreadId()) {
            msg.append(String.format("[%d] ", Thread.currentThread().getId()));
        }
        if (this.isTimeStamp()) {
            msg.append(Debug.SDF.format(new Date()));
        }
        if (this.className != null) {
            msg.append(this.className);
            msg.append(".");
        }
        if (this.innerClassName != null) {
            msg.append(this.innerClassName);
            msg.append(".");
        }
        if (this.methodName != null) {
            msg.append(this.methodName);
            msg.append(".");
        }
        if (msg.length() > 0) {
            msg.setLength(msg.length() - 1);
            msg.append(":");
            msg.append(" ");
        }
        if (this.nlsBindings.size() > 0) {
            msg.append(NLS.bind((String)this.nlsMessage, (Object[])this.nlsBindings.toArray(), (Object[])new Object[0]));
        } else {
            msg.append(this.nlsMessage);
        }
        return msg.toString();
    }

    private final void validateNLS() {
        if (this.nlsMessage == null) {
            throw new UnsupportedOperationException("Not initialized for NLS operations");
        }
    }

    @Override
    public final void append(boolean s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(Boolean s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(char s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(char[] s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(double s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(Double s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(float s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(Float s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(int s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(Integer s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(long s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(Long s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(Object s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    @Override
    public final void append(String s) {
        this.validateSB();
        this.sb.append(LogField.valueOf(s));
    }

    public final void append(String[] strings) {
        this.validateSB();
        int i = 0;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.sb.append(LogField.valueOf(s));
            if (++i < strings.length) {
                this.sb.append(",");
            }
            ++n2;
        }
    }

    @Override
    public final void appendToken(String s) {
        this.validateSB();
        this.sb.append("[");
        this.sb.append(LogField.valueOf(s));
        this.sb.append("]");
    }

    @Override
    public final void appendToken(String l, String s) {
        this.validateSB();
        this.sb.append("[");
        this.sb.append(LogField.valueOf(l));
        this.sb.append(":");
        this.sb.append(LogField.valueOf(s));
        this.sb.append("]");
    }

    @Override
    public final String get() {
        this.validateSB();
        StringBuilder msg = new StringBuilder();
        if (this.isThreadId()) {
            msg.append(String.format("[%d] ", Thread.currentThread().getId()));
        }
        if (this.isTimeStamp()) {
            msg.append(Debug.SDF.format(new Date()));
        }
        if (this.className != null) {
            msg.append(this.className);
            msg.append(".");
        }
        if (this.innerClassName != null) {
            msg.append(this.innerClassName);
            msg.append(".");
        }
        if (this.methodName != null) {
            msg.append(this.methodName);
            msg.append(".");
        }
        if (msg.length() > 0) {
            msg.setLength(msg.length() - 1);
            msg.append(":");
            msg.append(" ");
        }
        msg.append((CharSequence)this.sb);
        return msg.toString();
    }

    @Override
    public void reset() {
        this.validateSB();
        this.sb.setLength(0);
    }

    private final void validateSB() {
        if (this.sb == null) {
            throw new UnsupportedOperationException("Not initialized for StringBuilder operations");
        }
    }
}

