/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.PropertyTools;
import com.ibm.team.build.extensions.common.debug.DebugClass;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugClass;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.StatisticsCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.Reconfigurable;

public class DebugInstance {
    private static DebugInstance instance;
    private IDebugger dbg;
    private boolean dbgClasses = false;
    private boolean dbgClassesSet = false;
    private boolean dbgGroups = false;
    private boolean dbgGroupsSet = false;
    private final AtomicInteger classVersion = new AtomicInteger();
    private final AtomicInteger groupVersion = new AtomicInteger();
    private final Map<String, IDebugClass> debugClasses = Collections.synchronizedMap(new HashMap());
    private final Map<String, IDebugClass> debugGroups = Collections.synchronizedMap(new HashMap());
    private final Map<String, StatisticsCounter> counters = Collections.synchronizedMap(new HashMap());

    private DebugInstance() {
    }

    private DebugInstance(IDebugger dbg) {
        this.dbg = dbg;
    }

    public static synchronized DebugInstance getInstance() {
        if (instance == null) {
            instance = new DebugInstance(new Debugger());
            instance.initializeClasses();
            instance.initializeGroups();
        }
        return instance;
    }

    public static synchronized DebugInstance getInstance(boolean reset) {
        if (instance == null) {
            instance = new DebugInstance(new Debugger());
            instance.initializeClasses();
            instance.initializeGroups();
        } else if (reset) {
            instance.initializeClasses();
            instance.initializeGroups();
        }
        return instance;
    }

    public static synchronized DebugInstance getInstance(IDebugger dbg) {
        if (instance == null) {
            instance = new DebugInstance(dbg);
            instance.initializeClasses();
            instance.initializeGroups();
        } else if (dbg != null) {
            instance.setDbg(dbg);
        }
        return instance;
    }

    public static synchronized void deleteInstance() {
        instance = null;
    }

    public final IDebugger getDbg() {
        return this.dbg;
    }

    public final void setDbg(IDebugger dbg) {
        this.dbg = dbg;
    }

    public final boolean isDbgSet() {
        return this.dbg != null;
    }

    public Map<String, IDebugClass> getDebugClasses() {
        return this.debugClasses;
    }

    public boolean isDebugClasses() {
        return this.dbgClassesSet ? this.dbgClasses : !this.debugClasses.isEmpty();
    }

    public boolean isDebugClassesSet() {
        return this.dbgClassesSet;
    }

    public synchronized void setDebugClasses(boolean dbgClasses) {
        this.dbgClasses = dbgClasses;
        this.dbgClassesSet = true;
    }

    public synchronized void unsetDebugClasses() {
        this.dbgClasses = false;
        this.dbgClassesSet = false;
    }

    public void addClassEntry(Class<?> clazz, IDebugClass entry) {
        this.debugClasses.put(clazz.getCanonicalName(), entry);
        this.setDebugClasses(true);
    }

    public void addClassEntry(String className, IDebugClass entry) {
        this.debugClasses.put(className, entry);
        this.setDebugClasses(true);
    }

    public IDebugClass getClassEntry(Class<?> clazz) {
        return this.debugClasses.get(clazz.getCanonicalName());
    }

    public boolean hasClassEntry(Class<?> clazz) {
        return this.debugClasses.containsKey(clazz.getCanonicalName());
    }

    public int getClassVersion() {
        return this.classVersion.get();
    }

    public void addDebugGroup(String propertyName, String propertyValue) {
        System.setProperty(propertyName, propertyValue);
        this.initializeGroups();
    }

    public Map<String, IDebugClass> getDebugGroups() {
        return this.debugGroups;
    }

    public boolean isDebugGroups() {
        return this.dbgGroupsSet ? this.dbgGroups : !this.debugGroups.isEmpty();
    }

    public boolean isDebugGroupsSet() {
        return this.dbgGroupsSet;
    }

    public synchronized void setDebugGroups(boolean dbgGroups) {
        this.dbgGroups = dbgGroups;
        this.dbgGroupsSet = true;
    }

    public synchronized void unsetDebugGroups() {
        this.dbgGroups = false;
        this.dbgGroupsSet = false;
    }

    public void addGroupEntry(String group, IDebugClass entry) {
        this.debugGroups.put(group, entry);
        this.setDebugGroups(true);
    }

    public IDebugClass getGroupEntry(String group) {
        return this.debugGroups.get(group);
    }

    public boolean hasGroupEntry(String group) {
        return this.debugGroups.containsKey(group);
    }

    public boolean hasGroupEntry(DebugGroup debugGroup) {
        boolean result = false;
        String[] stringArray = debugGroup.value();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            if (instance.getDebugGroups().containsKey(group)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    public int getGroupVersion() {
        return this.groupVersion.get();
    }

    public boolean isDebugActive() {
        return !(this.dbgClassesSet ? !this.dbgClasses : this.debugClasses.isEmpty()) || !(this.dbgGroupsSet ? !this.dbgGroups : this.debugGroups.isEmpty());
    }

    public Map<String, StatisticsCounter> getCounters() {
        return this.counters;
    }

    private void initializeClasses() {
        Map<String, String> properties = PropertyTools.getProperties(System.getProperties(), "team.build.extensions.debug.class.");
        int classVersion = this.classVersion.get();
        this.debugClasses.clear();
        this.unsetDebugClasses();
        for (String property : properties.keySet()) {
            DebugClass debugClass = new DebugClass(null, properties.get(property));
            debugClass.setClassVersion(classVersion);
            this.addClassEntry(property.substring("team.build.extensions.debug.class.".length()), (IDebugClass)debugClass);
        }
        try {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration cfg = ctx.getConfiguration();
            for (Map.Entry<String, LoggerConfig> entry : cfg.getLoggers().entrySet()) {
                if (((String)entry.getKey()).startsWith("team.build.extensions.debug.class.") || ((LoggerConfig)entry.getValue()).getPropertyList() == null || ((LoggerConfig)entry.getValue()).getPropertyList().isEmpty()) continue;
                Class<?> clazz = Class.forName((String)entry.getKey());
                String value = this.getValue(entry);
                DebugClass entry2 = new DebugClass(clazz, value);
                entry2.setClassVersion(classVersion);
                this.addClassEntry(clazz, (IDebugClass)entry2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDebugClasses(!this.debugClasses.isEmpty());
    }

    private void initializeGroups() {
        Map<String, String> properties = PropertyTools.getProperties(System.getProperties(), "team.build.extensions.debug.group.");
        int groupVersion = this.groupVersion.get();
        this.debugGroups.clear();
        this.unsetDebugGroups();
        for (String property : properties.keySet()) {
            String[] stringArray = property.split("\\.");
            String group = stringArray[stringArray.length - 1];
            DebugClass entry = new DebugClass(null, properties.get(property));
            entry.setGroup(true);
            entry.setGroupName(group);
            entry.setGroupVersion(groupVersion);
            this.debugGroups.put(group, entry);
        }
        try {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration cfg = ctx.getConfiguration();
            for (Map.Entry<String, LoggerConfig> entry : cfg.getLoggers().entrySet()) {
                if (!((String)entry.getKey()).startsWith("team.build.extensions.debug.group.")) continue;
                String group = this.getGroup(entry);
                String value = this.getValue(entry);
                DebugClass entry2 = new DebugClass(null, value);
                entry2.setGroup(true);
                entry2.setGroupName(entry.getKey());
                entry2.setGroupVersion(groupVersion);
                this.debugGroups.put(group, entry2);
            }
            cfg.addListener((ConfigurationListener)new DebugListener());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDebugGroups(!this.debugGroups.isEmpty());
    }

    private void updateClasses() {
        int classVersion = this.classVersion.incrementAndGet();
        try {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration cfg = ctx.getConfiguration();
            ArrayList keys = new ArrayList();
            int classSize = this.debugClasses.size();
            for (Map.Entry<String, LoggerConfig> entry : cfg.getLoggers().entrySet()) {
                if (((String)entry.getKey()).startsWith("team.build.extensions.debug.group.") || ((LoggerConfig)entry.getValue()).getPropertyList().isEmpty()) continue;
                Class<?> clazz = Class.forName((String)entry.getKey());
                String value = this.getValue(entry);
                keys.add(clazz);
                if (this.debugClasses.containsKey(clazz)) {
                    this.debugClasses.get(clazz).reinit(value);
                    this.debugClasses.get(clazz).setClassVersion(classVersion);
                    continue;
                }
                DebugClass entry2 = new DebugClass(clazz, value);
                entry2.setClassVersion(classVersion);
                this.addClassEntry(clazz, (IDebugClass)entry2);
            }
            if (classSize > keys.size()) {
                for (String string : this.debugClasses.keySet()) {
                    if (keys.contains(string)) continue;
                    this.debugClasses.remove(string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDebugClasses(!this.debugClasses.isEmpty());
    }

    private void updateGroups() {
        try {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration cfg = ctx.getConfiguration();
            ArrayList<String> keys = new ArrayList<String>();
            int groupSize = this.debugGroups.size();
            int groupVersion = this.groupVersion.incrementAndGet();
            for (Map.Entry<String, LoggerConfig> entry : cfg.getLoggers().entrySet()) {
                if (!((String)entry.getKey()).startsWith("team.build.extensions.debug.group.")) continue;
                String group = this.getGroup(entry);
                String value = this.getValue(entry);
                keys.add(group);
                if (this.debugGroups.containsKey(group)) {
                    this.debugGroups.get(group).reinit(value);
                    this.debugGroups.get(group).setGroupVersion(groupVersion);
                    continue;
                }
                DebugClass entry2 = new DebugClass(null, value);
                entry2.setGroup(true);
                entry2.setGroupName(entry.getKey());
                entry2.setGroupVersion(groupVersion);
                this.debugGroups.put(group, entry2);
                ++groupSize;
            }
            if (groupSize > keys.size()) {
                for (String string : this.debugGroups.keySet()) {
                    if (keys.contains(string)) continue;
                    this.debugGroups.remove(string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDebugGroups(!this.debugGroups.isEmpty());
    }

    private String getGroup(Map.Entry<String, LoggerConfig> item) {
        String[] segments = item.getKey().split("\\.");
        return segments[segments.length - 1];
    }

    private String getValue(Map.Entry<String, LoggerConfig> item) {
        LoggerConfig config = item.getValue();
        String level = config.getLevel().toString();
        boolean debugOn = false;
        boolean timerOn = false;
        boolean multi = false;
        boolean timer = false;
        for (Property property : config.getPropertyList()) {
            switch (property.getName()) {
                case "debugOn": {
                    debugOn = Boolean.parseBoolean(property.getValue());
                    break;
                }
                case "timerOn": {
                    timerOn = Boolean.parseBoolean(property.getValue());
                    break;
                }
                case "multi": {
                    multi = Boolean.parseBoolean(property.getValue());
                    break;
                }
                case "timer": {
                    timer = Boolean.parseBoolean(property.getValue());
                }
            }
        }
        return IDebugger.getPropertyValue(level, debugOn, timerOn, multi, timer);
    }

    private class DebugListener
    implements ConfigurationListener {
        private DebugListener() {
        }

        public void onChange(Reconfigurable reconfigurable) {
            instance.updateClasses();
            instance.updateGroups();
        }
    }
}

