/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.DebugUtility;
import com.ibm.team.build.extensions.common.debug.IDebugClass;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class DebugClass
implements IDebugClass {
    private Class<?> clazz;
    private String className;
    private String groupName;
    private Log log;
    private Logger logger;
    private boolean group = false;
    private boolean utility = false;
    private boolean debugOn = false;
    private boolean debugOnSet = false;
    private boolean timerOn = false;
    private boolean timerOnSet = false;
    private boolean multi = false;
    private boolean multiSet = false;
    private boolean timer = false;
    private boolean timerSet = false;
    private boolean fatal = false;
    private boolean error = false;
    private boolean warn = false;
    private boolean info = false;
    private boolean flow = false;
    private boolean debug = false;
    private boolean trace = false;
    private boolean items = false;
    private int classVersion;
    private int groupVersion;

    public DebugClass(Class<?> clazz, String value) {
        this.setClazz(clazz);
        this.init(value);
    }

    private DebugClass(boolean debugOn, boolean debugOnSet, boolean timerOn, boolean timerOnSet, boolean multi, boolean multiSet, boolean timer, boolean timerSet) {
        this.debugOn = debugOn;
        this.debugOnSet = debugOnSet;
        this.timerOn = timerOn;
        this.timerOnSet = timerOnSet;
        this.multi = multi;
        this.multiSet = multiSet;
        this.timer = timer;
        this.timerSet = timerSet;
    }

    @Override
    public IDebugClass copy() {
        DebugClass result = new DebugClass(this.debugOn, this.debugOnSet, this.timerOn, this.timerOnSet, this.multi, this.multiSet, this.timer, this.timerSet);
        result.setGroup(this.isGroup());
        result.setGroupName(this.getGroupName());
        result.setFatal(this.isFatal());
        result.setError(this.isError());
        result.setWarn(this.isWarn());
        result.setInfo(this.isInfo());
        result.setFlow(this.isFlow());
        result.setDebug(this.isDebug());
        result.setTrace(this.isTrace());
        result.setItems(this.isItems());
        result.setClassVersion(this.getClassVersion());
        result.setGroupVersion(this.getGroupVersion());
        return result;
    }

    private void init(String value) {
        block36: {
            if (value == null) break block36;
            String[] options = value.split(",");
            String level = options[0];
            switch (level.toLowerCase()) {
                case "diag": 
                case "items": {
                    this.items = true;
                }
                case "trace": {
                    this.trace = true;
                }
                case "debug": {
                    this.debug = true;
                }
                case "flow": 
                case "verbose": {
                    this.flow = true;
                }
                case "info": {
                    this.info = true;
                }
                case "warn": {
                    this.warn = true;
                }
                case "error": {
                    this.error = true;
                }
                case "fatal": {
                    this.fatal = true;
                }
            }
            if (options.length > 1) {
                this.debugOn = Boolean.parseBoolean(options[1]);
                this.debugOnSet = true;
            }
            if (options.length > 2) {
                this.timerOn = Boolean.parseBoolean(options[2]);
                this.timerOnSet = true;
            }
            if (options.length > 3) {
                this.multi = Boolean.parseBoolean(options[3]);
                this.multiSet = true;
            }
            if (options.length > 4) {
                this.timer = Boolean.parseBoolean(options[4]);
                this.timerSet = true;
            }
        }
    }

    @Override
    public void init(IDebugClass dc) {
        this.setDebugOn(dc.isDebugOn());
        this.setTimerOn(dc.isTimerOn());
        this.setMulti(dc.isMulti());
        this.setTimer(dc.isTimer());
        this.setFatal(dc.isFatal());
        this.setError(dc.isError());
        this.setWarn(dc.isWarn());
        this.setInfo(dc.isInfo());
        this.setFlow(dc.isFlow());
        this.setDebug(dc.isDebug());
        this.setTrace(dc.isTrace());
        this.setItems(dc.isItems());
        this.setClassVersion(dc.getClassVersion());
        this.setGroupVersion(dc.getGroupVersion());
    }

    @Override
    public void reinit(String value) {
        Stream.of(this.debugOn, this.debugOnSet, this.timerOn, this.timerOnSet, this.multi, this.multiSet, this.timer, this.timerSet, this.fatal, this.error, this.warn, this.info, this.flow, this.debug, this.trace, this.items).forEach(x -> {
            Boolean bl = x = Boolean.valueOf(false);
        });
        this.init(value);
    }

    @Override
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(Class<?> clazz) {
        if (clazz != null) {
            this.clazz = clazz;
            this.className = clazz.getCanonicalName();
            DebugUtility anno = clazz.getAnnotation(DebugUtility.class);
            this.utility = anno != null ? anno.value() : false;
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public final boolean isGroup() {
        return this.group;
    }

    @Override
    public final void setGroup(boolean group) {
        this.group = group;
    }

    @Override
    public final boolean isUtility() {
        return this.utility;
    }

    @Override
    public final void setUtility(boolean utility) {
        this.utility = utility;
    }

    @Override
    public int getClassVersion() {
        return this.classVersion;
    }

    @Override
    public void setClassVersion(int classVersion) {
        this.classVersion = classVersion;
    }

    @Override
    public int getGroupVersion() {
        return this.groupVersion;
    }

    @Override
    public void setGroupVersion(int groupVersion) {
        this.groupVersion = groupVersion;
    }

    @Override
    public final Log addLogger(Log log, int logLevel) {
        this.log = log;
        if (this.isGroup()) {
            this.log = LogFactory.getLog((String)this.groupName);
            this.logger = LogManager.getLogger((String)this.groupName);
            Configurator.setLevel((Logger)this.logger, (Level)IDebugger.getLevel(logLevel));
        } else {
            this.logger = LogManager.getLogger(this.clazz);
            Configurator.setLevel((Logger)this.logger, (Level)IDebugger.getLevel(logLevel));
        }
        return this.log;
    }

    @Override
    public final Log getLog() {
        return this.log;
    }

    @Override
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isDebugOn() {
        return this.debugOn;
    }

    @Override
    public void setDebugOn(boolean debugOn) {
        this.debugOn = debugOn;
    }

    @Override
    public boolean isDebugOnSet() {
        return this.debugOnSet;
    }

    @Override
    public boolean isTimerOn() {
        return this.timerOn;
    }

    @Override
    public void setTimerOn(boolean timerOn) {
        this.timerOn = timerOn;
    }

    @Override
    public boolean isTimerOnSet() {
        return this.timerOnSet;
    }

    @Override
    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    @Override
    public boolean isMultiSet() {
        return this.multiSet;
    }

    public void setMultiSet(boolean multiSet) {
        this.multiSet = multiSet;
    }

    @Override
    public boolean isTimer() {
        return this.timer;
    }

    public void setTimer(boolean timer) {
        this.timer = timer;
    }

    @Override
    public boolean isTimerSet() {
        return this.timerSet;
    }

    public void setTimerSet(boolean timerSet) {
        this.timerSet = timerSet;
    }

    @Override
    public boolean isFatal() {
        return this.fatal;
    }

    @Override
    public void setFatal(boolean fatal) {
        this.fatal = fatal;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public void setError(boolean error) {
        this.error = error;
    }

    @Override
    public boolean isWarn() {
        return this.warn;
    }

    @Override
    public void setWarn(boolean warn) {
        this.warn = warn;
    }

    @Override
    public boolean isInfo() {
        return this.info;
    }

    @Override
    public void setInfo(boolean info) {
        this.info = info;
    }

    @Override
    public boolean isFlow() {
        return this.utility ? this.debug : this.flow;
    }

    @Override
    public void setFlow(boolean flow) {
        this.flow = flow;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isTrace() {
        return this.trace;
    }

    @Override
    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public boolean isItems() {
        return this.items;
    }

    @Override
    public void setItems(boolean items) {
        this.items = items;
    }
}

