/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.IDebugger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Debug {
    public static final String DBG_C_CLN = ":";
    public static final String DBG_C_DOT = ".";
    public static final String DBG_C_SPC = " ";
    public static final String DBG_DATAO = "[";
    public static final String DBG_DATAC = "]";
    public static final String DBG_DONEO = " done[";
    public static final String DBG_OFSPC = " of ";
    public static final String DBG_TIMEO = " time[";
    public static final String DBG_EMPTY = "";
    public static final String DBG_ENTER = "Enter: ";
    public static final String DBG_ERROR = "Error: ";
    public static final String DBG_FATAL = "Fatal: ";
    public static final String DBG_DEBUG = "Debug: ";
    public static final String DBG_INFO = "Info:  ";
    public static final String DBG_INOUT = "InOut: ";
    public static final String DBG_INTER = "Inter: ";
    public static final String DBG_ITEMS = "Items: ";
    public static final String DBG_LEAVE = "Leave: ";
    public static final String DBG_SETUP = "Setup: ";
    public static final String DBG_START = "Start: ";
    public static final String DBG_STOPS = "Stops: ";
    public static final String DBG_TRACE = "Trace: ";
    public static final String DBG_WARN = "Warn:  ";
    public static final String Label_Action = "action";
    public static final String Label_Active = "active";
    public static final String Label_Change = "change";
    public static final String Label_Component = "component";
    public static final String Label_Count = "count";
    public static final String Label_Exclude = "exclude";
    public static final String Label_File = "file";
    public static final String Label_Folder = "folder";
    public static final String Label_Include = "include";
    public static final String Label_Item = "item";
    public static final String Label_Name = "name";
    public static final String Label_Rc = "rc";
    public static final String Label_Result = "result";
    public static final String Label_Retry = "retry";
    public static final String Label_Scrub = "scrub";
    public static final String Label_Skip = "skip";
    public static final String Label_Skipped = "skipped";
    public static final String Label_Status = "status";
    public static final String Label_Unknown = "unknown";
    public static final String Label_Update = "update";
    public static final String Label_Updated = "updated";
    public static final String Label_Valu = "valu";
    public static final String Label_Value = "value";
    public static final String Label_0 = "0";
    public static final String Label_1 = "1";
    public static final String Label_2 = "2";
    public static final String Label_3 = "3";
    public static final String Label_4 = "4";
    public static final String Label_5 = "5";
    public static final String Label_6 = "6";
    public static final String Label_7 = "7";
    public static final String Label_8 = "8";
    public static final String Label_9 = "9";
    public static final String Label_Old = "Old";
    public static final String Label_New = "New";
    public static final String Label_Enter = "Enter";
    public static final String Label_Leave = "Leave";
    public static final String Label_Original = "Original";
    public static final String Label_Returned = "Returned";
    public static final String Lbl_Stk = "Stack trace";
    public static final String STR_L = "[%1$s]";
    public static final String STR_LV = "[%1$s:%2$s]";
    public static final String STR_LLV = "[%1$s][%2$s:%3$s]";
    public static final String STR_LVLV = "[%1$s:%2$s][%3$s:%4$s]";
    public static final String STR_LLVLV = "[%1$s][%2$s:%3$s][%4$s:%5$s]";
    public static final String STR_LVLVLV = "[%1$s:%2$s][%3$s:%4$s][%5$s:%6$s]";
    public static final String SDF_DYMD = "yyyyMMdd";
    public static final String SDF_DSTR = "yyyyMMddHHmmss";
    public static final String SDF_DATE = "yyyy-MM-dd";
    public static final String SDF_LONG = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String SDF_LONGB = "yyyy-MM-dd HH:mm:ss.SSS ";
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ", Locale.US);

    public static String data(String ... args) {
        switch (args.length) {
            case 0: {
                return DBG_EMPTY;
            }
            case 1: {
                return String.format(STR_L, args[0]);
            }
            case 2: {
                return String.format(STR_LV, args[0], args[1]);
            }
            case 3: {
                return String.format(STR_LLV, args[0], args[1], args[2]);
            }
            case 4: {
                return String.format(STR_LVLV, args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return String.format(STR_LLVLV, args[0], args[1], args[2], args[3], args[4]);
            }
        }
        return String.format(STR_LVLVLV, args[0], args[1], args[2], args[3], args[4], args[5]);
    }

    public static void msg(IDebugger dbg, String arg) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.msg(dbg.isMulti(), dbg.isTimer(), arg), dbg.getLogLevel());
        }
    }

    public static void msg(IDebugger dbg, int lvl, String arg) {
        dbg.log(Debug.msg(dbg.isMulti(), dbg.isTimer(), arg), lvl);
    }

    public static void msg(IDebugger dbg, String arg, int lvl) {
        dbg.log(Debug.msg(dbg.isMulti(), dbg.isTimer(), arg), lvl);
    }

    private static String msg(boolean id, boolean ts, String arg) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + arg;
    }

    public static String debug(String ... args) {
        return Debug.formatArgs(DBG_DEBUG, args);
    }

    public static void debug(IDebugger dbg, String ... args) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.debug(dbg.isMulti(), dbg.isTimer(), args), dbg.getDebugLevel());
        }
    }

    public static void debug(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.debug(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    private static String debug(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.debug(args);
    }

    public static String enter(String ... args) {
        return Debug.formatArgs(DBG_ENTER, args);
    }

    public static void enter(IDebugger dbg, String ... args) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.enter(dbg.isMulti(), dbg.isTimer(), args), dbg.getFlowLevel());
        }
    }

    public static void enter(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.enter(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    private static String enter(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.enter(args);
    }

    public static String error(String ... args) {
        return Debug.formatArgs(DBG_ERROR, args);
    }

    public static void error(IDebugger dbg, String ... args) {
        if (dbg.isError()) {
            dbg.log(Debug.error(dbg.isMulti(), dbg.isTimer(), args), dbg.getErrorLevel());
        }
    }

    public static void error(IDebugger dbg, Throwable t, String ... args) {
        if (dbg.isError()) {
            dbg.log(Debug.error(dbg.isMulti(), dbg.isTimer(), args), t, dbg.getErrorLevel());
        }
    }

    public static void error(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.error(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    public static void error(IDebugger dbg, int lvl, Throwable t, String ... args) {
        dbg.log(Debug.error(dbg.isMulti(), dbg.isTimer(), args), t, lvl);
    }

    private static String error(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.error(args);
    }

    public static String fatal(String ... args) {
        return Debug.formatArgs(DBG_FATAL, args);
    }

    public static void fatal(IDebugger dbg, String ... args) {
        if (dbg.isFatal()) {
            dbg.log(Debug.fatal(dbg.isMulti(), dbg.isTimer(), args), dbg.getFatalLevel());
        }
    }

    public static void fatal(IDebugger dbg, Throwable t, String ... args) {
        if (dbg.isFatal()) {
            dbg.log(Debug.fatal(dbg.isMulti(), dbg.isTimer(), args), t, dbg.getFatalLevel());
        }
    }

    public static void fatal(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.fatal(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    public static void fatal(IDebugger dbg, int lvl, Throwable t, String ... args) {
        dbg.log(Debug.fatal(dbg.isMulti(), dbg.isTimer(), args), t, lvl);
    }

    private static String fatal(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.fatal(args);
    }

    public static String info(String ... args) {
        return Debug.formatArgs(DBG_INFO, args);
    }

    public static void info(IDebugger dbg, String ... args) {
        if (dbg.isInfo()) {
            dbg.log(Debug.info(dbg.isMulti(), dbg.isTimer(), args), dbg.getInfoLevel());
        }
    }

    public static void info(IDebugger dbg, Throwable t, String ... args) {
        if (dbg.isInfo()) {
            dbg.log(Debug.info(dbg.isMulti(), dbg.isTimer(), args), t, dbg.getInfoLevel());
        }
    }

    public static void info(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.info(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    public static void info(IDebugger dbg, int lvl, Throwable t, String ... args) {
        dbg.log(Debug.info(dbg.isMulti(), dbg.isTimer(), args), t, lvl);
    }

    private static String info(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.info(args);
    }

    public static String inout(String ... args) {
        return Debug.formatArgs(DBG_INOUT, args);
    }

    public static void inout(IDebugger dbg, String ... args) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.inout(dbg.isMulti(), dbg.isTimer(), args), dbg.getFlowLevel());
        }
    }

    public static void inout(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.inout(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    private static String inout(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.inout(args);
    }

    public static String inter(String ... args) {
        return Debug.formatArgs(DBG_INTER, args);
    }

    public static void inter(IDebugger dbg, String ... args) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.inter(dbg.isMulti(), dbg.isTimer(), args), dbg.getFlowLevel());
        }
    }

    public static void inter(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.inter(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    private static String inter(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.inter(args);
    }

    public static String items(String ... args) {
        return Debug.formatArgs(DBG_ITEMS, args);
    }

    public static void items(IDebugger dbg, String ... args) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.items(dbg.isMulti(), dbg.isTimer(), args), dbg.getItemsLevel());
        }
    }

    public static void items(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.items(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    private static String items(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.items(args);
    }

    public static String leave(String ... args) {
        return Debug.formatArgs(DBG_LEAVE, args);
    }

    public static void leave(IDebugger dbg, String ... args) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.leave(dbg.isMulti(), dbg.isTimer(), args), dbg.getFlowLevel());
        }
    }

    public static void leave(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.leave(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    private static String leave(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.leave(args);
    }

    public static String setup(String ... args) {
        return Debug.formatArgsNoMnm(DBG_SETUP, args);
    }

    public static void setup(IDebugger dbg, String ... args) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.setup(dbg.isMulti(), dbg.isTimer(), args), dbg.getFlowLevel());
        }
    }

    public static void setup(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.setup(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    private static String setup(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.setup(args);
    }

    public static String start(String ... args) {
        return Debug.formatArgs(DBG_START, args);
    }

    public static void start(IDebugger dbg, String ... args) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.start(dbg.isMulti(), dbg.isTimer(), args), dbg.getFlowLevel());
        }
    }

    public static void start(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.start(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    private static String start(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.start(args);
    }

    public static String stops(String ... args) {
        return Debug.formatArgs(DBG_STOPS, args);
    }

    public static void stops(IDebugger dbg, String ... args) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.stops(dbg.isMulti(), dbg.isTimer(), args), dbg.getFlowLevel());
        }
    }

    public static void stops(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.stops(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    private static String stops(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.stops(args);
    }

    public static String trace(String ... args) {
        return Debug.formatArgs(DBG_TRACE, args);
    }

    public static void trace(IDebugger dbg, String ... args) {
        if (dbg.isDebugOn()) {
            dbg.log(Debug.trace(dbg.isMulti(), dbg.isTimer(), args), dbg.getTraceLevel());
        }
    }

    public static void trace(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.trace(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    private static String trace(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.trace(args);
    }

    public static String warn(String ... args) {
        return Debug.formatArgs(DBG_WARN, args);
    }

    public static void warn(IDebugger dbg, String ... args) {
        if (dbg.isWarn()) {
            dbg.log(Debug.warn(dbg.isMulti(), dbg.isTimer(), args), dbg.getWarnLevel());
        }
    }

    public static void warn(IDebugger dbg, Throwable t, String ... args) {
        if (dbg.isWarn()) {
            dbg.log(Debug.warn(dbg.isMulti(), dbg.isTimer(), args), t, dbg.getWarnLevel());
        }
    }

    public static void warn(IDebugger dbg, int lvl, String ... args) {
        dbg.log(Debug.warn(dbg.isMulti(), dbg.isTimer(), args), lvl);
    }

    public static void warn(IDebugger dbg, int lvl, Throwable t, String ... args) {
        dbg.log(Debug.warn(dbg.isMulti(), dbg.isTimer(), args), t, lvl);
    }

    private static String warn(boolean id, boolean ts, String ... args) {
        return String.valueOf(Debug.addThreadId(id)) + Debug.addTimeStamp(ts) + Debug.warn(args);
    }

    private static String addThreadId() {
        return String.format("[%d] ", Thread.currentThread().getId());
    }

    private static String addThreadId(boolean id) {
        return id ? String.format("[%d] ", Thread.currentThread().getId()) : DBG_EMPTY;
    }

    private static String addTimeStamp() {
        return SDF.format(new Date());
    }

    private static String addTimeStamp(boolean ts) {
        return ts ? SDF.format(new Date()) : DBG_EMPTY;
    }

    public static String format(String msg) {
        return Debug.format(msg, 0, 0);
    }

    public static String format(String msg, int lvl) {
        return Debug.format(msg, lvl, 0);
    }

    public static String format(String msg, int lvl, int flow) {
        switch (lvl) {
            case 100: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.fatal(msg);
            }
            case 200: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.error(msg);
            }
            case 300: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.warn(msg);
            }
            case 400: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.info(msg);
            }
            case 450: {
                switch (flow) {
                    case 1: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.setup(msg);
                    }
                    case 2: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.enter(msg);
                    }
                    case 3: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.leave(msg);
                    }
                    case 4: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.inout(msg);
                    }
                    case 5: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.start(msg);
                    }
                    case 6: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.stops(msg);
                    }
                    case 7: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.inter(msg);
                    }
                }
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.info(msg);
            }
            case 500: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.debug(msg);
            }
            case 600: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.trace(msg);
            }
            case 650: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.items(msg);
            }
        }
        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + msg;
    }

    public static String format(String ... args) {
        return Debug.format(0, 0, args);
    }

    public static String format(int lvl, String ... args) {
        return Debug.format(lvl, 0, args);
    }

    public static String format(int lvl, int flow, String ... args) {
        switch (lvl) {
            case 100: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.fatal(args);
            }
            case 200: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.error(args);
            }
            case 300: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.warn(args);
            }
            case 400: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.info(args);
            }
            case 450: {
                switch (flow) {
                    case 1: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.setup(args);
                    }
                    case 2: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.enter(args);
                    }
                    case 3: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.leave(args);
                    }
                    case 4: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.inout(args);
                    }
                    case 5: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.start(args);
                    }
                    case 6: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.stops(args);
                    }
                    case 7: {
                        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.inter(args);
                    }
                }
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.info(args);
            }
            case 500: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.debug(args);
            }
            case 600: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.trace(args);
            }
            case 650: {
                return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.items(args);
            }
        }
        return String.valueOf(Debug.addThreadId()) + Debug.addTimeStamp() + Debug.data(args);
    }

    private static void formattingArguments() {
    }

    private static String formatArgs(String type, String ... args) {
        StringBuffer sb = new StringBuffer(type);
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                sb.append(args[0]);
                break;
            }
            case 2: {
                sb.append(args[0]);
                sb.append(DBG_C_DOT);
                sb.append(args[1]);
                break;
            }
            case 3: {
                sb.append(args[0]);
                sb.append(DBG_C_DOT);
                sb.append(args[1]);
                sb.append(args[2].startsWith(DBG_DATAO) ? DBG_EMPTY : DBG_DATAO);
                sb.append(args[2]);
                sb.append(args[2].startsWith(DBG_DATAO) ? DBG_EMPTY : DBG_DATAC);
                break;
            }
            case 4: {
                sb.append(args[0]);
                sb.append(DBG_C_DOT);
                sb.append(args[1]);
                sb.append(DBG_DATAO);
                sb.append(args[2]);
                sb.append(DBG_C_CLN);
                sb.append(args[3]);
                sb.append(DBG_DATAC);
                break;
            }
            case 5: {
                sb.append(args[0]);
                sb.append(DBG_C_DOT);
                sb.append(args[1]);
                sb.append(args[2].startsWith(DBG_DATAO) ? DBG_EMPTY : DBG_DATAO);
                sb.append(args[2]);
                sb.append(args[2].startsWith(DBG_DATAO) ? DBG_EMPTY : DBG_DATAC);
                sb.append(DBG_DATAO);
                sb.append(args[3]);
                sb.append(DBG_C_CLN);
                sb.append(args[4]);
                sb.append(DBG_DATAC);
                break;
            }
            default: {
                sb.append(args[0]);
                sb.append(DBG_C_DOT);
                sb.append(args[1]);
                sb.append(DBG_DATAO);
                sb.append(args[2]);
                sb.append(DBG_C_CLN);
                sb.append(args[3]);
                sb.append(DBG_DATAC);
                sb.append(DBG_DATAO);
                sb.append(args[4]);
                sb.append(DBG_C_CLN);
                sb.append(args[5]);
                sb.append(DBG_DATAC);
            }
        }
        return sb.toString();
    }

    private static String formatArgsNoMnm(String type, String ... args) {
        StringBuffer sb = new StringBuffer(type);
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                sb.append(args[0]);
                break;
            }
            case 2: {
                sb.append(args[0]);
                sb.append(args[1].startsWith(DBG_DATAO) ? DBG_EMPTY : DBG_DATAO);
                sb.append(args[1]);
                sb.append(args[1].startsWith(DBG_DATAO) ? DBG_EMPTY : DBG_DATAC);
                break;
            }
            case 3: {
                sb.append(args[0]);
                sb.append(DBG_DATAO);
                sb.append(args[1]);
                sb.append(DBG_C_CLN);
                sb.append(args[2]);
                sb.append(DBG_DATAC);
                break;
            }
            case 4: {
                sb.append(args[0]);
                sb.append(args[1].startsWith(DBG_DATAO) ? DBG_EMPTY : DBG_DATAO);
                sb.append(args[1]);
                sb.append(args[1].startsWith(DBG_DATAO) ? DBG_EMPTY : DBG_DATAC);
                sb.append(DBG_DATAO);
                sb.append(args[2]);
                sb.append(DBG_C_CLN);
                sb.append(args[3]);
                sb.append(DBG_DATAC);
                break;
            }
            default: {
                sb.append(args[0]);
                sb.append(DBG_DATAO);
                sb.append(args[1]);
                sb.append(DBG_C_CLN);
                sb.append(args[2]);
                sb.append(DBG_DATAC);
                sb.append(DBG_DATAO);
                sb.append(args[3]);
                sb.append(DBG_C_CLN);
                sb.append(args[4]);
                sb.append(DBG_DATAC);
            }
        }
        return sb.toString();
    }
}

