/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugLogMsg;
import com.ibm.team.build.extensions.common.debug.IDebugLogger;
import com.ibm.team.build.extensions.common.debug.IDebugger;

public abstract class AbstractDebugger
implements IDebugger {
    protected final String cls = this.getClass().getSimpleName();
    protected int fatalLevel;
    protected int errorLevel;
    protected int warnLevel;
    protected int infoLevel;
    protected int flowLevel;
    protected int debugLevel;
    protected int traceLevel;
    protected int itemsLevel;
    private IDebugLogMsg logMsg;
    private IDebugLogger logger;
    private boolean debugOn = false;
    private boolean timerOn = false;
    private boolean multi = false;
    private boolean timer = false;
    private int logLevel = 400;

    @Override
    public abstract boolean isFatal();

    @Override
    public abstract boolean isError();

    @Override
    public abstract boolean isWarn();

    @Override
    public abstract boolean isInfo();

    @Override
    public abstract boolean isFlow();

    @Override
    public abstract boolean isDebug();

    @Override
    public abstract boolean isTrace();

    @Override
    public abstract boolean isItems();

    @Override
    public abstract void setFatal(boolean var1);

    @Override
    public abstract void setError(boolean var1);

    @Override
    public abstract void setWarn(boolean var1);

    @Override
    public abstract void setInfo(boolean var1);

    @Override
    public abstract void setFlow(boolean var1);

    @Override
    public abstract void setDebug(boolean var1);

    @Override
    public abstract void setTrace(boolean var1);

    @Override
    public abstract void setItems(boolean var1);

    public void fatal(String s) {
        this.log(s, this.fatalLevel);
    }

    public void error(String s) {
        this.log(s, this.errorLevel);
    }

    public void warn(String s) {
        this.log(s, this.warnLevel);
    }

    public void info(String s) {
        this.log(s, this.infoLevel);
    }

    public void flow(String s) {
        this.log(s, this.flowLevel);
    }

    public void debug(String s) {
        this.log(s, this.debugLevel);
    }

    public void trace(String s) {
        this.log(s, this.traceLevel);
    }

    public void items(String s) {
        this.log(s, this.itemsLevel);
    }

    @Override
    public void log(String s) {
        if (this.logger == null) {
            this.logMsg.log(s);
        } else {
            this.logger.log(s);
        }
    }

    @Override
    public void log(String s, int level) {
        if (this.logger == null) {
            this.logMsg.log(s, level);
        } else {
            this.logger.log(s, level);
        }
    }

    public void fatal(Throwable t) {
        this.log(t, this.fatalLevel);
    }

    public void error(Throwable t) {
        this.log(t, this.errorLevel);
    }

    public void warn(Throwable t) {
        this.log(t, this.warnLevel);
    }

    public void info(Throwable t) {
        this.log(t, this.infoLevel);
    }

    public void flow(Throwable t) {
        this.log(t, this.flowLevel);
    }

    public void debug(Throwable t) {
        this.log(t, this.debugLevel);
    }

    public void trace(Throwable t) {
        this.log(t, this.traceLevel);
    }

    public void items(Throwable t) {
        this.log(t, this.itemsLevel);
    }

    @Override
    public void log(Throwable t) {
        if (this.logger == null) {
            this.logMsg.log(t, this.infoLevel);
        } else {
            this.logger.log(t);
        }
    }

    @Override
    public void log(Throwable t, int level) {
        if (this.logger == null) {
            this.logMsg.log(t, level);
        } else {
            this.logger.log(t, level);
        }
    }

    public void fatal(String s, Throwable t) {
        this.log(s, t, this.fatalLevel);
    }

    public void error(String s, Throwable t) {
        this.log(s, t, this.errorLevel);
    }

    public void warn(String s, Throwable t) {
        this.log(s, t, this.warnLevel);
    }

    public void info(String s, Throwable t) {
        this.log(s, t, this.infoLevel);
    }

    public void flow(String s, Throwable t) {
        this.log(s, t, this.flowLevel);
    }

    public void debug(String s, Throwable t) {
        this.log(s, t, this.debugLevel);
    }

    public void trace(String s, Throwable t) {
        this.log(s, t, this.traceLevel);
    }

    public void items(String s, Throwable t) {
        this.log(s, t, this.itemsLevel);
    }

    @Override
    public void log(String s, Throwable t) {
        if (this.logger == null) {
            this.logMsg.log(s, t, this.infoLevel);
        } else {
            this.logger.log(s, t);
        }
    }

    @Override
    public void log(String s, Throwable t, int level) {
        if (this.logger == null) {
            this.logMsg.log(s, t, level);
        } else {
            this.logger.log(s, t, level);
        }
    }

    @Override
    public void logMsg(String s) {
        this.log(Debug.format(s, this.infoLevel));
    }

    @Override
    public void logMsg(String s, int level) {
        this.log(Debug.format(s, this.toFormatLevel(level)), level);
    }

    @Override
    public void logMsg(Throwable t) {
        this.log(Debug.format(t.getMessage(), this.infoLevel), t);
    }

    @Override
    public void logMsg(Throwable t, int level) {
        this.log(Debug.format(t.getMessage(), this.toFormatLevel(level)), t, level);
    }

    @Override
    public void logMsg(String s, Throwable t) {
        this.log(Debug.format(s, this.infoLevel), t);
    }

    @Override
    public void logMsg(String s, Throwable t, int level) {
        this.log(Debug.format(s, this.toFormatLevel(level)), t, level);
    }

    @Override
    public int getFatalLevel() {
        return this.fatalLevel;
    }

    @Override
    public int getErrorLevel() {
        return this.errorLevel;
    }

    @Override
    public int getWarnLevel() {
        return this.warnLevel;
    }

    @Override
    public int getInfoLevel() {
        return this.infoLevel;
    }

    @Override
    public int getFlowLevel() {
        return this.flowLevel;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public int getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public int getItemsLevel() {
        return this.itemsLevel;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public IDebugLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isOn() {
        return this.logger == null ? this.debugOn || this.timerOn : this.logger.isDebugOn() || this.timerOn;
    }

    @Override
    public boolean isDebugOn() {
        return this.debugOn;
    }

    @Override
    public boolean isTimerOn() {
        return this.timerOn;
    }

    @Override
    public boolean isMulti() {
        return this.multi;
    }

    @Override
    public boolean isTimer() {
        return this.timer;
    }

    @Override
    public void setDebugOn(boolean debugOn) {
        this.debugOn = debugOn;
    }

    @Override
    public void setTimerOn(boolean timerOn) {
        this.timerOn = timerOn;
    }

    @Override
    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    @Override
    public void setTimer(boolean timer) {
        this.timer = timer;
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    protected void setLogLevel() {
        this.setLogLevel(0);
        if (this.isFatal()) {
            this.setLogLevel(Math.max(this.logLevel, this.getFatalLevel()));
        }
        if (this.isError()) {
            this.setLogLevel(Math.max(this.logLevel, this.getErrorLevel()));
        }
        if (this.isWarn()) {
            this.setLogLevel(Math.max(this.logLevel, this.getWarnLevel()));
        }
        if (this.isInfo()) {
            this.setLogLevel(Math.max(this.logLevel, this.getInfoLevel()));
        }
        if (this.isFlow()) {
            this.setLogLevel(Math.max(this.logLevel, this.getFlowLevel()));
        }
        if (this.isDebug()) {
            this.setLogLevel(Math.max(this.logLevel, this.getDebugLevel()));
        }
        if (this.isTrace()) {
            this.setLogLevel(Math.max(this.logLevel, this.getTraceLevel()));
        }
        if (this.isItems()) {
            this.setLogLevel(Math.max(this.logLevel, this.getItemsLevel()));
        }
    }

    @Override
    public void setLogger(IDebugLogger logger) {
        this.logger = logger;
        if (logger != null) {
            this.setLogLevel(0);
            this.setFatal(logger.isFatalEnabled());
            this.setError(logger.isErrorEnabled());
            this.setWarn(logger.isWarnEnabled());
            this.setInfo(logger.isInfoEnabled());
            this.setFlow(logger.isInfoEnabled());
            this.setDebug(logger.isDebugEnabled());
            this.setTrace(logger.isTraceEnabled());
            this.setItems(logger.isItemsEnabled());
            this.setLogLevel();
            if (logger.isDebugOn()) {
                this.setDebugOn(true);
            } else {
                this.setDebugOn(false);
            }
        }
    }

    @Override
    public void setLogMsg(IDebugLogMsg logMsg) {
        this.logMsg = logMsg;
    }

    protected void setStates(int value) {
        switch (value) {
            case 7: {
                this.setItems(true);
            }
            case 6: {
                this.setTrace(true);
            }
            case 5: {
                this.setDebug(true);
            }
            case 4: {
                this.setFlow(true);
            }
            case 3: {
                this.setInfo(true);
            }
            case 2: {
                this.setWarn(true);
            }
            case 1: {
                this.setError(true);
            }
            case 0: {
                this.setFatal(true);
            }
        }
    }

    protected void setInfoLevel() {
    }

    protected void setFlowLevel(int flowLevel) {
        this.flowLevel = flowLevel;
    }

    protected void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    protected void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    protected void setItemsLevel(int itemsLevel) {
        this.itemsLevel = itemsLevel;
    }

    @Override
    public int toFormatLevel(int level) {
        return level;
    }
}

