/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common;

import com.ibm.team.build.extensions.common.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TransformerKeys {
    public static final String AMOUNT = "4";
    public static final String ENCODING = "UTF-8";
    public static final String INDENT = "yes";
    public static final String METHOD = "xml";
    public static final String FMT_INDENT1 = StringUtil.copies(' ', 4);
    public static final String FMT_INDENT2 = StringUtil.copies(' ', 8);
    public static final String FMT_INDENT3 = StringUtil.copies(' ', 12);
    public static final String FMT_INDENT1_PATTERN = "(.*)\n(" + FMT_INDENT1 + "\\<!-- .*? --\\>)(.*)";
    public static final String FMT_INDENT2_PATTERN = "(.*)\n(" + FMT_INDENT2 + "\\<!-- .*? --\\>)(.*)";
    public static final String FMT_INDENT3_PATTERN = "(.*)(" + FMT_INDENT3 + "\\<!-- .*? --\\>)(.*)";
    public static final String FMT_ATTRIBUTE_RGX = "\" ";
    public static final String FMT_ATTRIBUTE_RPL = "\"\n" + FMT_INDENT3;
    public static final String FMT_ATTRPROPS_RGX = "$";
    public static final String FMT_ATTRPROPS_RPL = "\\$";
    public static final String FMT_COPYRIGHTS_RGX = "--\\><";
    public static final String FMT_COPYRIGHTS_RPL = "-->\n<";
    public static final String FMT_XMLVERSION_RGX = "\\?\\><";
    public static final String FMT_XMLVERSION_RPL = "?>\n<";
    public static final String KEY_INDENTAMOUNT = "{http://xml.apache.org/xslt}indent-amount";

    private TransformerKeys() {
    }

    public static class TransformerUtil {
        public static String formatComment1Task(String xml) {
            Pattern p = Pattern.compile(FMT_INDENT1_PATTERN);
            Matcher m = p.matcher(xml);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, String.valueOf(Matcher.quoteReplacement(m.group(1))) + "\n" + FMT_INDENT1 + "\n" + Matcher.quoteReplacement(m.group(2)));
            }
            m.appendTail(sb);
            return sb.toString();
        }

        public static String formatComment2Task(String xml) {
            Pattern p = Pattern.compile(FMT_INDENT2_PATTERN);
            Matcher m = p.matcher(xml);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, String.valueOf(Matcher.quoteReplacement(m.group(1))) + "\n" + FMT_INDENT2 + "\n" + Matcher.quoteReplacement(m.group(2)));
            }
            m.appendTail(sb);
            return sb.toString();
        }

        public static String formatComment3Task(String xml) {
            Pattern p = Pattern.compile(FMT_INDENT3_PATTERN);
            Matcher m = p.matcher(xml);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, String.valueOf(Matcher.quoteReplacement(m.group(1))) + FMT_INDENT3 + "\n" + Matcher.quoteReplacement(m.group(2)));
            }
            m.appendTail(sb);
            return sb.toString();
        }

        public static String formatHeader(String xml) {
            String result = xml;
            result = result.replaceFirst(TransformerKeys.FMT_XMLVERSION_RGX, TransformerKeys.FMT_XMLVERSION_RPL);
            result = result.replaceFirst(TransformerKeys.FMT_COPYRIGHTS_RGX, TransformerKeys.FMT_COPYRIGHTS_RPL);
            return result;
        }

        public static String formatTask(String xml, String task) {
            Pattern p = Pattern.compile(TransformerUtil.getTaskPattern(task));
            Matcher m = p.matcher(xml);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, String.valueOf(m.group(1)) + m.group(2).replace(TransformerUtil.getTaskRgx(task), TransformerUtil.getTaskRpl(task)).replace(TransformerKeys.FMT_ATTRIBUTE_RGX, FMT_ATTRIBUTE_RPL).replace(TransformerKeys.FMT_ATTRPROPS_RGX, TransformerKeys.FMT_ATTRPROPS_RPL));
            }
            m.appendTail(sb);
            return sb.toString();
        }

        public static String getTaskPattern(String task) {
            return "(.*)(\\<" + task + " .*?\\>)(.*)";
        }

        public static String getTaskRgx(String task) {
            return "<" + task + " ";
        }

        public static String getTaskRpl(String task) {
            return "<" + task + "\n" + FMT_INDENT3;
        }
    }
}

