/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common;

import com.ibm.team.build.extensions.common.IBuildExtensionsTypeItem;
import com.ibm.team.build.extensions.common.IBuildExtensionsTypeItemI;
import com.ibm.team.build.extensions.common.IBuildExtensionsTypeItemZ;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class BuildExtensionsTypeItem {
    private static final String className = BuildExtensionsTypeItem.class.getSimpleName();
    private static BuildExtensionsTypeItem instance;
    private Object instanceObject;
    private final Map<String, IBuildExtensionsTypeItem> itemMap = new HashMap<String, IBuildExtensionsTypeItem>();
    private final Map<String, IBuildExtensionsTypeItem> itemMapI = new HashMap<String, IBuildExtensionsTypeItem>();
    private final Map<String, IBuildExtensionsTypeItem> itemMapZ = new HashMap<String, IBuildExtensionsTypeItem>();

    private BuildExtensionsTypeItem() {
    }

    public static synchronized BuildExtensionsTypeItem getInstance() {
        return instance;
    }

    public static synchronized BuildExtensionsTypeItem getInstance(Object o, IDebugger dbg) {
        if (instance == null) {
            instance = new BuildExtensionsTypeItem();
            instance.setInstanceObject(o);
            instance.load(dbg);
        }
        if (!o.equals(instance.getInstanceObject(o))) {
            instance.setInstanceObject(o);
            instance.clear();
            instance.load(dbg);
        }
        return instance;
    }

    public Map<String, IBuildExtensionsTypeItem> getItemMap() {
        return this.itemMap;
    }

    public Map<String, IBuildExtensionsTypeItem> getItemMapI() {
        return this.itemMapI;
    }

    public Map<String, IBuildExtensionsTypeItem> getItemMapZ() {
        return this.itemMapZ;
    }

    private void clear() {
        this.itemMap.clear();
    }

    private void load(IDebugger dbg) throws ServiceConfigurationError {
        ServiceLoader<IBuildExtensionsTypeItem> loader = ServiceLoader.load(IBuildExtensionsTypeItem.class);
        for (IBuildExtensionsTypeItem item : loader) {
            if (item instanceof IBuildExtensionsTypeItemI) {
                this.itemMapI.put(item.getName(), item);
            } else if (item instanceof IBuildExtensionsTypeItemZ) {
                this.itemMapZ.put(item.getName(), item);
            } else {
                this.itemMap.put(item.getName(), item);
            }
            if (!dbg.isItems()) continue;
            Debug.items(dbg, className, new MethodName(){}.getName(), "item", LogString.valueOf(item.getName()));
        }
        this.itemMapI.putAll(this.itemMap);
        this.itemMapZ.putAll(this.itemMap);
        if (dbg.isDebug()) {
            Debug.inout(dbg, className, new MethodName(){}.getName(), this.getMessageToken());
        }
    }

    private String getMessageToken() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.itemMap.size());
        sb.append(",");
        sb.append('i');
        sb.append(":");
        sb.append(this.itemMapI.size());
        sb.append(",");
        sb.append('z');
        sb.append(":");
        sb.append(this.itemMapZ.size());
        return sb.toString();
    }

    private Object getInstanceObject(Object o) {
        return this.instanceObject;
    }

    private void setInstanceObject(Object o) {
        this.instanceObject = o;
    }
}

