/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common;

import com.ibm.team.build.extensions.common.IBuildExtensionsTaskItem;
import com.ibm.team.build.extensions.common.IBuildExtensionsTaskItemI;
import com.ibm.team.build.extensions.common.IBuildExtensionsTaskItemZ;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class BuildExtensionsTaskItem {
    private static final String className = BuildExtensionsTaskItem.class.getSimpleName();
    private static BuildExtensionsTaskItem instance;
    private Object instanceObject;
    private final Map<String, IBuildExtensionsTaskItem> itemMap = new HashMap<String, IBuildExtensionsTaskItem>();
    private final Map<String, IBuildExtensionsTaskItem> itemMapI = new HashMap<String, IBuildExtensionsTaskItem>();
    private final Map<String, IBuildExtensionsTaskItem> itemMapZ = new HashMap<String, IBuildExtensionsTaskItem>();

    private BuildExtensionsTaskItem() {
    }

    public static synchronized BuildExtensionsTaskItem getInstance() {
        return instance;
    }

    public static synchronized BuildExtensionsTaskItem getInstance(Object o, IDebugger dbg) {
        if (instance == null) {
            instance = new BuildExtensionsTaskItem();
            instance.setInstanceObject(o);
            instance.load(dbg);
        }
        if (!o.equals(instance.getInstanceObject(o))) {
            instance.setInstanceObject(o);
            instance.clear();
            instance.load(dbg);
        }
        return instance;
    }

    public Map<String, IBuildExtensionsTaskItem> getItemMap() {
        return this.itemMap;
    }

    public Map<String, IBuildExtensionsTaskItem> getItemMapI() {
        return this.itemMapI;
    }

    public Map<String, IBuildExtensionsTaskItem> getItemMapZ() {
        return this.itemMapZ;
    }

    private void clear() {
        this.itemMap.clear();
    }

    private void load(IDebugger dbg) throws ServiceConfigurationError {
        ServiceLoader<IBuildExtensionsTaskItem> loader = ServiceLoader.load(IBuildExtensionsTaskItem.class);
        for (IBuildExtensionsTaskItem item : loader) {
            if (item instanceof IBuildExtensionsTaskItemI) {
                this.itemMapI.put(item.getName(), item);
            } else if (item instanceof IBuildExtensionsTaskItemZ) {
                this.itemMapZ.put(item.getName(), item);
            } else {
                this.itemMap.put(item.getName(), item);
            }
            if (!dbg.isItems()) continue;
            Debug.items(dbg, className, new MethodName(){}.getName(), "item", LogString.valueOf(item.getName()));
        }
        this.itemMapI.putAll(this.itemMap);
        this.itemMapZ.putAll(this.itemMap);
        if (dbg.isDebug()) {
            Debug.inout(dbg, className, new MethodName(){}.getName(), this.getMessageToken());
        }
    }

    private String getMessageToken() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.itemMap.size());
        sb.append(",");
        sb.append('i');
        sb.append(":");
        sb.append(this.itemMapI.size());
        sb.append(",");
        sb.append('z');
        sb.append(":");
        sb.append(this.itemMapZ.size());
        return sb.toString();
    }

    private Object getInstanceObject(Object o) {
        return this.instanceObject;
    }

    private void setInstanceObject(Object o) {
        this.instanceObject = o;
    }
}

