/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common;

import com.ibm.team.build.extensions.common.IBuildEngineConfigurationDetailsEnumeration;
import com.ibm.team.build.extensions.common.IBuildEngineDetails;
import com.ibm.team.build.extensions.common.IBuildEngineDetailsEnumeration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildEngineDetails
implements IBuildEngineDetails {
    private final String id;
    private static final Map<String, IBuildEngineDetailsEnumeration.EngineTemplate> templateMap;

    static {
        HashMap<String, IBuildEngineDetailsEnumeration.EngineTemplate> loadMap = new HashMap<String, IBuildEngineDetailsEnumeration.EngineTemplate>();
        loadMap.put(IBuildEngineDetailsEnumeration.EngineTemplate.DEFAULT.getId(), IBuildEngineDetailsEnumeration.EngineTemplate.DEFAULT);
        loadMap.put(IBuildEngineDetailsEnumeration.EngineTemplate.HUDSON.getId(), IBuildEngineDetailsEnumeration.EngineTemplate.HUDSON);
        loadMap.put(IBuildEngineDetailsEnumeration.EngineTemplate.JBE.getId(), IBuildEngineDetailsEnumeration.EngineTemplate.JBE);
        loadMap.put(IBuildEngineDetailsEnumeration.EngineTemplate.RBA.getId(), IBuildEngineDetailsEnumeration.EngineTemplate.RBA);
        loadMap.put(IBuildEngineDetailsEnumeration.EngineTemplate.RBF.getId(), IBuildEngineDetailsEnumeration.EngineTemplate.RBF);
        templateMap = Collections.unmodifiableMap(loadMap);
    }

    public BuildEngineDetails(String id) {
        this.id = id;
    }

    public static final IBuildEngineDetailsEnumeration.EngineTemplate getTemplate(String id) {
        return id == null ? null : (templateMap.containsKey(id) ? templateMap.get(id) : null);
    }

    public static final String getTemplateIdFromAlias(String id) {
        String result = null;
        if (id != null) {
            IBuildEngineDetailsEnumeration.EngineTemplate[] engineTemplateArray = IBuildEngineDetailsEnumeration.EngineTemplate.values();
            int n = engineTemplateArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildEngineDetailsEnumeration.EngineTemplate bt = engineTemplateArray[n2];
                if (bt.getAliasList().contains(id)) {
                    result = bt.getId();
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static final Map<String, IBuildEngineDetailsEnumeration.EngineTemplate> getTemplateMap() {
        return templateMap;
    }

    @Override
    public final String getId() {
        return templateMap.get(this.id).getId();
    }

    @Override
    public final String getElementId() {
        return templateMap.get(this.id).getId();
    }

    @Override
    public final String getName() {
        return templateMap.get(this.id).getName();
    }

    @Override
    public final String getDescription() {
        return templateMap.get(this.id).getDescription();
    }

    @Override
    public final IBuildEngineDetailsEnumeration.EngineTemplate getEngineTemplate() {
        return templateMap.get(this.id).getEngineTemplate();
    }

    @Override
    public final List<String> getAliasList() {
        return templateMap.get(this.id).getAliasList();
    }

    @Override
    public final boolean isDefinitionDataRequired() {
        return templateMap.get(this.id).isDefinitionDataRequired();
    }

    @Override
    public final boolean isHdsn() {
        return templateMap.get(this.id).isHdsn();
    }

    @Override
    public final boolean isJbe() {
        return templateMap.get(this.id).isJbe();
    }

    @Override
    public final boolean isRba() {
        return templateMap.get(this.id).isRba();
    }

    @Override
    public final boolean isRbf() {
        return templateMap.get(this.id).isRbf();
    }

    @Override
    public final IBuildEngineConfigurationDetailsEnumeration.EngineConfigurationElement getRequiredElement() {
        return templateMap.get(this.id).getRequiredElement();
    }

    @Override
    public final List<IBuildEngineConfigurationDetailsEnumeration.EngineConfigurationElement> getSupportedElements() {
        return templateMap.get(this.id).getSupportedElements();
    }

    public static final boolean isTemplateAlias(String id) {
        boolean result = false;
        if (id != null) {
            IBuildEngineDetailsEnumeration.EngineTemplate[] engineTemplateArray = IBuildEngineDetailsEnumeration.EngineTemplate.values();
            int n = engineTemplateArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildEngineDetailsEnumeration.EngineTemplate bt = engineTemplateArray[n2];
                if (bt.getAliasList().contains(id)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static final boolean isTemplateValid(String id) {
        return id != null ? templateMap.containsKey(id) : false;
    }
}

