/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common;

import com.ibm.team.build.extensions.common.IBuildEngineConfigurationElementItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class BuildEngineConfigurationElementItem {
    private static final String className = BuildEngineConfigurationElementItem.class.getSimpleName();
    private static BuildEngineConfigurationElementItem instance;
    private Object instanceObject;
    private final Map<String, IBuildEngineConfigurationElementItem<?>> elementMap = new HashMap();

    private BuildEngineConfigurationElementItem() {
    }

    public static synchronized BuildEngineConfigurationElementItem getInstance() {
        return instance;
    }

    public static synchronized BuildEngineConfigurationElementItem getInstance(Object o, IDebugger dbg) {
        if (instance == null) {
            instance = new BuildEngineConfigurationElementItem();
            instance.setInstanceObject(o);
            instance.load(dbg);
        }
        if (!o.equals(instance.getInstanceObject(o))) {
            instance.setInstanceObject(o);
            instance.clear();
            instance.load(dbg);
        }
        return instance;
    }

    public synchronized Map<String, IBuildEngineConfigurationElementItem<?>> getElementMap() {
        return this.elementMap;
    }

    private void clear() {
        this.elementMap.clear();
    }

    private void load(IDebugger dbg) throws ServiceConfigurationError {
        ServiceLoader<IBuildEngineConfigurationElementItem> loader = ServiceLoader.load(IBuildEngineConfigurationElementItem.class);
        for (IBuildEngineConfigurationElementItem element : loader) {
            this.elementMap.put(element.getElementId(), element);
            if (!dbg.isItems()) continue;
            Debug.items(dbg, className, new MethodName(){}.getName(), "item", LogString.valueOf(element.getElementId()));
        }
        if (dbg.isDebug()) {
            Debug.inout(dbg, className, new MethodName(){}.getName(), Integer.toString(this.elementMap.size()));
        }
    }

    private Object getInstanceObject(Object o) {
        return this.instanceObject;
    }

    private void setInstanceObject(Object o) {
        this.instanceObject = o;
    }
}

