/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common;

import com.ibm.team.build.extensions.common.IBuildDefinitionElementItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class BuildDefinitionElementItem {
    private static final String className = BuildDefinitionElementItem.class.getSimpleName();
    private static BuildDefinitionElementItem instance;
    private final Map<String, IBuildDefinitionElementItem> elementMap = new HashMap<String, IBuildDefinitionElementItem>();

    private BuildDefinitionElementItem() {
    }

    public static BuildDefinitionElementItem getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BuildDefinitionElementItem getInstance(IDebugger dbg) {
        if (instance != null) return instance;
        Class<BuildDefinitionElementItem> clazz = BuildDefinitionElementItem.class;
        synchronized (BuildDefinitionElementItem.class) {
            if (instance != null) return instance;
            instance = new BuildDefinitionElementItem();
            instance.load(dbg);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, IBuildDefinitionElementItem> getElementMap() {
        return this.elementMap;
    }

    private void load(IDebugger dbg) throws ServiceConfigurationError {
        ServiceLoader<IBuildDefinitionElementItem> loader = ServiceLoader.load(IBuildDefinitionElementItem.class);
        for (IBuildDefinitionElementItem element : loader) {
            this.elementMap.put(element.getElementId(), element);
            if (!dbg.isItems()) continue;
            Debug.items(dbg, className, new MethodName(){}.getName(), "item", LogString.valueOf(element.getElementId()));
        }
        if (dbg.isDebug()) {
            Debug.inout(dbg, className, new MethodName(){}.getName(), Integer.toString(this.elementMap.size()));
        }
    }
}

