/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common;

import com.ibm.team.build.extensions.common.BuildDefinitionElementItem;
import com.ibm.team.build.extensions.common.IBuildDefinitionDetails;
import com.ibm.team.build.extensions.common.IBuildDefinitionElementItem;
import com.ibm.team.build.extensions.common.IBuildEngineDetailsEnumeration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildDefinitionDetails
implements IBuildDefinitionDetails {
    private final String id;
    private static final Map<String, IBuildDefinitionElementItem> templateMap;

    static {
        BuildDefinitionElementItem elementItemInstance = BuildDefinitionElementItem.getInstance();
        HashMap<String, IBuildDefinitionElementItem> loadMap = new HashMap<String, IBuildDefinitionElementItem>();
        loadMap.putAll(elementItemInstance.getElementMap());
        templateMap = Collections.unmodifiableMap(loadMap);
    }

    public BuildDefinitionDetails(String id) {
        this.id = id;
    }

    public static final IBuildDefinitionElementItem getTemplate(String id) {
        return id == null ? null : (templateMap.containsKey(id) ? templateMap.get(id) : null);
    }

    public static final String getTemplateIdFromAlias(String id) {
        String result = null;
        if (id != null) {
            for (IBuildDefinitionElementItem bt : templateMap.values()) {
                if (!bt.getAliasList().contains(id)) continue;
                result = bt.getId();
                break;
            }
        }
        return result;
    }

    public static final Map<String, IBuildDefinitionElementItem> getTemplateMap() {
        return templateMap;
    }

    @Override
    public final String getId() {
        return templateMap.get(this.id).getId();
    }

    @Override
    public final String getElementId() {
        return templateMap.get(this.id).getElementId();
    }

    @Override
    public final String getName() {
        return templateMap.get(this.id).getName();
    }

    @Override
    public final String getDescription() {
        return templateMap.get(this.id).getDescription();
    }

    @Override
    public final IBuildEngineDetailsEnumeration.EngineTemplate getEngineTemplate() {
        return templateMap.get(this.id).getEngineTemplate();
    }

    @Override
    public final List<String> getAliasList() {
        return templateMap.get(this.id).getAliasList();
    }

    @Override
    public final boolean hasBuildFolderSupport() {
        return templateMap.get(this.id).hasBuildFolderSupport();
    }

    @Override
    public final boolean isDefinitionDataRequired() {
        return templateMap.get(this.id).isDefinitionDataRequired();
    }

    @Override
    public final boolean isIbmiDefinitionDataRequired() {
        return templateMap.get(this.id).isIbmiDefinitionDataRequired();
    }

    @Override
    public final String getRequiredElement() {
        return templateMap.get(this.id).getRequiredElement();
    }

    @Override
    public final String getRequiredDetails() {
        return templateMap.get(this.id).getRequiredDetails();
    }

    @Override
    public final List<String> getSupportedElements() {
        return templateMap.get(this.id).getSupportedElements();
    }

    @Override
    public final List<String> getDefaultedElements() {
        return templateMap.get(this.id).getDefaultedElements();
    }

    public static final boolean isTemplateAlias(String id) {
        boolean result = false;
        if (id != null) {
            for (IBuildDefinitionElementItem bt : templateMap.values()) {
                if (!bt.getAliasList().contains(id)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static final boolean isTemplateValid(String id) {
        return id != null ? templateMap.containsKey(id) : false;
    }
}

