/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common;

import com.ibm.team.build.extensions.common.IBuildConfigurationElementItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class BuildConfigurationElementItem {
    private static final String className = BuildConfigurationElementItem.class.getSimpleName();
    private static BuildConfigurationElementItem instance;
    private Object instanceObject;
    private final Map<String, IBuildConfigurationElementItem<?>> elementMap = new HashMap();

    private BuildConfigurationElementItem() {
    }

    public static synchronized BuildConfigurationElementItem getInstance() {
        return instance;
    }

    public static synchronized BuildConfigurationElementItem getInstance(Object o, IDebugger dbg) {
        if (instance == null) {
            instance = new BuildConfigurationElementItem();
            instance.setInstanceObject(o);
            instance.load(dbg);
        }
        if (!o.equals(instance.getInstanceObject(o))) {
            instance.setInstanceObject(o);
            instance.clear();
            instance.load(dbg);
        }
        return instance;
    }

    public synchronized Map<String, IBuildConfigurationElementItem<?>> getElementMap() {
        return this.elementMap;
    }

    private void clear() {
        this.elementMap.clear();
    }

    private void load(IDebugger dbg) throws ServiceConfigurationError {
        ServiceLoader<IBuildConfigurationElementItem> loader = ServiceLoader.load(IBuildConfigurationElementItem.class);
        for (IBuildConfigurationElementItem element : loader) {
            this.elementMap.put(element.getElementId(), element);
            if (!dbg.isItems()) continue;
            Debug.items(dbg, className, new MethodName(){}.getName(), "item", LogString.valueOf(element.getElementId()));
        }
        if (dbg.isDebug()) {
            Debug.inout(dbg, className, new MethodName(){}.getName(), Integer.toString(this.elementMap.size()));
        }
    }

    private Object getInstanceObject(Object o) {
        return this.instanceObject;
    }

    private void setInstanceObject(Object o) {
        this.instanceObject = o;
    }
}

