/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common;

public class Assert {
    private static String FailedMessage = "Assertion failed: %s";
    private static String FailedIsFalse = "isFalse";
    private static String FailedIsTrue = "isTrue";
    private static String FailedIsNull = "isNull";
    private static String FailedIsNotNull = "isNotNull";
    private static String FailedIsEqual = "isEqual";
    private static String FailedIsNotEqual = "isNotEqual";

    public static final void isFalse(boolean value) {
        if (value) {
            throw new AssertionError((Object)String.format(FailedMessage, FailedIsFalse));
        }
    }

    public static final void isTrue(boolean value) {
        if (!value) {
            throw new AssertionError((Object)String.format(FailedMessage, FailedIsTrue));
        }
    }

    public static final void isNull(Object value) {
        if (value != null) {
            throw new AssertionError((Object)String.format(FailedMessage, FailedIsNull));
        }
    }

    public static final void isNotNull(Object value) {
        if (value == null) {
            throw new AssertionError((Object)String.format(FailedMessage, FailedIsNotNull));
        }
    }

    public static final void isEqual(Object actual, Object expected) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        throw new AssertionError((Object)String.format(FailedMessage, FailedIsEqual));
    }

    public static final void isNotEqual(Object actual, Object expected) {
        if (expected == null && actual != null) {
            return;
        }
        if (expected != null && !expected.equals(actual)) {
            return;
        }
        throw new AssertionError((Object)String.format(FailedMessage, FailedIsNotEqual));
    }
}

