/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.client.nls.Messages;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class SCMWorkspace {
    private static final String className = SCMWorkspace.class.getSimpleName();

    public static IWorkspaceConnection createWorkspace(ITeamRepository repository, String workspaceName, String workspaceDescription) throws TeamRepositoryException {
        return SCMWorkspace.createWorkspace(repository, workspaceName, workspaceDescription, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceConnection createWorkspace(ITeamRepository repository, String workspaceName, String workspaceDescription, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.createWorkspace(repository, workspaceName, workspaceDescription, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceConnection createWorkspace(ITeamRepository repository, String workspaceName, String workspaceDescription, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.createWorkspace(repository, workspaceName, workspaceDescription, null, dbg);
    }

    public static IWorkspaceConnection createWorkspace(ITeamRepository repository, String workspaceName, String workspaceDescription, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection result = workspaceManager.createWorkspace((IContributorHandle)repository.loggedInContributor(), workspaceName, workspaceDescription, monitor);
        IPublicScope readScope = IReadScope.FACTORY.createPublicScope();
        result.setOwnerAndVisibility((IAuditableHandle)repository.loggedInContributor(), (IReadScope)readScope, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object)result)});
        }
        return result;
    }

    public static void deleteWorkspace(ITeamRepository repository, IWorkspaceHandle itemHandle) throws TeamRepositoryException {
        SCMWorkspace.deleteWorkspace(repository, itemHandle, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static void deleteWorkspace(ITeamRepository repository, IWorkspaceHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SCMWorkspace.deleteWorkspace(repository, itemHandle, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static void deleteWorkspace(ITeamRepository repository, IWorkspaceHandle itemHandle, IDebugger dbg) throws TeamRepositoryException {
        SCMWorkspace.deleteWorkspace(repository, itemHandle, null, dbg);
    }

    public static void deleteWorkspace(ITeamRepository repository, IWorkspaceHandle itemHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)itemHandle)});
        }
        SCMPlatform.getWorkspaceManager((ITeamRepository)repository).deleteWorkspace(itemHandle, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)itemHandle)});
        }
    }

    public static IWorkspaceHandle findWorkspaceHandleByName(ITeamRepository repository, String workspaceName) throws TeamRepositoryException {
        return SCMWorkspace.findWorkspaceHandleByName(repository, workspaceName, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle findWorkspaceHandleByName(ITeamRepository repository, String workspaceName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.findWorkspaceHandleByName(repository, workspaceName, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle findWorkspaceHandleByName(ITeamRepository repository, String workspaceName, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.findWorkspaceHandleByName(repository, workspaceName, null, dbg);
    }

    public static IWorkspaceHandle findWorkspaceHandleByName(ITeamRepository repository, String workspaceName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceHandle result = null;
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
        searchCriteria.setExactName(workspaceName);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 1) {
            result = (IWorkspaceHandle)findWorkspaces.get(0);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static IWorkspaceHandle findWorkspaceHandleByNameAndOwner(ITeamRepository repository, String workspaceName, String workspaceOwner) throws TeamRepositoryException {
        return SCMWorkspace.findWorkspaceHandleByNameAndOwner(repository, workspaceName, workspaceOwner, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle findWorkspaceHandleByNameAndOwner(ITeamRepository repository, String workspaceName, String workspaceOwner, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.findWorkspaceHandleByNameAndOwner(repository, workspaceName, workspaceOwner, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle findWorkspaceHandleByNameAndOwner(ITeamRepository repository, String workspaceName, String workspaceOwner, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.findWorkspaceHandleByNameAndOwner(repository, workspaceName, workspaceOwner, null, dbg);
    }

    public static IWorkspaceHandle findWorkspaceHandleByNameAndOwner(ITeamRepository repository, String workspaceName, String workspaceOwner, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceHandle result = null;
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
        searchCriteria.setExactName(workspaceName);
        searchCriteria.setExactOwnerName(workspaceOwner);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 1) {
            result = (IWorkspaceHandle)findWorkspaces.get(0);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static IWorkspaceHandle findWorkspaceHandleViaName(ITeamRepository repository, String workspaceName) {
        return SCMWorkspace.findWorkspaceHandleViaName(repository, workspaceName, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle findWorkspaceHandleViaName(ITeamRepository repository, String workspaceName, IProgressMonitor monitor) {
        return SCMWorkspace.findWorkspaceHandleViaName(repository, workspaceName, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle findWorkspaceHandleViaName(ITeamRepository repository, String workspaceName, IDebugger dbg) {
        return SCMWorkspace.findWorkspaceHandleViaName(repository, workspaceName, null, dbg);
    }

    public static IWorkspaceHandle findWorkspaceHandleViaName(ITeamRepository repository, String workspaceName, IProgressMonitor monitor, IDebugger dbg) {
        IWorkspaceHandle result;
        block5: {
            if (dbg.isDebug()) {
                Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
            }
            result = null;
            try {
                IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
                searchCriteria.setExactName(workspaceName);
                IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
                if (findWorkspaces.size() == 1) {
                    result = (IWorkspaceHandle)findWorkspaces.get(0);
                }
            }
            catch (TeamRepositoryException e) {
                if (!dbg.isDebug()) break block5;
                e.printStackTrace();
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(result)});
        }
        return result;
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, String workspace) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspace(repository, workspace, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, String workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspace(repository, workspace, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, String workspace, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspace(repository, workspace, null, dbg);
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, String workspace, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspace result = null;
        if (Verification.isUUID((String)workspace)) {
            result = (IWorkspace)repository.itemManager().fetchCompleteItem(IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspace), null), 0, monitor);
        } else {
            IWorkspaceHandle handle = SCMWorkspace.findWorkspaceHandleByName(repository, workspace, monitor, dbg);
            if (handle != null) {
                result = (IWorkspace)repository.itemManager().fetchCompleteItem((IItemHandle)handle, 0, monitor);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)result)});
        }
        return result;
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, UUID workspaceUUID) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspace(repository, workspaceUUID, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, UUID workspaceUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspace(repository, workspaceUUID, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, UUID workspaceUUID, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspace(repository, workspaceUUID, null, dbg);
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, UUID workspaceUUID, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspace workspace = (IWorkspace)repository.itemManager().fetchCompleteItem(IWorkspace.ITEM_TYPE.createItemHandle(workspaceUUID, null), 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)workspace)});
        }
        return workspace;
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, IWorkspaceHandle workspaceHandle) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspace(repository, workspaceHandle, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspace(repository, workspaceHandle, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspace(repository, workspaceHandle, null, dbg);
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspace workspace = (IWorkspace)repository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)workspace)});
        }
        return workspace;
    }

    public static List<IWorkspace> getWorkspaces(ITeamRepository repository, List<?> workspaceList) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaces(repository, workspaceList, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static List<IWorkspace> getWorkspaces(ITeamRepository repository, List<?> workspaceList, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaces(repository, workspaceList, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static List<IWorkspace> getWorkspaces(ITeamRepository repository, List<?> workspaceList, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaces(repository, workspaceList, null, dbg);
    }

    public static List<IWorkspace> getWorkspaces(ITeamRepository repository, List<?> workspaceList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IWorkspace> result = new ArrayList<IWorkspace>();
        if (workspaceList != null && workspaceList.size() > 0) {
            if (workspaceList.get(0) instanceof UUID) {
                result = SCMWorkspace.getWorkspacesFromUUIDs(repository, workspaceList, monitor, dbg);
            } else if (workspaceList.get(0) instanceof String) {
                result = Verification.isUUID((String)((String)workspaceList.get(0))) ? SCMWorkspace.getWorkspacesFromUuids(repository, workspaceList, monitor, dbg) : SCMWorkspace.getWorkspacesFromNames(repository, workspaceList, monitor, dbg);
            } else if (workspaceList.get(0) instanceof IWorkspaceHandle) {
                result = SCMWorkspace.getWorkspacesFromHandles(repository, workspaceList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(result.size())});
        }
        return result;
    }

    private static List<IWorkspace> getWorkspacesFromHandles(ITeamRepository repository, List<IWorkspaceHandle> workspaceList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List result = null;
        result = repository.itemManager().fetchCompleteItems(workspaceList, 0, monitor);
        return result;
    }

    private static List<IWorkspace> getWorkspacesFromNames(ITeamRepository repository, List<String> workspaceList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List result = null;
        ArrayList<IWorkspaceHandle> handles = new ArrayList<IWorkspaceHandle>();
        for (String name : workspaceList) {
            handles.add(SCMWorkspace.findWorkspaceHandleByName(repository, name, monitor, dbg));
        }
        result = repository.itemManager().fetchCompleteItems(handles, 0, monitor);
        return result;
    }

    private static List<IWorkspace> getWorkspacesFromUuids(ITeamRepository repository, List<String> workspaceList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List result = null;
        ArrayList<IWorkspaceHandle> handles = new ArrayList<IWorkspaceHandle>();
        for (String uuid : workspaceList) {
            handles.add((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
        }
        result = repository.itemManager().fetchCompleteItems(handles, 0, monitor);
        return result;
    }

    private static List<IWorkspace> getWorkspacesFromUUIDs(ITeamRepository repository, List<UUID> workspaceList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List result = null;
        ArrayList<IWorkspaceHandle> handles = new ArrayList<IWorkspaceHandle>();
        for (UUID uuid : workspaceList) {
            handles.add((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(uuid, null));
        }
        result = repository.itemManager().fetchCompleteItems(handles, 0, monitor);
        return result;
    }

    public static IWorkspaceHandle getWorkspaceHandle(String workspaceUuid) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandle(workspaceUuid, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle getWorkspaceHandle(String workspaceUuid, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUuid), null);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workspaceHandle)});
        }
        return workspaceHandle;
    }

    public static IWorkspaceHandle getWorkspaceHandle(UUID workspaceUUID) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandle(workspaceUUID, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle getWorkspaceHandle(UUID workspaceUUID, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUUID, null);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workspaceHandle)});
        }
        return workspaceHandle;
    }

    public static IWorkspaceHandle getWorkspaceHandle(ITeamRepository repository, String workspace) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandle(repository, workspace, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle getWorkspaceHandle(ITeamRepository repository, String workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandle(repository, workspace, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle getWorkspaceHandle(ITeamRepository repository, String workspace, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandle(repository, workspace, null, dbg);
    }

    public static IWorkspaceHandle getWorkspaceHandle(ITeamRepository repository, String workspace, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceHandle result = null;
        result = Verification.isUUID((String)workspace) ? (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspace), null) : SCMWorkspace.findWorkspaceHandleByName(repository, workspace, monitor, dbg);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static List<IWorkspaceHandle> getWorkspaceHandles(ITeamRepository repository, List<?> workspaceList) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandles(repository, workspaceList, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static List<IWorkspaceHandle> getWorkspaceHandles(ITeamRepository repository, List<?> workspaceList, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandles(repository, workspaceList, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static List<IWorkspaceHandle> getWorkspaceHandles(ITeamRepository repository, List<?> workspaceList, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandles(repository, workspaceList, null, dbg);
    }

    public static List<IWorkspaceHandle> getWorkspaceHandles(ITeamRepository repository, List<?> workspaceList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IWorkspaceHandle> result = new ArrayList<IWorkspaceHandle>();
        if (workspaceList != null && workspaceList.size() > 0) {
            if (workspaceList.get(0) instanceof UUID) {
                result = SCMWorkspace.getWorkspaceHandlesFromUUIDs(workspaceList, dbg);
            } else if (workspaceList.get(0) instanceof String) {
                result = Verification.isUUID((String)((String)workspaceList.get(0))) ? SCMWorkspace.getWorkspaceHandlesFromUuids(workspaceList, dbg) : SCMWorkspace.getWorkspaceHandlesFromNames(repository, workspaceList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(result)});
        }
        return result;
    }

    private static List<IWorkspaceHandle> getWorkspaceHandlesFromNames(ITeamRepository repository, List<String> workspaceList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkspaceHandle> result = new ArrayList<IWorkspaceHandle>();
        for (String name : workspaceList) {
            result.add(SCMWorkspace.findWorkspaceHandleByName(repository, name, monitor, dbg));
        }
        return result;
    }

    private static List<IWorkspaceHandle> getWorkspaceHandlesFromUuids(List<String> workspaceList, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkspaceHandle> result = new ArrayList<IWorkspaceHandle>();
        for (String workspaceUUID : workspaceList) {
            result.add((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUID), null));
        }
        return result;
    }

    private static List<IWorkspaceHandle> getWorkspaceHandlesFromUUIDs(List<UUID> workspaceList, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkspaceHandle> result = new ArrayList<IWorkspaceHandle>();
        for (UUID workspaceUUID : workspaceList) {
            result.add((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUUID, null));
        }
        return result;
    }

    public static IWorkspaceHandle getWorkspaceHandleByName(ITeamRepository repository, String workspaceName) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandleByName(repository, workspaceName, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle getWorkspaceHandleByName(ITeamRepository repository, String workspaceName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandleByName(repository, workspaceName, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle getWorkspaceHandleByName(ITeamRepository repository, String workspaceName, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandleByName(repository, workspaceName, null, dbg);
    }

    public static IWorkspaceHandle getWorkspaceHandleByName(ITeamRepository repository, String workspaceName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
        searchCriteria.setExactName(workspaceName);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 0) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_WORKSPACE_NOT_FOUND, (Object)workspaceName, (Object[])new Object[0]));
        }
        if (findWorkspaces.size() > 1) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_WORKSPACE_NOT_UNIQUE, (Object)workspaceName, (Object[])new Object[0]));
        }
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)findWorkspaces.get(0);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workspaceHandle)});
        }
        return workspaceHandle;
    }

    public static IWorkspaceHandle getWorkspaceHandleByNameOwnedByLogin(ITeamRepository repository, String workspaceName) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandleByNameOwnedByLogin(repository, workspaceName, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle getWorkspaceHandleByNameOwnedByLogin(ITeamRepository repository, String workspaceName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandleByNameOwnedByLogin(repository, workspaceName, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceHandle getWorkspaceHandleByNameOwnedByLogin(ITeamRepository repository, String workspaceName, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandleByNameOwnedByLogin(repository, workspaceName, null, dbg);
    }

    public static IWorkspaceHandle getWorkspaceHandleByNameOwnedByLogin(ITeamRepository repository, String workspaceName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        searchCriteria.getFilterByOwnerOptional().add(repository.loggedInContributor());
        searchCriteria.setExactName(workspaceName);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 0) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_WORKSPACE_NOT_FOUND, (Object)workspaceName, (Object[])new Object[0]));
        }
        if (findWorkspaces.size() > 1) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_WORKSPACE_NOT_UNIQUE, (Object)workspaceName, (Object[])new Object[0]));
        }
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)findWorkspaces.get(0);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workspaceHandle)});
        }
        return workspaceHandle;
    }

    public static List<IWorkspaceHandle> getWorkspaceHandlesByNames(ITeamRepository repository, List<String> workspaceNames) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandlesByNames(repository, workspaceNames, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static List<IWorkspaceHandle> getWorkspaceHandlesByNames(ITeamRepository repository, List<String> workspaceNames, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandlesByNames(repository, workspaceNames, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static List<IWorkspaceHandle> getWorkspaceHandlesByNames(ITeamRepository repository, List<String> workspaceNames, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceHandlesByNames(repository, workspaceNames, null, dbg);
    }

    public static List<IWorkspaceHandle> getWorkspaceHandlesByNames(ITeamRepository repository, List<String> workspaceNames, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IWorkspaceHandle> workspaceHandleList = new ArrayList<IWorkspaceHandle>();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        for (String workspaceName : workspaceNames) {
            IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
            searchCriteria.setExactName(workspaceName);
            List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
            if (findWorkspaces.size() == 0) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_WORKSPACE_NOT_FOUND, (Object)workspaceName, (Object[])new Object[0]));
            }
            if (findWorkspaces.size() > 1) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_WORKSPACE_NOT_UNIQUE, (Object)workspaceName, (Object[])new Object[0]));
            }
            workspaceHandleList.add((IWorkspaceHandle)findWorkspaces.get(0));
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workspaceHandleList.size())});
        }
        return workspaceHandleList;
    }

    public static IWorkspaceConnection getWorkspaceConnection(ITeamRepository repository, IWorkspaceHandle workspaceHandle) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceConnection(repository, workspaceHandle, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceConnection getWorkspaceConnection(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceConnection(repository, workspaceHandle, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceConnection getWorkspaceConnection(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceConnection(repository, workspaceHandle, null, dbg);
    }

    public static IWorkspaceConnection getWorkspaceConnection(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspaceHandle, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object)workspaceConnection)});
        }
        return workspaceConnection;
    }

    public static IWorkspaceConnection getWorkspaceConnectionByName(ITeamRepository repository, String workspaceName) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceConnectionByName(repository, workspaceName, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceConnection getWorkspaceConnectionByName(ITeamRepository repository, String workspaceName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceConnectionByName(repository, workspaceName, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceConnection getWorkspaceConnectionByName(ITeamRepository repository, String workspaceName, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceConnectionByName(repository, workspaceName, null, dbg);
    }

    public static IWorkspaceConnection getWorkspaceConnectionByName(ITeamRepository repository, String workspaceName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
        searchCriteria.getFilterByOwnerOptional().add(repository.loggedInContributor());
        searchCriteria.setExactName(workspaceName);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 0) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_WORKSPACE_NOT_FOUND, (Object)workspaceName, (Object[])new Object[0]));
        }
        if (findWorkspaces.size() > 1) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_WORKSPACE_NOT_UNIQUE, (Object)workspaceName, (Object[])new Object[0]));
        }
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)findWorkspaces.get(0), monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object)workspaceConnection)});
        }
        return workspaceConnection;
    }

    public static IWorkspaceConnection getWorkspaceConnectionByUUID(ITeamRepository repository, String workspaceUUID) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceConnectionByUUID(repository, workspaceUUID, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceConnection getWorkspaceConnectionByUUID(ITeamRepository repository, String workspaceUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceConnectionByUUID(repository, workspaceUUID, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static IWorkspaceConnection getWorkspaceConnectionByUUID(ITeamRepository repository, String workspaceUUID, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceConnectionByUUID(repository, workspaceUUID, null, dbg);
    }

    public static IWorkspaceConnection getWorkspaceConnectionByUUID(ITeamRepository repository, String workspaceUUID, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUID), null), monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object)workspaceConnection)});
        }
        return workspaceConnection;
    }

    public static String getWorkspaceName(ITeamRepository repository, IWorkspaceHandle workspaceHandle) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceName(repository, workspaceHandle, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static String getWorkspaceName(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceName(repository, workspaceHandle, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static String getWorkspaceName(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceName(repository, workspaceHandle, null, dbg);
    }

    public static String getWorkspaceName(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        String result = null;
        IWorkspace workspace = (IWorkspace)repository.itemManager().fetchPartialItem((IItemHandle)workspaceHandle, 0, Arrays.asList(IWorkspace.NAME_PROPERTY), monitor);
        if (workspace != null) {
            result = workspace.getName();
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((String)result)});
        }
        return result;
    }

    public static List<String> getWorkspaceNames(ITeamRepository repository, List<IWorkspaceHandle> workspaceHandles) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceNames(repository, workspaceHandles, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static List<String> getWorkspaceNames(ITeamRepository repository, List<IWorkspaceHandle> workspaceHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceNames(repository, workspaceHandles, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static List<String> getWorkspaceNames(ITeamRepository repository, List<IWorkspaceHandle> workspaceHandles, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceNames(repository, workspaceHandles, null, dbg);
    }

    public static List<String> getWorkspaceNames(ITeamRepository repository, List<IWorkspaceHandle> workspaceHandles, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        List workspaces = repository.itemManager().fetchPartialItems(workspaceHandles, 0, Arrays.asList(IWorkspace.NAME_PROPERTY), monitor);
        for (IWorkspace workspace : workspaces) {
            if (workspace != null) {
                result.add(workspace.getName());
                continue;
            }
            result.add(null);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(result.size())});
        }
        return result;
    }

    public static UUID getWorkspaceUUID(ITeamRepository repository, String workspaceName) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceUUID(repository, workspaceName, null, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static UUID getWorkspaceUUID(ITeamRepository repository, String workspaceName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceUUID(repository, workspaceName, monitor, (IDebugger)new Debugger(SCMWorkspace.class));
    }

    public static UUID getWorkspaceUUID(ITeamRepository repository, String workspaceName, IDebugger dbg) throws TeamRepositoryException {
        return SCMWorkspace.getWorkspaceUUID(repository, workspaceName, null, dbg);
    }

    public static UUID getWorkspaceUUID(ITeamRepository repository, String workspaceName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
        searchCriteria.setExactName(workspaceName);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 0) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_WORKSPACE_NOT_FOUND, (Object)workspaceName, (Object[])new Object[0]));
        }
        if (findWorkspaces.size() > 1) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_WORKSPACE_NOT_UNIQUE, (Object)workspaceName, (Object[])new Object[0]));
        }
        UUID workspaceUUID = ((IWorkspaceHandle)findWorkspaces.get(0)).getItemId();
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((UUID)workspaceUUID)});
        }
        return workspaceUUID;
    }
}

