/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class SCMVersionable {
    private static final String className = SCMVersionable.class.getSimpleName();

    public static IVersionable findFile(IConfiguration configuration, String[] filePath) throws TeamRepositoryException {
        return SCMVersionable.findFile(configuration, filePath, null, (IDebugger)new Debugger(SCMVersionable.class));
    }

    public static IVersionable findFile(IConfiguration configuration, String[] filePath, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMVersionable.findFile(configuration, filePath, monitor, (IDebugger)new Debugger(SCMVersionable.class));
    }

    public static IVersionable findFile(IConfiguration configuration, String[] filePath, IDebugger dbg) throws TeamRepositoryException {
        return SCMVersionable.findFile(configuration, filePath, null, dbg);
    }

    public static IVersionable findFile(IConfiguration configuration, String[] filePath, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IVersionable result = null;
        IVersionable parent = null;
        String[] stringArray = filePath;
        int n = filePath.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            result = SCMVersionable.getChild(configuration, parent, segment, monitor, dbg);
            if (result == null) break;
            parent = result;
            ++n2;
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)result)});
        }
        return result;
    }

    public static IVersionable getChild(IConfiguration configuration, IVersionable parent, String childName) throws TeamRepositoryException {
        return SCMVersionable.getChild(configuration, parent, childName, null, (IDebugger)new Debugger(SCMVersionable.class));
    }

    public static IVersionable getChild(IConfiguration configuration, IVersionable parent, String childName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMVersionable.getChild(configuration, parent, childName, monitor, (IDebugger)new Debugger(SCMVersionable.class));
    }

    public static IVersionable getChild(IConfiguration configuration, IVersionable parent, String childName, IDebugger dbg) throws TeamRepositoryException {
        return SCMVersionable.getChild(configuration, parent, childName, null, dbg);
    }

    public static IVersionable getChild(IConfiguration configuration, IVersionable parent, String childName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        Map children;
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IVersionable result = null;
        if (parent instanceof IFolder) {
            Map children2 = configuration.childEntries((IFolderHandle)parent, monitor);
            if (children2.containsKey(childName)) {
                result = configuration.fetchCompleteItem((IVersionableHandle)children2.get(childName), monitor);
            }
        } else if (parent == null && (children = configuration.childEntriesForRoot(monitor)).containsKey(childName)) {
            result = configuration.fetchCompleteItem((IVersionableHandle)children.get(childName), monitor);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)result)});
        }
        return result;
    }

    public static String getMessageBinding(IVersionable versionable) throws TeamRepositoryException {
        return SCMVersionable.getMessageBinding(versionable, (IDebugger)new Debugger(SCMVersionable.class));
    }

    public static String getMessageBinding(IVersionable versionable, IDebugger dbg) throws TeamRepositoryException {
        String result = "";
        try {
            result = versionable == null ? "null" : (versionable.getName() != null ? versionable.getName() : (versionable.getItemId() != null ? versionable.getItemId().getUuidValue() : "null"));
        }
        catch (Exception e) {
            dbg.log(e.toString());
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((String)result)});
        }
        return result;
    }

    public static void log(IVersionable versionable) throws TeamRepositoryException {
        SCMVersionable.log(versionable, (IDebugger)new Debugger(SCMVersionable.class));
    }

    public static void log(IVersionable versionable, IDebugger dbg) throws TeamRepositoryException {
        StringBuilder display = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        if (versionable == null) {
            display.append(newLine);
            display.append("IVersionable: null");
        } else {
            try {
                display.append(newLine);
                display.append("IVersionable: " + LogString.valueOf((String)versionable.getName()) + newLine);
                display.append("  getContextId:         " + LogString.valueOf((UUID)versionable.getContextId()) + newLine);
                display.append("  getFullState:         " + LogString.valueOf((IItem)versionable.getFullState()) + newLine);
                display.append("  getItemHandle:        " + LogString.valueOf((IItemHandle)versionable.getItemHandle()) + newLine);
                display.append("  getItemId:            " + LogString.valueOf((UUID)versionable.getItemId()) + newLine);
                display.append("  getItemType:          " + LogString.valueOf((Object)versionable.getItemType()) + newLine);
                display.append("  getModifiedBy:        " + LogString.valueOf((IItemHandle)versionable.getModifiedBy()) + newLine);
                display.append("  getName:              " + LogString.valueOf((String)versionable.getName()) + newLine);
                display.append("  getOrigin:            " + LogString.valueOf((Object)versionable.getOrigin()) + newLine);
                display.append("  getParent:            " + LogString.valueOf((IItemHandle)versionable.getParent()) + newLine);
                display.append("  getRequestedModified: " + LogString.valueOf((Date)versionable.getRequestedModified()) + newLine);
                display.append("  getRequestedStateId:  " + LogString.valueOf((UUID)versionable.getRequestedStateId()) + newLine);
                display.append("  getStateHandle:       " + LogString.valueOf((IItemHandle)versionable.getStateHandle()) + newLine);
                display.append("  getStateId:           " + LogString.valueOf((UUID)versionable.getStateId()) + newLine);
                display.append("  getUserProperties:    " + LogString.valueOf((Map)versionable.getUserProperties()) + newLine);
                display.append("  hasFullState:         " + LogString.valueOf((boolean)versionable.hasFullState()) + newLine);
                display.append("  hasHistory:           " + LogString.valueOf((boolean)versionable.hasHistory()) + newLine);
                display.append("  hasStateId:           " + LogString.valueOf((boolean)versionable.hasStateId()) + newLine);
                display.append("  hashCode:             " + LogString.valueOf((int)versionable.hashCode()) + newLine);
                display.append("  isAuditable:          " + LogString.valueOf((boolean)versionable.isAuditable()) + newLine);
                display.append("  isComplete:           " + LogString.valueOf((boolean)versionable.isComplete()) + newLine);
                display.append("  isConfigurationAware: " + LogString.valueOf((boolean)versionable.isConfigurationAware()) + newLine);
                display.append("  isImmutable:          " + LogString.valueOf((boolean)versionable.isImmutable()) + newLine);
                display.append("  isRedactedCopy:       " + LogString.valueOf((boolean)versionable.isRedactedCopy()) + newLine);
                display.append("  isSimple:             " + LogString.valueOf((boolean)versionable.isSimple()) + newLine);
                display.append("  isUnmanaged:          " + LogString.valueOf((boolean)versionable.isUnmanaged()) + newLine);
                display.append("  isWorkingCopy:        " + LogString.valueOf((boolean)versionable.isWorkingCopy()) + newLine);
                display.append("  modified:             " + LogString.valueOf((Date)versionable.modified()) + newLine);
                display.append("  size:                 " + LogString.valueOf((long)versionable.size()) + newLine);
            }
            catch (Exception e) {
                dbg.log(e.toString());
            }
        }
        dbg.log(display.toString());
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)versionable)});
        }
    }
}

