/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.client.nls.Messages;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class SCMStream {
    private static final String className = SCMStream.class.getSimpleName();

    public static IWorkspaceConnection createStream(ITeamRepository repository, IProcessAreaHandle processArea, String streamName, String streamDescription) throws TeamRepositoryException {
        return SCMStream.createStream(repository, processArea, streamName, streamDescription, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceConnection createStream(ITeamRepository repository, IProcessAreaHandle processArea, String streamName, String streamDescription, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.createStream(repository, processArea, streamName, streamDescription, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceConnection createStream(ITeamRepository repository, IProcessAreaHandle processArea, String streamName, String streamDescription, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.createStream(repository, processArea, streamName, streamDescription, null, dbg);
    }

    public static IWorkspaceConnection createStream(ITeamRepository repository, IProcessAreaHandle processArea, String streamName, String streamDescription, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection result = workspaceManager.createStream(processArea, streamName, streamDescription, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object)result)});
        }
        return result;
    }

    public static void deleteStream(ITeamRepository repository, IWorkspaceHandle itemHandle) throws TeamRepositoryException {
        SCMStream.deleteStream(repository, itemHandle, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static void deleteStream(ITeamRepository repository, IWorkspaceHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SCMStream.deleteStream(repository, itemHandle, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static void deleteStream(ITeamRepository repository, IWorkspaceHandle itemHandle, IDebugger dbg) throws TeamRepositoryException {
        SCMStream.deleteStream(repository, itemHandle, null, dbg);
    }

    public static void deleteStream(ITeamRepository repository, IWorkspaceHandle itemHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)itemHandle)});
        }
        SCMPlatform.getWorkspaceManager((ITeamRepository)repository).deleteWorkspace(itemHandle, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)itemHandle)});
        }
    }

    public static IWorkspaceHandle findStreamHandleByName(ITeamRepository repository, String streamName) throws TeamRepositoryException {
        return SCMStream.findStreamHandleByName(repository, streamName, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceHandle findStreamHandleByName(ITeamRepository repository, String streamName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.findStreamHandleByName(repository, streamName, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceHandle findStreamHandleByName(ITeamRepository repository, String streamName, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.findStreamHandleByName(repository, streamName, null, dbg);
    }

    public static IWorkspaceHandle findStreamHandleByName(ITeamRepository repository, String streamName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceHandle result = null;
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        searchCriteria.setExactName(streamName);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 1) {
            result = (IWorkspaceHandle)findWorkspaces.get(0);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static IWorkspaceHandle findStreamHandleByNameAndOwner(ITeamRepository repository, String streamName, String streamOwner) throws TeamRepositoryException {
        return SCMStream.findStreamHandleByNameAndOwner(repository, streamName, streamOwner, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceHandle findStreamHandleByNameAndOwner(ITeamRepository repository, String streamName, String streamOwner, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.findStreamHandleByNameAndOwner(repository, streamName, streamOwner, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceHandle findStreamHandleByNameAndOwner(ITeamRepository repository, String streamName, String streamOwner, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.findStreamHandleByNameAndOwner(repository, streamName, streamOwner, null, dbg);
    }

    public static IWorkspaceHandle findStreamHandleByNameAndOwner(ITeamRepository repository, String streamName, String streamOwner, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceHandle result = null;
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        searchCriteria.setExactName(streamName);
        searchCriteria.setExactOwnerName(streamOwner);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 1) {
            result = (IWorkspaceHandle)findWorkspaces.get(0);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static IWorkspace getStream(ITeamRepository repository, String streamUuid) throws TeamRepositoryException {
        return SCMStream.getStream(repository, streamUuid, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspace getStream(ITeamRepository repository, String streamUuid, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStream(repository, streamUuid, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspace getStream(ITeamRepository repository, String streamUuid, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStream(repository, streamUuid, null, dbg);
    }

    public static IWorkspace getStream(ITeamRepository repository, String streamUuid, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspace workspace = (IWorkspace)repository.itemManager().fetchCompleteItem(IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)streamUuid), null), 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)workspace)});
        }
        return workspace;
    }

    public static IWorkspace getStream(ITeamRepository repository, UUID streamUUID) throws TeamRepositoryException {
        return SCMStream.getStream(repository, streamUUID, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspace getStream(ITeamRepository repository, UUID streamUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStream(repository, streamUUID, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspace getStream(ITeamRepository repository, UUID streamUUID, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStream(repository, streamUUID, null, dbg);
    }

    public static IWorkspace getStream(ITeamRepository repository, UUID streamUUID, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspace workspace = (IWorkspace)repository.itemManager().fetchCompleteItem(IWorkspace.ITEM_TYPE.createItemHandle(streamUUID, null), 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)workspace)});
        }
        return workspace;
    }

    public static IWorkspace getStream(ITeamRepository repository, IWorkspaceHandle workspaceHandle) throws TeamRepositoryException {
        return SCMStream.getStream(repository, workspaceHandle, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspace getStream(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStream(repository, workspaceHandle, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspace getStream(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStream(repository, workspaceHandle, null, dbg);
    }

    public static IWorkspace getStream(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspace workspace = (IWorkspace)repository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)workspace)});
        }
        return workspace;
    }

    public static List<IWorkspace> getStreams(ITeamRepository repository, IProcessAreaHandle processArea) throws TeamRepositoryException {
        return SCMStream.getStreams(repository, processArea, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static List<IWorkspace> getStreams(ITeamRepository repository, IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreams(repository, processArea, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static List<IWorkspace> getStreams(ITeamRepository repository, IProcessAreaHandle processArea, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreams(repository, processArea, null, dbg);
    }

    public static List<IWorkspace> getStreams(ITeamRepository repository, IProcessAreaHandle processArea, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance();
        searchCriteria.setKind(1);
        searchCriteria.getFilterByOwnerOptional().add(processArea);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List handles = workspaceManager.findWorkspaces(searchCriteria, Integer.MAX_VALUE, monitor);
        List result = repository.itemManager().fetchCompleteItems(handles, 0, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((List)result)});
        }
        return result;
    }

    public static List<IWorkspace> getStreams(ITeamRepository repository, List<?> streamList) throws TeamRepositoryException {
        return SCMStream.getStreams(repository, streamList, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static List<IWorkspace> getStreams(ITeamRepository repository, List<?> streamList, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreams(repository, streamList, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static List<IWorkspace> getStreams(ITeamRepository repository, List<?> streamList, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreams(repository, streamList, null, dbg);
    }

    public static List<IWorkspace> getStreams(ITeamRepository repository, List<?> streamList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IWorkspace> streams = new ArrayList<IWorkspace>();
        if (streamList != null && streamList.size() > 0) {
            if (streamList.get(0) instanceof String) {
                streams = SCMStream.getStreamsFromUuids(repository, streamList, monitor, dbg);
            } else if (streamList.get(0) instanceof UUID) {
                streams = SCMStream.getStreamsFromUUIDs(repository, streamList, monitor, dbg);
            } else if (streamList.get(0) instanceof IWorkspaceHandle) {
                streams = SCMStream.getStreamsFromHandles(repository, streamList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(streams.size())});
        }
        return streams;
    }

    private static List<IWorkspace> getStreamsFromUuids(ITeamRepository repository, List<String> streamList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkspaceHandle> workspaceHandleList = new ArrayList<IWorkspaceHandle>();
        for (String streamUuid : streamList) {
            workspaceHandleList.add((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)streamUuid), null));
        }
        List workspaces = repository.itemManager().fetchCompleteItems(workspaceHandleList, 0, monitor);
        return workspaces;
    }

    private static List<IWorkspace> getStreamsFromUUIDs(ITeamRepository repository, List<UUID> streamList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkspaceHandle> workspaceHandleList = new ArrayList<IWorkspaceHandle>();
        for (UUID streamUUID : streamList) {
            workspaceHandleList.add((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(streamUUID, null));
        }
        List workspaces = repository.itemManager().fetchCompleteItems(workspaceHandleList, 0, monitor);
        return workspaces;
    }

    private static List<IWorkspace> getStreamsFromHandles(ITeamRepository repository, List<IWorkspaceHandle> streamList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List workspaces = repository.itemManager().fetchCompleteItems(streamList, 0, monitor);
        return workspaces;
    }

    public static IWorkspaceHandle getStreamHandle(String streamUuid) throws TeamRepositoryException {
        return SCMStream.getStreamHandle(streamUuid, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceHandle getStreamHandle(String streamUuid, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)streamUuid), null);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workspaceHandle)});
        }
        return workspaceHandle;
    }

    public static IWorkspaceHandle getStreamHandle(UUID streamUUID) throws TeamRepositoryException {
        return SCMStream.getStreamHandle(streamUUID, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceHandle getStreamHandle(UUID streamUUID, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(streamUUID, null);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workspaceHandle)});
        }
        return workspaceHandle;
    }

    public static List<IWorkspaceHandle> getStreamHandles(List<?> streamList) throws TeamRepositoryException {
        return SCMStream.getStreamHandles(streamList, (IDebugger)new Debugger(SCMStream.class));
    }

    public static List<IWorkspaceHandle> getStreamHandles(List<?> streamList, IDebugger dbg) throws TeamRepositoryException {
        List<IWorkspaceHandle> workspaceHandleList = new ArrayList<IWorkspaceHandle>();
        if (streamList != null && streamList.size() > 0) {
            if (streamList.get(0) instanceof String) {
                workspaceHandleList = SCMStream.getStreamHandlesFromUuids(streamList, dbg);
            } else if (streamList.get(0) instanceof UUID) {
                workspaceHandleList = SCMStream.getStreamHandlesFromUUIDs(streamList, dbg);
            } else if (streamList.get(0) instanceof IWorkspace) {
                workspaceHandleList = SCMStream.getStreamHandlesFromItems(streamList, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workspaceHandleList.size())});
        }
        return workspaceHandleList;
    }

    private static List<IWorkspaceHandle> getStreamHandlesFromUuids(List<String> streamList, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkspaceHandle> workspaceHandleList = new ArrayList<IWorkspaceHandle>();
        for (String streamUUID : streamList) {
            workspaceHandleList.add((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)streamUUID), null));
        }
        return workspaceHandleList;
    }

    private static List<IWorkspaceHandle> getStreamHandlesFromUUIDs(List<UUID> streamList, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkspaceHandle> workspaceHandleList = new ArrayList<IWorkspaceHandle>();
        for (UUID streamUUID : streamList) {
            workspaceHandleList.add((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(streamUUID, null));
        }
        return workspaceHandleList;
    }

    private static List<IWorkspaceHandle> getStreamHandlesFromItems(List<IWorkspace> streamList, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkspaceHandle> workspaceHandleList = new ArrayList<IWorkspaceHandle>();
        for (IWorkspace stream : streamList) {
            if (stream != null) {
                workspaceHandleList.add((IWorkspaceHandle)stream.getItemHandle());
                continue;
            }
            workspaceHandleList.add(null);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workspaceHandleList.size())});
        }
        return workspaceHandleList;
    }

    public static IWorkspaceHandle getStreamHandleByName(ITeamRepository repository, String streamName) throws TeamRepositoryException {
        return SCMStream.getStreamHandleByName(repository, streamName, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceHandle getStreamHandleByName(ITeamRepository repository, String streamName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreamHandleByName(repository, streamName, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceHandle getStreamHandleByName(ITeamRepository repository, String streamName, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreamHandleByName(repository, streamName, null, dbg);
    }

    public static IWorkspaceHandle getStreamHandleByName(ITeamRepository repository, String streamName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        searchCriteria.setExactName(streamName);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 0) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_STREAM_NOT_FOUND, (Object)streamName, (Object[])new Object[0]));
        }
        if (findWorkspaces.size() > 1) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_STREAM_NOT_UNIQUE, (Object)streamName, (Object[])new Object[0]));
        }
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)findWorkspaces.get(0);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workspaceHandle)});
        }
        return workspaceHandle;
    }

    public static IWorkspaceHandle getStreamHandleByNameOwnedByLogin(ITeamRepository repository, String streamName) throws TeamRepositoryException {
        return SCMStream.getStreamHandleByNameOwnedByLogin(repository, streamName, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceHandle getStreamHandleByNameOwnedByLogin(ITeamRepository repository, String streamName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreamHandleByNameOwnedByLogin(repository, streamName, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceHandle getStreamHandleByNameOwnedByLogin(ITeamRepository repository, String streamName, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreamHandleByNameOwnedByLogin(repository, streamName, null, dbg);
    }

    public static IWorkspaceHandle getStreamHandleByNameOwnedByLogin(ITeamRepository repository, String streamName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        searchCriteria.getFilterByOwnerOptional().add(repository.loggedInContributor());
        searchCriteria.setExactName(streamName);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 0) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_STREAM_NOT_FOUND, (Object)streamName, (Object[])new Object[0]));
        }
        if (findWorkspaces.size() > 1) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_STREAM_NOT_UNIQUE, (Object)streamName, (Object[])new Object[0]));
        }
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)findWorkspaces.get(0);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workspaceHandle)});
        }
        return workspaceHandle;
    }

    public static List<IWorkspaceHandle> getStreamHandlesByNames(ITeamRepository repository, List<String> streamNames) throws TeamRepositoryException {
        return SCMStream.getStreamHandlesByNames(repository, streamNames, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static List<IWorkspaceHandle> getStreamHandlesByNames(ITeamRepository repository, List<String> streamNames, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreamHandlesByNames(repository, streamNames, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static List<IWorkspaceHandle> getStreamHandlesByNames(ITeamRepository repository, List<String> streamNames, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreamHandlesByNames(repository, streamNames, null, dbg);
    }

    public static List<IWorkspaceHandle> getStreamHandlesByNames(ITeamRepository repository, List<String> streamNames, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IWorkspaceHandle> workspaceHandleList = new ArrayList<IWorkspaceHandle>();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        for (String streamName : streamNames) {
            IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
            searchCriteria.setExactName(streamName);
            List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
            if (findWorkspaces.size() == 0) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_STREAM_NOT_FOUND, (Object)streamName, (Object[])new Object[0]));
            }
            if (findWorkspaces.size() > 1) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_STREAM_NOT_UNIQUE, (Object)streamName, (Object[])new Object[0]));
            }
            workspaceHandleList.add((IWorkspaceHandle)findWorkspaces.get(0));
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workspaceHandleList.size())});
        }
        return workspaceHandleList;
    }

    public static IWorkspaceConnection getStreamConnection(ITeamRepository repository, IWorkspaceHandle workspaceHandle) throws TeamRepositoryException {
        return SCMStream.getStreamConnection(repository, workspaceHandle, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceConnection getStreamConnection(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreamConnection(repository, workspaceHandle, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceConnection getStreamConnection(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreamConnection(repository, workspaceHandle, null, dbg);
    }

    public static IWorkspaceConnection getStreamConnection(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspaceHandle, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object)workspaceConnection)});
        }
        return workspaceConnection;
    }

    public static IWorkspaceConnection getStreamConnectionByName(ITeamRepository repository, String streamName) throws TeamRepositoryException {
        return SCMStream.getStreamConnectionByName(repository, streamName, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceConnection getStreamConnectionByName(ITeamRepository repository, String streamName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreamConnectionByName(repository, streamName, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceConnection getStreamConnectionByName(ITeamRepository repository, String streamName, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreamConnectionByName(repository, streamName, null, dbg);
    }

    public static IWorkspaceConnection getStreamConnectionByName(ITeamRepository repository, String streamName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        searchCriteria.getFilterByOwnerOptional().add(repository.loggedInContributor());
        searchCriteria.setExactName(streamName);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 0) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_STREAM_NOT_FOUND, (Object)streamName, (Object[])new Object[0]));
        }
        if (findWorkspaces.size() > 1) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_STREAM_NOT_UNIQUE, (Object)streamName, (Object[])new Object[0]));
        }
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)findWorkspaces.get(0), monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object)workspaceConnection)});
        }
        return workspaceConnection;
    }

    public static IWorkspaceConnection getStreamConnectionByUUID(ITeamRepository repository, String streamUUID) throws TeamRepositoryException {
        return SCMStream.getStreamConnectionByUUID(repository, streamUUID, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceConnection getStreamConnectionByUUID(ITeamRepository repository, String streamUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreamConnectionByUUID(repository, streamUUID, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static IWorkspaceConnection getStreamConnectionByUUID(ITeamRepository repository, String streamUUID, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreamConnectionByUUID(repository, streamUUID, null, dbg);
    }

    public static IWorkspaceConnection getStreamConnectionByUUID(ITeamRepository repository, String streamUUID, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)streamUUID), null), monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object)workspaceConnection)});
        }
        return workspaceConnection;
    }

    public static String getStreamName(ITeamRepository repository, IWorkspaceHandle workspaceHandle) throws TeamRepositoryException {
        return SCMStream.getStreamName(repository, workspaceHandle, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static String getStreamName(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreamName(repository, workspaceHandle, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static String getStreamName(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreamName(repository, workspaceHandle, null, dbg);
    }

    public static String getStreamName(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        String result = null;
        IWorkspace workspace = (IWorkspace)repository.itemManager().fetchPartialItem((IItemHandle)workspaceHandle, 0, Arrays.asList(IWorkspace.NAME_PROPERTY), monitor);
        if (workspace != null) {
            result = workspace.getName();
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((String)result)});
        }
        return result;
    }

    public static List<String> getStreamNames(ITeamRepository repository, List<IWorkspaceHandle> streamHandles) throws TeamRepositoryException {
        return SCMStream.getStreamNames(repository, streamHandles, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static List<String> getStreamNames(ITeamRepository repository, List<IWorkspaceHandle> streamHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreamNames(repository, streamHandles, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static List<String> getStreamNames(ITeamRepository repository, List<IWorkspaceHandle> streamHandles, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreamNames(repository, streamHandles, null, dbg);
    }

    public static List<String> getStreamNames(ITeamRepository repository, List<IWorkspaceHandle> streamHandles, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        List workspaces = repository.itemManager().fetchPartialItems(streamHandles, 0, Arrays.asList(IWorkspace.NAME_PROPERTY), monitor);
        for (IWorkspace workspace : workspaces) {
            if (workspace != null) {
                result.add(workspace.getName());
                continue;
            }
            result.add(null);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(result.size())});
        }
        return result;
    }

    public static UUID getStreamUUID(ITeamRepository repository, String streamName) throws TeamRepositoryException {
        return SCMStream.getStreamUUID(repository, streamName, null, (IDebugger)new Debugger(SCMStream.class));
    }

    public static UUID getStreamUUID(ITeamRepository repository, String streamName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMStream.getStreamUUID(repository, streamName, monitor, (IDebugger)new Debugger(SCMStream.class));
    }

    public static UUID getStreamUUID(ITeamRepository repository, String streamName, IDebugger dbg) throws TeamRepositoryException {
        return SCMStream.getStreamUUID(repository, streamName, null, dbg);
    }

    public static UUID getStreamUUID(ITeamRepository repository, String streamName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IWorkspaceSearchCriteria searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        searchCriteria.setExactName(streamName);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        List findWorkspaces = workspaceManager.findWorkspaces(searchCriteria, 2, monitor);
        if (findWorkspaces.size() == 0) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_STREAM_NOT_FOUND, (Object)streamName, (Object[])new Object[0]));
        }
        if (findWorkspaces.size() > 1) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_SCM_STREAM_NOT_UNIQUE, (Object)streamName, (Object[])new Object[0]));
        }
        UUID streamUUID = ((IWorkspaceHandle)findWorkspaces.get(0)).getItemId();
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((UUID)streamUUID)});
        }
        return streamUUID;
    }
}

