/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.client.util.EclipseWorkspace;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.FileUtilities;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class SCMFileUtils {
    private static final String className = SCMFileUtils.class.getSimpleName();
    private static final String UTP = "";

    public static List<IVersionable> getDirectoryContentList(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryContentList(fileContentManager, configuration, contentList, false, false, dbg);
    }

    public static List<IVersionable> getDirectoryContentList(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, Boolean fileOption, Boolean folderOption, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IVersionable> contentResult = new ArrayList<IVersionable>();
        for (IVersionable versionable : contentList) {
            if (versionable == null || FileUtilities.isHidden((String)versionable.getName())) continue;
            if (versionable instanceof IFolder) {
                if (!fileOption.booleanValue()) {
                    contentResult.add(versionable);
                }
                Map children = configuration.childEntries((IFolderHandle)versionable, null);
                ArrayList<Object> childrenList = new ArrayList<Object>(children.size());
                if (folderOption.booleanValue()) {
                    for (IVersionableHandle versionableHandle : children.values()) {
                        if (!(versionableHandle instanceof IFolderHandle)) continue;
                        childrenList.add(versionableHandle);
                    }
                } else {
                    childrenList.addAll(children.values());
                }
                if (childrenList.size() == 0) continue;
                List completeChildren = configuration.fetchCompleteItems(childrenList, null);
                contentResult.addAll(SCMFileUtils.getDirectoryContentList(fileContentManager, configuration, completeChildren, fileOption, folderOption, dbg));
                continue;
            }
            if (versionable instanceof IFileItem) {
                if (FileUtilities.isNoType((String)versionable.getName()) || folderOption.booleanValue()) continue;
                contentResult.add(versionable);
                continue;
            }
            dbg.log(Debug.error((String[])new String[]{className, new MethodName(){}.getName(), UTP, versionable.getName()}), 200);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentResult.size())});
        }
        return contentResult;
    }

    public static List<IVersionable> getDirectoryContentListAll(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryContentListAll(fileContentManager, configuration, contentList, false, false, dbg);
    }

    public static List<IVersionable> getDirectoryContentListAll(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, Boolean fileOption, Boolean folderOption, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IVersionable> contentResult = new ArrayList<IVersionable>();
        for (IVersionable versionable : contentList) {
            if (versionable == null) continue;
            if (versionable instanceof IFolder) {
                if (!fileOption.booleanValue()) {
                    contentResult.add(versionable);
                }
                Map children = configuration.childEntries((IFolderHandle)versionable, null);
                ArrayList<Object> childrenList = new ArrayList<Object>(children.size());
                if (folderOption.booleanValue()) {
                    for (IVersionableHandle versionableHandle : children.values()) {
                        if (!(versionableHandle instanceof IFolderHandle)) continue;
                        childrenList.add(versionableHandle);
                    }
                } else {
                    childrenList.addAll(children.values());
                }
                if (childrenList.size() == 0) continue;
                List completeChildren = configuration.fetchCompleteItems(childrenList, null);
                contentResult.addAll(SCMFileUtils.getDirectoryContentListAll(fileContentManager, configuration, completeChildren, fileOption, folderOption, dbg));
                continue;
            }
            if (versionable instanceof IFileItem) {
                if (folderOption.booleanValue()) continue;
                contentResult.add(versionable);
                continue;
            }
            dbg.log(Debug.error((String[])new String[]{className, new MethodName(){}.getName(), UTP, versionable.getName()}), 200);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentResult.size())});
        }
        return contentResult;
    }

    public static Map<IVersionable, String> getDirectoryContentMap(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryContentMap(fileContentManager, configuration, contentList, false, false, UTP, dbg);
    }

    public static Map<IVersionable, String> getDirectoryContentMap(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, Boolean fileOption, Boolean folderOption, String path, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        path = String.valueOf(path) + "/";
        HashMap<IVersionable, String> contentMapResult = new HashMap<IVersionable, String>();
        for (IVersionable versionable : contentList) {
            if (versionable == null || FileUtilities.isHidden((String)versionable.getName())) continue;
            if (versionable instanceof IFolder) {
                if (!fileOption.booleanValue()) {
                    contentMapResult.put(versionable, path);
                }
                Map children = configuration.childEntries((IFolderHandle)versionable, null);
                ArrayList<Object> childrenList = new ArrayList<Object>(children.size());
                if (folderOption.booleanValue()) {
                    for (IVersionableHandle versionableHandle : children.values()) {
                        if (!(versionableHandle instanceof IFolderHandle)) continue;
                        childrenList.add(versionableHandle);
                    }
                } else {
                    childrenList.addAll(children.values());
                }
                if (childrenList.size() == 0) continue;
                List completeChildren = configuration.fetchCompleteItems(childrenList, null);
                contentMapResult.putAll(SCMFileUtils.getDirectoryContentMap(fileContentManager, configuration, completeChildren, fileOption, folderOption, String.valueOf(path) + versionable.getName(), dbg));
                continue;
            }
            if (versionable instanceof IFileItem) {
                if (FileUtilities.isNoType((String)versionable.getName()) || folderOption.booleanValue()) continue;
                contentMapResult.put(versionable, path);
                continue;
            }
            dbg.log(Debug.error((String[])new String[]{className, new MethodName(){}.getName(), UTP, versionable.getName()}), 200);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMapResult.size())});
        }
        return contentMapResult;
    }

    public static Map<IVersionable, String> getDirectoryContentMapAll(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryContentMapAll(fileContentManager, configuration, contentList, false, false, UTP, dbg);
    }

    public static Map<IVersionable, String> getDirectoryContentMapAll(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, Boolean fileOption, Boolean folderOption, String path, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        path = String.valueOf(path) + "/";
        HashMap<IVersionable, String> contentMapResult = new HashMap<IVersionable, String>();
        for (IVersionable versionable : contentList) {
            if (versionable == null) continue;
            if (versionable instanceof IFolder) {
                if (!fileOption.booleanValue()) {
                    contentMapResult.put(versionable, path);
                }
                Map children = configuration.childEntries((IFolderHandle)versionable, null);
                ArrayList<Object> childrenList = new ArrayList<Object>(children.size());
                if (folderOption.booleanValue()) {
                    for (IVersionableHandle versionableHandle : children.values()) {
                        if (!(versionableHandle instanceof IFolderHandle)) continue;
                        childrenList.add(versionableHandle);
                    }
                } else {
                    childrenList.addAll(children.values());
                }
                if (childrenList.size() == 0) continue;
                List completeChildren = configuration.fetchCompleteItems(childrenList, null);
                contentMapResult.putAll(SCMFileUtils.getDirectoryContentMapAll(fileContentManager, configuration, completeChildren, fileOption, folderOption, String.valueOf(path) + versionable.getName(), dbg));
                continue;
            }
            if (versionable instanceof IFileItem) {
                if (folderOption.booleanValue()) continue;
                contentMapResult.put(versionable, path);
                continue;
            }
            dbg.log(Debug.error((String[])new String[]{className, new MethodName(){}.getName(), UTP, versionable.getName()}), 200);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMapResult.size())});
        }
        return contentMapResult;
    }

    public static Map<IVersionable, List<IVersionable>> getDirectoryContentProjectMap(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryContentProjectMap(fileContentManager, configuration, contentList, false, false, dbg);
    }

    public static Map<IVersionable, List<IVersionable>> getDirectoryContentProjectMap(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, Boolean fileOption, Boolean folderOption, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        HashMap<IVersionable, List<IVersionable>> contentResult = new HashMap<IVersionable, List<IVersionable>>();
        for (IVersionable versionable : contentList) {
            ArrayList<IVersionable> versionableList = new ArrayList<IVersionable>();
            contentResult.put(versionable, versionableList);
            if (versionable == null || FileUtilities.isHidden((String)versionable.getName())) continue;
            if (versionable instanceof IFolder) {
                if (!fileOption.booleanValue()) {
                    versionableList.add(versionable);
                }
                Map children = configuration.childEntries((IFolderHandle)versionable, null);
                ArrayList<Object> childrenList = new ArrayList<Object>(children.size());
                if (folderOption.booleanValue()) {
                    for (IVersionableHandle versionableHandle : children.values()) {
                        if (!(versionableHandle instanceof IFolderHandle)) continue;
                        childrenList.add(versionableHandle);
                    }
                } else {
                    childrenList.addAll(children.values());
                }
                if (childrenList.size() == 0) continue;
                List completeChildren = configuration.fetchCompleteItems(childrenList, null);
                versionableList.addAll(SCMFileUtils.getDirectoryContentList(fileContentManager, configuration, completeChildren, fileOption, folderOption, dbg));
                continue;
            }
            if (versionable instanceof IFileItem) {
                if (FileUtilities.isNoType((String)versionable.getName()) || folderOption.booleanValue()) continue;
                versionableList.add(versionable);
                continue;
            }
            dbg.log(Debug.error((String[])new String[]{className, new MethodName(){}.getName(), UTP, versionable.getName()}), 200);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentResult.size())});
        }
        return contentResult;
    }

    public static Map<IVersionable, List<IVersionable>> getDirectoryContentProjectMapAll(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryContentProjectMapAll(fileContentManager, configuration, contentList, false, false, dbg);
    }

    public static Map<IVersionable, List<IVersionable>> getDirectoryContentProjectMapAll(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, Boolean fileOption, Boolean folderOption, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        HashMap<IVersionable, List<IVersionable>> contentResult = new HashMap<IVersionable, List<IVersionable>>();
        for (IVersionable versionable : contentList) {
            ArrayList<IVersionable> versionableList = new ArrayList<IVersionable>();
            contentResult.put(versionable, versionableList);
            if (versionable == null) continue;
            if (versionable instanceof IFolder) {
                if (!fileOption.booleanValue()) {
                    versionableList.add(versionable);
                }
                Map children = configuration.childEntries((IFolderHandle)versionable, null);
                ArrayList<Object> childrenList = new ArrayList<Object>(children.size());
                if (folderOption.booleanValue()) {
                    for (IVersionableHandle versionableHandle : children.values()) {
                        if (!(versionableHandle instanceof IFolderHandle)) continue;
                        childrenList.add(versionableHandle);
                    }
                } else {
                    childrenList.addAll(children.values());
                }
                if (childrenList.size() == 0) continue;
                List completeChildren = configuration.fetchCompleteItems(childrenList, null);
                versionableList.addAll(SCMFileUtils.getDirectoryContentListAll(fileContentManager, configuration, completeChildren, fileOption, folderOption, dbg));
                continue;
            }
            if (versionable instanceof IFileItem) {
                if (folderOption.booleanValue()) continue;
                versionableList.add(versionable);
                continue;
            }
            dbg.log(Debug.error((String[])new String[]{className, new MethodName(){}.getName(), UTP, versionable.getName()}), 200);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentResult.size())});
        }
        return contentResult;
    }

    public static List<File> getDirectoryFileContentList(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFileContentList(fileContentManager, configuration, contentList, false, false, UTP, dbg);
    }

    public static List<File> getDirectoryFileContentList(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, Boolean fileOption, Boolean folderOption, String path, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        path = String.valueOf(path) + "/";
        String workspaceRoot = EclipseWorkspace.getWorkspacePath();
        ArrayList<File> fileContentResult = new ArrayList<File>();
        for (IVersionable versionable : contentList) {
            File file;
            if (versionable == null || FileUtilities.isHidden((String)versionable.getName())) continue;
            if (versionable instanceof IFolder) {
                if (!fileOption.booleanValue() && (file = new File(String.valueOf(workspaceRoot) + path + versionable.getName())).exists()) {
                    fileContentResult.add(file);
                }
                Map children = configuration.childEntries((IFolderHandle)versionable, null);
                ArrayList<Object> childrenList = new ArrayList<Object>(children.size());
                if (folderOption.booleanValue()) {
                    for (IVersionableHandle versionableHandle : children.values()) {
                        if (!(versionableHandle instanceof IFolderHandle)) continue;
                        childrenList.add(versionableHandle);
                    }
                } else {
                    childrenList.addAll(children.values());
                }
                if (childrenList.size() == 0) continue;
                List completeChildren = configuration.fetchCompleteItems(childrenList, null);
                fileContentResult.addAll(SCMFileUtils.getDirectoryFileContentList(fileContentManager, configuration, completeChildren, fileOption, folderOption, String.valueOf(path) + versionable.getName(), dbg));
                continue;
            }
            if (versionable instanceof IFileItem) {
                if (FileUtilities.isNoType((String)versionable.getName()) || folderOption.booleanValue() || !(file = new File(String.valueOf(workspaceRoot) + path + versionable.getName())).exists()) continue;
                fileContentResult.add(file);
                continue;
            }
            dbg.log(Debug.error((String[])new String[]{className, new MethodName(){}.getName(), UTP, versionable.getName()}), 200);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(fileContentResult.size())});
        }
        return fileContentResult;
    }

    public static List<File> getDirectoryFileContentListAll(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFileContentListAll(fileContentManager, configuration, contentList, false, false, UTP, dbg);
    }

    public static List<File> getDirectoryFileContentListAll(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, Boolean fileOption, Boolean folderOption, String path, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        path = String.valueOf(path) + "/";
        String workspaceRoot = EclipseWorkspace.getWorkspacePath();
        ArrayList<File> fileContentResult = new ArrayList<File>();
        for (IVersionable versionable : contentList) {
            File file;
            if (versionable == null) continue;
            if (versionable instanceof IFolder) {
                if (!fileOption.booleanValue() && (file = new File(String.valueOf(workspaceRoot) + path + versionable.getName())).exists()) {
                    fileContentResult.add(file);
                }
                Map children = configuration.childEntries((IFolderHandle)versionable, null);
                ArrayList<Object> childrenList = new ArrayList<Object>(children.size());
                if (folderOption.booleanValue()) {
                    for (IVersionableHandle versionableHandle : children.values()) {
                        if (!(versionableHandle instanceof IFolderHandle)) continue;
                        childrenList.add(versionableHandle);
                    }
                } else {
                    childrenList.addAll(children.values());
                }
                if (childrenList.size() == 0) continue;
                List completeChildren = configuration.fetchCompleteItems(childrenList, null);
                fileContentResult.addAll(SCMFileUtils.getDirectoryFileContentListAll(fileContentManager, configuration, completeChildren, fileOption, folderOption, String.valueOf(path) + versionable.getName(), dbg));
                continue;
            }
            if (versionable instanceof IFileItem) {
                if (folderOption.booleanValue() || !(file = new File(String.valueOf(workspaceRoot) + path + versionable.getName())).exists()) continue;
                fileContentResult.add(file);
                continue;
            }
            dbg.log(Debug.error((String[])new String[]{className, new MethodName(){}.getName(), UTP, versionable.getName()}), 200);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(fileContentResult.size())});
        }
        return fileContentResult;
    }

    public static Map<IVersionable, List<File>> getDirectoryFileContentProjectMap(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFileContentProjectMap(fileContentManager, configuration, contentList, false, false, UTP, dbg);
    }

    public static Map<IVersionable, List<File>> getDirectoryFileContentProjectMap(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, Boolean fileOption, Boolean folderOption, String path, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        path = String.valueOf(path) + "/";
        String workspaceRoot = EclipseWorkspace.getWorkspacePath();
        HashMap<IVersionable, List<File>> fileContentResult = new HashMap<IVersionable, List<File>>();
        for (IVersionable versionable : contentList) {
            File file;
            ArrayList<File> fileContentList = new ArrayList<File>();
            fileContentResult.put(versionable, fileContentList);
            if (versionable == null || FileUtilities.isHidden((String)versionable.getName())) continue;
            if (versionable instanceof IFolder) {
                if (!fileOption.booleanValue() && (file = new File(String.valueOf(workspaceRoot) + path + versionable.getName())).exists()) {
                    fileContentList.add(file);
                }
                Map children = configuration.childEntries((IFolderHandle)versionable, null);
                ArrayList<Object> childrenList = new ArrayList<Object>(children.size());
                if (folderOption.booleanValue()) {
                    for (IVersionableHandle versionableHandle : children.values()) {
                        if (!(versionableHandle instanceof IFolderHandle)) continue;
                        childrenList.add(versionableHandle);
                    }
                } else {
                    childrenList.addAll(children.values());
                }
                if (childrenList.size() == 0) continue;
                List completeChildren = configuration.fetchCompleteItems(childrenList, null);
                fileContentList.addAll(SCMFileUtils.getDirectoryFileContentList(fileContentManager, configuration, completeChildren, fileOption, folderOption, String.valueOf(path) + versionable.getName(), dbg));
                continue;
            }
            if (versionable instanceof IFileItem) {
                if (FileUtilities.isNoType((String)versionable.getName()) || folderOption.booleanValue() || !(file = new File(String.valueOf(workspaceRoot) + path + versionable.getName())).exists()) continue;
                fileContentList.add(file);
                continue;
            }
            dbg.log(Debug.error((String[])new String[]{className, new MethodName(){}.getName(), UTP, versionable.getName()}), 200);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(fileContentResult.size())});
        }
        return fileContentResult;
    }

    public static Map<IVersionable, List<File>> getDirectoryFileContentProjectMapAll(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFileContentProjectMapAll(fileContentManager, configuration, contentList, false, false, UTP, dbg);
    }

    public static Map<IVersionable, List<File>> getDirectoryFileContentProjectMapAll(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, Boolean fileOption, Boolean folderOption, String path, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        path = String.valueOf(path) + "/";
        String workspaceRoot = EclipseWorkspace.getWorkspacePath();
        HashMap<IVersionable, List<File>> fileContentResult = new HashMap<IVersionable, List<File>>();
        for (IVersionable versionable : contentList) {
            File file;
            ArrayList<File> fileContentList = new ArrayList<File>();
            fileContentResult.put(versionable, fileContentList);
            if (versionable == null) continue;
            if (versionable instanceof IFolder) {
                if (!fileOption.booleanValue() && (file = new File(String.valueOf(workspaceRoot) + path + versionable.getName())).exists()) {
                    fileContentList.add(file);
                }
                Map children = configuration.childEntries((IFolderHandle)versionable, null);
                ArrayList<Object> childrenList = new ArrayList<Object>(children.size());
                if (folderOption.booleanValue()) {
                    for (IVersionableHandle versionableHandle : children.values()) {
                        if (!(versionableHandle instanceof IFolderHandle)) continue;
                        childrenList.add(versionableHandle);
                    }
                } else {
                    childrenList.addAll(children.values());
                }
                if (childrenList.size() == 0) continue;
                List completeChildren = configuration.fetchCompleteItems(childrenList, null);
                fileContentList.addAll(SCMFileUtils.getDirectoryFileContentListAll(fileContentManager, configuration, completeChildren, fileOption, folderOption, String.valueOf(path) + versionable.getName(), dbg));
                continue;
            }
            if (versionable instanceof IFileItem) {
                if (folderOption.booleanValue() || !(file = new File(String.valueOf(workspaceRoot) + path + versionable.getName())).exists()) continue;
                fileContentList.add(file);
                continue;
            }
            dbg.log(Debug.error((String[])new String[]{className, new MethodName(){}.getName(), UTP, versionable.getName()}), 200);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(fileContentResult.size())});
        }
        return fileContentResult;
    }

    public static List<IVersionable> getDirectoryFiles(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFiles(fileContentManager, configuration, contentList, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static List<IVersionable> getDirectoryFiles(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        List<IVersionable> contentListResult = SCMFileUtils.getDirectoryContentList(fileContentManager, configuration, contentList, true, false, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        return contentListResult;
    }

    public static List<File> getDirectoryFilesAsFiles(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFilesAsFiles(fileContentManager, configuration, contentList, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static List<File> getDirectoryFilesAsFiles(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        List<File> contentListResult = SCMFileUtils.getDirectoryFileContentList(fileContentManager, configuration, contentList, true, false, UTP, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        return contentListResult;
    }

    public static Map<IVersionable, List<IVersionable>> getDirectoryFilesByProject(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFilesByProject(fileContentManager, configuration, contentList, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static Map<IVersionable, List<IVersionable>> getDirectoryFilesByProject(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryContentProjectMap(fileContentManager, configuration, contentList, true, false, dbg);
    }

    public static Map<IVersionable, List<File>> getDirectoryFilesByProjectAsFiles(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFilesByProjectAsFiles(fileContentManager, configuration, contentList, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static Map<IVersionable, List<File>> getDirectoryFilesByProjectAsFiles(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFileContentProjectMap(fileContentManager, configuration, contentList, true, false, UTP, dbg);
    }

    public static Map<IVersionable, String> getDirectoryFilesMap(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFilesMap(fileContentManager, configuration, contentList, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static Map<IVersionable, String> getDirectoryFilesMap(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        Map<IVersionable, String> contentMapResult = SCMFileUtils.getDirectoryContentMap(fileContentManager, configuration, contentList, true, false, UTP, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        return contentMapResult;
    }

    public static List<IVersionable> getDirectoryFolders(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFiles(fileContentManager, configuration, contentList, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static List<IVersionable> getDirectoryFolders(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        List<IVersionable> contentListResult = SCMFileUtils.getDirectoryContentList(fileContentManager, configuration, contentList, false, true, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        return contentListResult;
    }

    public static List<File> getDirectoryFoldersAsFiles(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFilesAsFiles(fileContentManager, configuration, contentList, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static List<File> getDirectoryFoldersAsFiles(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        List<File> contentListResult = SCMFileUtils.getDirectoryFileContentList(fileContentManager, configuration, contentList, false, true, UTP, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        return contentListResult;
    }

    public static Map<IVersionable, List<IVersionable>> getDirectoryFoldersByProject(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFoldersByProject(fileContentManager, configuration, contentList, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static Map<IVersionable, List<IVersionable>> getDirectoryFoldersByProject(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryContentProjectMap(fileContentManager, configuration, contentList, false, true, dbg);
    }

    public static Map<IVersionable, List<File>> getDirectoryFoldersByProjectAsFiles(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFoldersByProjectAsFiles(fileContentManager, configuration, contentList, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static Map<IVersionable, List<File>> getDirectoryFoldersByProjectAsFiles(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFileContentProjectMap(fileContentManager, configuration, contentList, false, true, UTP, dbg);
    }

    public static Map<IVersionable, String> getDirectoryFoldersMap(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList) throws TeamRepositoryException {
        return SCMFileUtils.getDirectoryFoldersMap(fileContentManager, configuration, contentList, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static Map<IVersionable, String> getDirectoryFoldersMap(IFileContentManager fileContentManager, IConfiguration configuration, List<IVersionable> contentList, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        Map<IVersionable, String> contentMapResult = SCMFileUtils.getDirectoryContentMap(fileContentManager, configuration, contentList, false, true, UTP, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        return contentMapResult;
    }

    public static String getFileAncestors(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IVersionable fileItem) throws TeamRepositoryException {
        return SCMFileUtils.getFileAncestors(wsConnection, componentHandle, fileItem, true, null, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static String getFileAncestors(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IVersionable fileItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMFileUtils.getFileAncestors(wsConnection, componentHandle, fileItem, true, monitor, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static String getFileAncestors(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IVersionable fileItem, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getFileAncestors(wsConnection, componentHandle, fileItem, true, null, dbg);
    }

    public static String getFileAncestors(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IVersionable fileItem, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getFileAncestors(wsConnection, componentHandle, fileItem, true, monitor, dbg);
    }

    public static String getFileAncestors(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IVersionable fileItem, boolean replaceFirst) throws TeamRepositoryException {
        return SCMFileUtils.getFileAncestors(wsConnection, componentHandle, fileItem, replaceFirst, null, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static String getFileAncestors(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IVersionable fileItem, boolean replaceFirst, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMFileUtils.getFileAncestors(wsConnection, componentHandle, fileItem, replaceFirst, monitor, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static String getFileAncestors(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IVersionable fileItem, boolean replaceFirst, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getFileAncestors(wsConnection, componentHandle, fileItem, replaceFirst, null, dbg);
    }

    public static String getFileAncestors(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IVersionable fileItem, boolean replaceFirst, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        String path = UTP;
        ArrayList<IVersionableHandle> fileItemHandleList = new ArrayList<IVersionableHandle>();
        fileItemHandleList.add((IVersionableHandle)fileItem.getItemHandle());
        List iAncestorReportList = new ArrayList();
        iAncestorReportList = wsConnection.configuration(componentHandle).determineAncestorsInHistory(fileItemHandleList, null);
        for (IAncestorReport iAncestorReport : iAncestorReportList) {
            for (Object nameItemPairObject : iAncestorReport.getNameItemPairs()) {
                INameItemPair nameItemPair = (INameItemPair)nameItemPairObject;
                String pathName = nameItemPair.getName();
                if (pathName == null || pathName.equals(UTP)) continue;
                path = String.valueOf(path) + "/" + pathName;
            }
        }
        if (replaceFirst) {
            path = path.replaceFirst("/", UTP);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((String)path)});
        }
        return path;
    }

    public static String getFileFullPath(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFileItem fileItem) throws TeamRepositoryException {
        return SCMFileUtils.getFileFullPath(wsConnection, componentHandle, fileItem, null, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static String getFileFullPath(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFileItem fileItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMFileUtils.getFileFullPath(wsConnection, componentHandle, fileItem, monitor, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static String getFileFullPath(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFileItem fileItem, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getFileFullPath(wsConnection, componentHandle, fileItem, null, dbg);
    }

    public static String getFileFullPath(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFileItem fileItem, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        String path = fileItem.getName();
        IFolderHandle parent = fileItem.getParent();
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        while (parent != null) {
            IFolder folder = (IFolder)configuration.fetchCompleteItem((IVersionableHandle)parent, monitor);
            path = String.valueOf(folder.getName()) + "/" + path;
            parent = folder.getParent();
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((String)path)});
        }
        return path;
    }

    public static IFileItem getFileItem(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFileItemHandle fileItemHandle) throws TeamRepositoryException {
        return SCMFileUtils.getFileItem(wsConnection, componentHandle, fileItemHandle, null, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static IFileItem getFileItem(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFileItemHandle fileItemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMFileUtils.getFileItem(wsConnection, componentHandle, fileItemHandle, monitor, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static IFileItem getFileItem(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFileItemHandle fileItemHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getFileItem(wsConnection, componentHandle, fileItemHandle, null, dbg);
    }

    public static IFileItem getFileItem(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFileItemHandle fileItemHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        IFileItem fileItem = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)fileItemHandle, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)fileItem)});
        }
        return fileItem;
    }

    public static IFileItemHandle getFileItemHandle(String fileItemUuid) throws TeamRepositoryException {
        return SCMFileUtils.getFileItemHandle(fileItemUuid, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static IFileItemHandle getFileItemHandle(String fileItemUuid, IDebugger dbg) throws TeamRepositoryException {
        IFileItemHandle fileItemHandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)fileItemUuid), null);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)fileItemHandle)});
        }
        return fileItemHandle;
    }

    public static IFolder getFolder(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFolderHandle folderHandle) throws TeamRepositoryException {
        return SCMFileUtils.getFolder(wsConnection, componentHandle, folderHandle, null, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static IFolder getFolder(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFolderHandle folderHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMFileUtils.getFolder(wsConnection, componentHandle, folderHandle, monitor, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static IFolder getFolder(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFolderHandle folderHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMFileUtils.getFolder(wsConnection, componentHandle, folderHandle, null, dbg);
    }

    public static IFolder getFolder(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFolderHandle folderHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        IFolder folder = (IFolder)configuration.fetchCompleteItem((IVersionableHandle)folderHandle, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)folder)});
        }
        return folder;
    }

    public static String getRootDirectory(IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMFileUtils.getRootDirectory(wsConnection, componentHandle, (IDebugger)new Debugger(SCMFileUtils.class));
    }

    public static String getRootDirectory(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        IFolderHandle folderHandle = configuration.rootFolderHandle(null);
        IFolder folder = (IFolder)configuration.fetchCompleteItem((IVersionableHandle)folderHandle, null);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        return folder.getName();
    }
}

