/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.client.util.CCMProcessArea;
import com.ibm.team.build.extensions.client.util.SCMFileUtils;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class SCMComponent {
    private static final String className = SCMComponent.class.getSimpleName();

    public static IComponent createComponent(ITeamRepository repository, IAuditableHandle ownerHandle, String componentName) throws TeamRepositoryException {
        return SCMComponent.createComponent(repository, ownerHandle, componentName, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static IComponent createComponent(ITeamRepository repository, IAuditableHandle ownerHandle, String componentName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.createComponent(repository, ownerHandle, componentName, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static IComponent createComponent(ITeamRepository repository, IAuditableHandle ownerHandle, String componentName, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.createComponent(repository, ownerHandle, componentName, null, dbg);
    }

    public static IComponent createComponent(ITeamRepository repository, IAuditableHandle ownerHandle, String componentName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IComponent result = workspaceManager.createComponent(componentName, ownerHandle, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)result)});
        }
        return result;
    }

    public static List<IComponentHandle> getComponentByWorkspace(ITeamRepository repository, IWorkspaceConnection wsConnection) throws TeamRepositoryException {
        return SCMComponent.getComponentByWorkspace(repository, wsConnection, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponentHandle> getComponentByWorkspace(ITeamRepository repository, IWorkspaceConnection wsConnection, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        List componentList = wsConnection.getComponents();
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(componentList.size())});
        }
        return componentList;
    }

    public static IConfiguration getComponentConfiguration(IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentConfiguration(wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static IConfiguration getComponentConfiguration(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentConfiguration(wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static IConfiguration getComponentConfiguration(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentConfiguration(wsConnection, componentHandle, null, dbg);
    }

    public static IConfiguration getComponentConfiguration(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)componentHandle)});
        }
        return configuration;
    }

    public static List<IVersionable> getComponentContent(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentContent(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentContent(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentContent(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentContent(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentContent(repository, wsConnection, componentHandle, null, dbg);
    }

    public static List<IVersionable> getComponentContent(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        List<IVersionable> contentList = SCMFileUtils.getDirectoryContentList(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentList.size())});
        }
        return contentList;
    }

    public static List<IVersionable> getComponentContent(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include) throws TeamRepositoryException {
        return SCMComponent.getComponentContent(repository, wsConnection, componentHandle, exclude, include, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentContent(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentContent(repository, wsConnection, componentHandle, exclude, include, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentContent(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentContent(repository, wsConnection, componentHandle, exclude, include, null, dbg);
    }

    public static List<IVersionable> getComponentContent(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IVersionable> folders;
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        if (Verification.isNonEmpty(exclude)) {
            folders = new ArrayList<IVersionable>();
            for (IVersionable primary : primaryList) {
                if (exclude.contains(primary.getName())) continue;
                folders.add(primary);
            }
            primaryList.clear();
            primaryList.addAll(folders);
        }
        if (Verification.isNonEmpty(include)) {
            folders = new ArrayList();
            for (IVersionable primary : primaryList) {
                if (!include.contains(primary.getName())) continue;
                folders.add(primary);
            }
            primaryList.clear();
            primaryList.addAll(folders);
        }
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        List<IVersionable> contentList = SCMFileUtils.getDirectoryContentList(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentList.size())});
        }
        return contentList;
    }

    public static List<File> getComponentContentAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentContentAsFiles(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<File> getComponentContentAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentContentAsFiles(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<File> getComponentContentAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentContentAsFiles(repository, wsConnection, componentHandle, null, dbg);
    }

    public static List<File> getComponentContentAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        List<File> contentList = SCMFileUtils.getDirectoryFileContentList(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentList.size())});
        }
        return contentList;
    }

    public static Map<IVersionable, String> getComponentContentMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentContentMap(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, String> getComponentContentMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentContentMap(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, String> getComponentContentMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentContentMap(repository, wsConnection, componentHandle, null, dbg);
    }

    public static Map<IVersionable, String> getComponentContentMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        Map<IVersionable, String> contentMap = SCMFileUtils.getDirectoryContentMap(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMap.size())});
        }
        return contentMap;
    }

    public static Map<IVersionable, List<IVersionable>> getComponentContentByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentContentByProject(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<IVersionable>> getComponentContentByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentContentByProject(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<IVersionable>> getComponentContentByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentContentByProject(repository, wsConnection, componentHandle, null, dbg);
    }

    public static Map<IVersionable, List<IVersionable>> getComponentContentByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        Map<IVersionable, List<IVersionable>> contentMap = SCMFileUtils.getDirectoryContentProjectMap(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMap.size())});
        }
        return contentMap;
    }

    public static Map<IVersionable, List<File>> getComponentContentByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentContentByProjectAsFiles(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<File>> getComponentContentByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentContentByProjectAsFiles(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<File>> getComponentContentByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentContentByProjectAsFiles(repository, wsConnection, componentHandle, null, dbg);
    }

    public static Map<IVersionable, List<File>> getComponentContentByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        Map<IVersionable, List<File>> contentMap = SCMFileUtils.getDirectoryFileContentProjectMap(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMap.size())});
        }
        return contentMap;
    }

    public static List<IVersionable> getComponentFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentFiles(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFiles(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFiles(repository, wsConnection, componentHandle, null, dbg);
    }

    public static List<IVersionable> getComponentFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        List<IVersionable> contentList = SCMFileUtils.getDirectoryFiles(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentList.size())});
        }
        return contentList;
    }

    public static List<IVersionable> getComponentFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include) throws TeamRepositoryException {
        return SCMComponent.getComponentFiles(repository, wsConnection, componentHandle, exclude, include, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFiles(repository, wsConnection, componentHandle, exclude, include, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFiles(repository, wsConnection, componentHandle, exclude, include, null, dbg);
    }

    public static List<IVersionable> getComponentFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IVersionable> folders;
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        if (Verification.isNonEmpty(exclude)) {
            folders = new ArrayList<IVersionable>();
            for (IVersionable primary : primaryList) {
                if (exclude.contains(primary.getName())) continue;
                folders.add(primary);
            }
            primaryList.clear();
            primaryList.addAll(folders);
        }
        if (Verification.isNonEmpty(include)) {
            folders = new ArrayList();
            for (IVersionable primary : primaryList) {
                if (!include.contains(primary.getName())) continue;
                folders.add(primary);
            }
            primaryList.clear();
            primaryList.addAll(folders);
        }
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        List<IVersionable> contentList = SCMFileUtils.getDirectoryFiles(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentList.size())});
        }
        return contentList;
    }

    public static List<File> getComponentFilesAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesAsFiles(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<File> getComponentFilesAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesAsFiles(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<File> getComponentFilesAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesAsFiles(repository, wsConnection, componentHandle, null, dbg);
    }

    public static List<File> getComponentFilesAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        List<File> contentList = SCMFileUtils.getDirectoryFilesAsFiles(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentList.size())});
        }
        return contentList;
    }

    public static Map<IVersionable, List<IVersionable>> getComponentFilesByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesByProject(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<IVersionable>> getComponentFilesByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesByProject(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<IVersionable>> getComponentFilesByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesByProject(repository, wsConnection, componentHandle, null, dbg);
    }

    public static Map<IVersionable, List<IVersionable>> getComponentFilesByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        Map<IVersionable, List<IVersionable>> contentMap = SCMFileUtils.getDirectoryFilesByProject(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMap.size())});
        }
        return contentMap;
    }

    public static Map<IVersionable, List<File>> getComponentFilesByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesByProjectAsFiles(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<File>> getComponentFilesByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesByProjectAsFiles(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<File>> getComponentFilesByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesByProjectAsFiles(repository, wsConnection, componentHandle, null, dbg);
    }

    public static Map<IVersionable, List<File>> getComponentFilesByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        Map<IVersionable, List<File>> contentMap = SCMFileUtils.getDirectoryFilesByProjectAsFiles(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMap.size())});
        }
        return contentMap;
    }

    public static Map<IVersionable, String> getComponentFilesMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesMap(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, String> getComponentFilesMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesMap(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, String> getComponentFilesMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFilesMap(repository, wsConnection, componentHandle, null, dbg);
    }

    public static Map<IVersionable, String> getComponentFilesMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        Map<IVersionable, String> contentMap = SCMFileUtils.getDirectoryFilesMap(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMap.size())});
        }
        return contentMap;
    }

    public static List<IVersionable> getComponentFolders(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentFolders(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentFolders(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFolders(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentFolders(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFolders(repository, wsConnection, componentHandle, null, dbg);
    }

    public static List<IVersionable> getComponentFolders(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        List<IVersionable> contentList = SCMFileUtils.getDirectoryFolders(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentList.size())});
        }
        return contentList;
    }

    public static List<IVersionable> getComponentFolders(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include) throws TeamRepositoryException {
        return SCMComponent.getComponentFolders(repository, wsConnection, componentHandle, exclude, include, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentFolders(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFolders(repository, wsConnection, componentHandle, exclude, include, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IVersionable> getComponentFolders(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFolders(repository, wsConnection, componentHandle, exclude, include, null, dbg);
    }

    public static List<IVersionable> getComponentFolders(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, List<String> exclude, List<String> include, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IVersionable> folders;
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        if (Verification.isNonEmpty(exclude)) {
            folders = new ArrayList<IVersionable>();
            for (IVersionable primary : primaryList) {
                if (exclude.contains(primary.getName())) continue;
                folders.add(primary);
            }
            primaryList.clear();
            primaryList.addAll(folders);
        }
        if (Verification.isNonEmpty(include)) {
            folders = new ArrayList();
            for (IVersionable primary : primaryList) {
                if (!include.contains(primary.getName())) continue;
                folders.add(primary);
            }
            primaryList.clear();
            primaryList.addAll(folders);
        }
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        List<IVersionable> contentList = SCMFileUtils.getDirectoryFolders(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentList.size())});
        }
        return contentList;
    }

    public static List<File> getComponentFoldersAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersAsFiles(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<File> getComponentFoldersAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersAsFiles(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<File> getComponentFoldersAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersAsFiles(repository, wsConnection, componentHandle, null, dbg);
    }

    public static List<File> getComponentFoldersAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        List<File> contentList = SCMFileUtils.getDirectoryFoldersAsFiles(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentList.size())});
        }
        return contentList;
    }

    public static Map<IVersionable, List<IVersionable>> getComponentFoldersByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersByProject(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<IVersionable>> getComponentFoldersByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersByProject(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<IVersionable>> getComponentFoldersByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersByProject(repository, wsConnection, componentHandle, null, dbg);
    }

    public static Map<IVersionable, List<IVersionable>> getComponentFoldersByProject(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        Map<IVersionable, List<IVersionable>> contentMap = SCMFileUtils.getDirectoryFoldersByProject(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMap.size())});
        }
        return contentMap;
    }

    public static Map<IVersionable, List<File>> getComponentFoldersByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersByProjectAsFiles(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<File>> getComponentFoldersByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersByProjectAsFiles(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, List<File>> getComponentFoldersByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersByProjectAsFiles(repository, wsConnection, componentHandle, null, dbg);
    }

    public static Map<IVersionable, List<File>> getComponentFoldersByProjectAsFiles(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        Map<IVersionable, List<File>> contentMap = SCMFileUtils.getDirectoryFoldersByProjectAsFiles(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMap.size())});
        }
        return contentMap;
    }

    public static Map<IVersionable, String> getComponentFoldersMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersMap(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, String> getComponentFoldersMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersMap(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Map<IVersionable, String> getComponentFoldersMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentFoldersMap(repository, wsConnection, componentHandle, null, dbg);
    }

    public static Map<IVersionable, String> getComponentFoldersMap(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repository);
        Map<IVersionable, String> contentMap = SCMFileUtils.getDirectoryFoldersMap(contentManager, configuration, primaryList, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(contentMap.size())});
        }
        return contentMap;
    }

    public static IComponentHandle getComponentHandle(ITeamRepository repository, String componentName) throws TeamRepositoryException {
        return SCMComponent.getComponentHandle(repository, componentName, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static IComponentHandle getComponentHandle(ITeamRepository repository, String componentName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentHandle(repository, componentName, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static IComponentHandle getComponentHandle(ITeamRepository repository, String componentName, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentHandle(repository, componentName, null, dbg);
    }

    public static IComponentHandle getComponentHandle(ITeamRepository repository, String componentName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IComponentSearchCriteria componentSearchCriteria = IComponentSearchCriteria.FACTORY.newInstance().setExactName(componentName);
        List componentHandleList = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).findComponents(componentSearchCriteria, 1, monitor);
        if (componentHandleList == null || componentHandleList.size() != 1) {
            throw new TeamRepositoryException(NLS.bind((String)Common.COMMON_NOTFOUND_COMPONENT, (Object)componentName, (Object[])new Object[0]));
        }
        IComponentHandle result = (IComponentHandle)componentHandleList.get(0);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static IComponent getComponent(ITeamRepository repository, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponent(repository, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static IComponent getComponent(ITeamRepository repository, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponent(repository, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static IComponent getComponent(ITeamRepository repository, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponent(repository, componentHandle, null, dbg);
    }

    public static IComponent getComponent(ITeamRepository repository, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IComponent component = (IComponent)repository.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)component)});
        }
        return component;
    }

    public static List<IComponent> getComponents(ITeamRepository repository, String namePattern) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, namePattern, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponents(ITeamRepository repository, String namePattern, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, namePattern, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponents(ITeamRepository repository, String namePattern, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, namePattern, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponents(ITeamRepository repository, String namePattern, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IComponentSearchCriteria componentSearchCriteria = IComponentSearchCriteria.FACTORY.newInstance();
        componentSearchCriteria.setPartialName(namePattern);
        List componentHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).findComponents(componentSearchCriteria, Integer.MAX_VALUE, monitor);
        List<IComponent> components = SCMComponent.getComponentList(repository, componentHandles, monitor, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(components.size())});
        }
        return components;
    }

    public static List<IComponent> getComponents(ITeamRepository repository, IProcessAreaHandle processAreaHandle) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, processAreaHandle, false, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponents(ITeamRepository repository, IProcessAreaHandle processAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, processAreaHandle, false, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponents(ITeamRepository repository, IProcessAreaHandle processAreaHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, processAreaHandle, false, null, dbg);
    }

    public static List<IComponent> getComponents(ITeamRepository repository, IProcessAreaHandle processAreaHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, processAreaHandle, false, monitor, dbg);
    }

    public static List<IComponent> getComponents(ITeamRepository repository, IProcessAreaHandle processAreaHandle, boolean includeLoggedInContributor) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, processAreaHandle, includeLoggedInContributor, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponents(ITeamRepository repository, IProcessAreaHandle processAreaHandle, boolean includeLoggedInContributor, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, processAreaHandle, includeLoggedInContributor, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponents(ITeamRepository repository, IProcessAreaHandle processAreaHandle, boolean includeLoggedInContributor, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, processAreaHandle, includeLoggedInContributor, null, dbg);
    }

    public static List<IComponent> getComponents(ITeamRepository repository, IProcessAreaHandle processAreaHandle, boolean includeLoggedInContributor, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IComponentSearchCriteria componentSearchCriteria = IComponentSearchCriteria.FACTORY.newInstance();
        componentSearchCriteria.getFilterByOwnerOptional().add(processAreaHandle);
        if (processAreaHandle instanceof IProjectArea) {
            componentSearchCriteria.getFilterByOwnerOptional().addAll(((IProjectArea)processAreaHandle).getTeamAreas());
        } else if (processAreaHandle instanceof IProjectAreaHandle) {
            IProjectArea projectArea = CCMProcessArea.getProjectArea(repository, (IProjectAreaHandle)processAreaHandle, monitor, dbg);
            componentSearchCriteria.getFilterByOwnerOptional().addAll(projectArea.getTeamAreas());
        }
        if (includeLoggedInContributor) {
            componentSearchCriteria.getFilterByOwnerOptional().add(repository.loggedInContributor());
        }
        List componentHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).findComponents(componentSearchCriteria, Integer.MAX_VALUE, monitor);
        List<IComponent> components = SCMComponent.getComponentList(repository, componentHandles, monitor, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(components.size())});
        }
        return components;
    }

    public static List<IComponent> getComponents(ITeamRepository repository, List<IComponentHandle> componentHandles) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, componentHandles, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponents(ITeamRepository repository, List<IComponentHandle> componentHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, componentHandles, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponents(ITeamRepository repository, List<IComponentHandle> componentHandles, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponents(repository, componentHandles, null, dbg);
    }

    public static List<IComponent> getComponents(ITeamRepository repository, List<IComponentHandle> componentHandles, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        List componentList = repository.itemManager().fetchCompleteItems(Arrays.asList(componentHandles.toArray()), 0, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(componentList.size())});
        }
        return componentList;
    }

    public static List<IComponent> getComponentList(ITeamRepository repository, List<IComponentHandle> componentHandleList) throws TeamRepositoryException {
        return SCMComponent.getComponentList(repository, componentHandleList, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponentList(ITeamRepository repository, List<IComponentHandle> componentHandleList, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentList(repository, componentHandleList, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<IComponent> getComponentList(ITeamRepository repository, List<IComponentHandle> componentHandleList, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentList(repository, componentHandleList, null, dbg);
    }

    public static List<IComponent> getComponentList(ITeamRepository repository, List<IComponentHandle> componentHandleList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        List componentList = repository.itemManager().fetchPartialItems(Arrays.asList(componentHandleList.toArray()), 1, Arrays.asList(IComponent.ROOT_FOLDER_PROPERTY, IComponent.NAME_PROPERTY), monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(componentList.size())});
        }
        return componentList;
    }

    public static Set<String> getComponentNames(ITeamRepository repository) throws TeamRepositoryException {
        return SCMComponent.getComponentNames(repository, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Set<String> getComponentNames(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentNames(repository, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static Set<String> getComponentNames(ITeamRepository repository, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentNames(repository, null, dbg);
    }

    public static Set<String> getComponentNames(ITeamRepository repository, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        Set result = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).findAllComponentNames(monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Collection)result)});
        }
        return result;
    }

    public static List<String> getComponentPrimaryNameList(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle) throws TeamRepositoryException {
        return SCMComponent.getComponentPrimaryNameList(repository, wsConnection, componentHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<String> getComponentPrimaryNameList(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getComponentPrimaryNameList(repository, wsConnection, componentHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static List<String> getComponentPrimaryNameList(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getComponentPrimaryNameList(repository, wsConnection, componentHandle, null, dbg);
    }

    public static List<String> getComponentPrimaryNameList(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(null);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        ArrayList<String> primaryNameList = new ArrayList<String>();
        for (IVersionable versionable : primaryList) {
            primaryNameList.add(versionable.getName());
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(primaryNameList.size())});
        }
        return primaryNameList;
    }

    public static IVersionable getProjectFolder(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, String projectName) throws TeamRepositoryException {
        return SCMComponent.getProjectFolder(repository, wsConnection, componentHandle, projectName, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static IVersionable getProjectFolder(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, String projectName, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMComponent.getProjectFolder(repository, wsConnection, componentHandle, projectName, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static IVersionable getProjectFolder(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, String projectName, IDebugger dbg) throws TeamRepositoryException {
        return SCMComponent.getProjectFolder(repository, wsConnection, componentHandle, projectName, null, dbg);
    }

    public static IVersionable getProjectFolder(ITeamRepository repository, IWorkspaceConnection wsConnection, IComponentHandle componentHandle, String projectName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IVersionable result = null;
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        Map versionableHandleMap = configuration.childEntriesForRoot(monitor);
        List primaryList = configuration.fetchCompleteItems(new ArrayList(versionableHandleMap.values()), monitor);
        for (IVersionable versionable : primaryList) {
            if (!versionable.getName().equals(projectName)) continue;
            result = versionable;
            break;
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)result)});
        }
        return result;
    }

    public static void setComponentOwner(ITeamRepository repository, IComponentHandle componentHandle, IAuditableHandle ownerHandle) throws TeamRepositoryException {
        SCMComponent.setComponentOwner(repository, componentHandle, ownerHandle, null, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static void setComponentOwner(ITeamRepository repository, IComponentHandle componentHandle, IAuditableHandle ownerHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SCMComponent.setComponentOwner(repository, componentHandle, ownerHandle, monitor, (IDebugger)new Debugger(SCMComponent.class));
    }

    public static void setComponentOwner(ITeamRepository repository, IComponentHandle componentHandle, IAuditableHandle ownerHandle, IDebugger dbg) throws TeamRepositoryException {
        SCMComponent.setComponentOwner(repository, componentHandle, ownerHandle, null, dbg);
    }

    public static void setComponentOwner(ITeamRepository repository, IComponentHandle componentHandle, IAuditableHandle ownerHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        workspaceManager.setComponentOwner(componentHandle, ownerHandle, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)componentHandle)});
        }
    }
}

