/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.Arrays;
import java.util.List;

public class SCMChangeset {
    private static final String className = SCMChangeset.class.getSimpleName();

    public static IChangeSet getChangeset(ITeamRepository repository, IChangeSetHandle changeSetHandle) throws TeamRepositoryException {
        return SCMChangeset.getChangeset(repository, changeSetHandle, (IDebugger)new Debugger(SCMChangeset.class));
    }

    public static IChangeSet getChangeset(ITeamRepository repository, IChangeSetHandle changeSetHandle, IDebugger dbg) throws TeamRepositoryException {
        IChangeSet changeSet = (IChangeSet)repository.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 0, null);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)changeSet)});
        }
        return changeSet;
    }

    public static IChangeSet getPartialChangeset(ITeamRepository repository, IChangeSetHandle changeSetHandle, List<String> properties) throws TeamRepositoryException {
        return SCMChangeset.getPartialChangeset(repository, changeSetHandle, properties, (IDebugger)new Debugger(SCMChangeset.class));
    }

    public static IChangeSet getPartialChangeset(ITeamRepository repository, IChangeSetHandle changeSetHandle, List<String> properties, IDebugger dbg) throws TeamRepositoryException {
        IChangeSet changeSet = (IChangeSet)repository.itemManager().fetchPartialItem((IItemHandle)changeSetHandle, 1, properties, null);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)changeSet)});
        }
        return changeSet;
    }

    public static IChangeSet getSnapshotChangeset(ITeamRepository repository, IChangeSetHandle changeSetHandle) throws TeamRepositoryException {
        return SCMChangeset.getSnapshotChangeset(repository, changeSetHandle, (IDebugger)new Debugger(SCMChangeset.class));
    }

    public static IChangeSet getSnapshotChangeset(ITeamRepository repository, IChangeSetHandle changeSetHandle, IDebugger dbg) throws TeamRepositoryException {
        IChangeSet changeSet = (IChangeSet)repository.itemManager().fetchPartialItem((IItemHandle)changeSetHandle, 1, Arrays.asList(IChangeSet.CHANGES_PROPERTY, IChangeSet.COMMENT_PROPERTY, IChangeSet.COMPONENT_PROPERTY, IChangeSet.LAST_CHANGED_DATE_PROPERTY), null);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)changeSet)});
        }
        return changeSet;
    }
}

