/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class SCMBaseline {
    private static final String className = SCMBaseline.class.getSimpleName();

    public static IBaseline getBaseline(ITeamRepository repository, IBaselineHandle baselineHandle) throws TeamRepositoryException {
        return SCMBaseline.getBaseline(repository, baselineHandle, null, (IDebugger)new Debugger(SCMBaseline.class));
    }

    public static IBaseline getBaseline(ITeamRepository repository, IBaselineHandle baselineHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMBaseline.getBaseline(repository, baselineHandle, monitor, (IDebugger)new Debugger(SCMBaseline.class));
    }

    public static IBaseline getBaseline(ITeamRepository repository, IBaselineHandle baselineHandle, IDebugger dbg) throws TeamRepositoryException {
        return SCMBaseline.getBaseline(repository, baselineHandle, null, dbg);
    }

    public static IBaseline getBaseline(ITeamRepository repository, IBaselineHandle baselineHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBaseline baseline = (IBaseline)repository.itemManager().fetchCompleteItem((IItemHandle)baselineHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)baseline)});
        }
        return baseline;
    }

    public static List<IBaselineSet> getBaselineSets(ITeamRepository repository, List<IBaselineSetHandle> handles) throws TeamRepositoryException {
        return SCMBaseline.getBaselineSets(repository, handles, null, (IDebugger)new Debugger(SCMBaseline.class));
    }

    public static List<IBaselineSet> getBaselineSets(ITeamRepository repository, List<IBaselineSetHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMBaseline.getBaselineSets(repository, handles, monitor, (IDebugger)new Debugger(SCMBaseline.class));
    }

    public static List<IBaselineSet> getBaselineSets(ITeamRepository repository, List<IBaselineSetHandle> handles, IDebugger dbg) throws TeamRepositoryException {
        return SCMBaseline.getBaselineSets(repository, handles, null, dbg);
    }

    public static List<IBaselineSet> getBaselineSets(ITeamRepository repository, List<IBaselineSetHandle> handles, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List baselines = repository.itemManager().fetchCompleteItems(handles, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((List)baselines)});
        }
        return baselines;
    }

    public static void deleteBaselineSets(ITeamRepository repository, List<IBaselineSetHandle> handles) throws TeamRepositoryException {
        SCMBaseline.deleteBaselineSets(repository, handles, null, (IDebugger)new Debugger(SCMBaseline.class));
    }

    public static void deleteBaselineSets(ITeamRepository repository, List<IBaselineSetHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        SCMBaseline.deleteBaselineSets(repository, handles, monitor, (IDebugger)new Debugger(SCMBaseline.class));
    }

    public static void deleteBaselineSets(ITeamRepository repository, List<IBaselineSetHandle> handles, IDebugger dbg) throws TeamRepositoryException {
        SCMBaseline.deleteBaselineSets(repository, handles, null, dbg);
    }

    public static void deleteBaselineSets(ITeamRepository repository, List<IBaselineSetHandle> handles, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        repository.itemManager().fetchCompleteItems(handles, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(handles)});
        }
    }
}

