/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.client.debug.ClientLogString;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.repository.client.ILoginHandler2;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.login.UsernameAndPasswordLoginInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.IProgressMonitor;

public class Repository {
    private static final String className = Repository.class.getSimpleName();

    public static ITeamRepository getTeamRepository(UUID repositoryId) {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repositoryId.equals((Object)repository.getId())) {
                return repository;
            }
            ++n2;
        }
        return null;
    }

    public static boolean loggedIn(String repositoryAddress) {
        return Repository.loggedIn(repositoryAddress, (IDebugger)new Debugger(Repository.class));
    }

    public static boolean loggedIn(String repositoryAddress, IDebugger dbg) {
        ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryAddress);
        boolean result = repository.loggedIn();
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), ClientLogString.valueOf(result)});
        }
        return result;
    }

    public static ITeamRepository login(String repositoryAddress, String userId, String password) throws TeamRepositoryException {
        return Repository.login(repositoryAddress, userId, password, null, (IDebugger)new Debugger(Repository.class));
    }

    public static ITeamRepository login(String repositoryAddress, String userId, String password, IProgressMonitor monitor) throws TeamRepositoryException {
        return Repository.login(repositoryAddress, userId, password, monitor, (IDebugger)new Debugger(Repository.class));
    }

    public static ITeamRepository login(String repositoryAddress, String userId, String password, IDebugger dbg) throws TeamRepositoryException {
        return Repository.login(repositoryAddress, userId, password, null, dbg);
    }

    public static ITeamRepository login(String repositoryAddress, final String userId, final String password, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryAddress);
        repository.registerLoginHandler(new ILoginHandler2(){

            public ILoginInfo2 challenge(ITeamRepository repo) {
                return new UsernameAndPasswordLoginInfo(userId, password);
            }
        });
        repository.login(monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), ClientLogString.valueOf(repository)});
        }
        return repository;
    }

    public static void logout(String repositoryAddress) {
        ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryAddress);
        Repository.logout(repository, (IDebugger)new Debugger(Repository.class));
    }

    public static void logout(String repositoryAddress, IDebugger dbg) {
        ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryAddress);
        Repository.logout(repository, dbg);
    }

    public static void logout(ITeamRepository repository) {
        Repository.logout(repository, (IDebugger)new Debugger(Repository.class));
    }

    public static void logout(ITeamRepository repository, IDebugger dbg) {
        repository.logout();
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), ClientLogString.valueOf(repository)});
        }
    }

    public static boolean startup() throws TeamRepositoryException {
        return Repository.startup((IDebugger)new Debugger(Repository.class));
    }

    public static boolean startup(IDebugger dbg) throws TeamRepositoryException {
        boolean result;
        boolean bl = result = !TeamPlatform.isStarted();
        if (result) {
            TeamPlatform.startup();
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((boolean)result)});
        }
        return result;
    }

    public static ITeamRepository startup(String repositoryAddress, String userId, String password) throws TeamRepositoryException {
        return Repository.startup(repositoryAddress, userId, password, null, (IDebugger)new Debugger(Repository.class));
    }

    public static ITeamRepository startup(String repositoryAddress, String userId, String password, IProgressMonitor monitor) throws TeamRepositoryException {
        return Repository.startup(repositoryAddress, userId, password, monitor, (IDebugger)new Debugger(Repository.class));
    }

    public static ITeamRepository startup(String repositoryAddress, String userId, String password, IDebugger dbg) throws TeamRepositoryException {
        return Repository.startup(repositoryAddress, userId, password, null, dbg);
    }

    public static ITeamRepository startup(String repositoryAddress, String userId, String password, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        ITeamRepository repository = Repository.login(repositoryAddress, userId, password, monitor, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), ClientLogString.valueOf(repository)});
        }
        return repository;
    }

    public static void shutdown(ITeamRepository repository) throws TeamRepositoryException {
        Repository.shutdown(repository, (IDebugger)new Debugger(Repository.class));
    }

    public static void shutdown(ITeamRepository repository, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        repository.logout();
        TeamPlatform.shutdown();
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
    }
}

