/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.model.query.BaseWorkItemQueryModel;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CCMWorkItem {
    private static final String className = CCMWorkItem.class.getSimpleName();

    public static IWorkItem getWorkItem(ITeamRepository repository, Integer workItemId) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItem(repository, workItemId, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, Integer workItemId, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItem(repository, workItemId, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, Integer workItemId, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItem(repository, workItemId, null, dbg);
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, Integer workItemId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        IWorkItemHandle workItemHandle = CCMWorkItem.getWorkItemHandle(workItemClient, workItemId, monitor, dbg);
        IWorkItem workItem = (IWorkItem)repository.itemManager().fetchCompleteItem((IItemHandle)workItemHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)workItem)});
        }
        return workItem;
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, String workItemId) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItem(repository, workItemId, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, String workItemId, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItem(repository, workItemId, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, String workItemId, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItem(repository, workItemId, null, dbg);
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, String workItemId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkItem workItem = null;
        workItem = Verification.isUUID((String)workItemId) ? CCMWorkItem.getWorkItem(repository, (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemId), null), monitor, dbg) : (IWorkItem)repository.itemManager().fetchCompleteItem((IItemHandle)CCMWorkItem.getWorkItemHandle(repository, Integer.valueOf(workItemId), monitor, dbg), 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)workItem)});
        }
        return workItem;
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, IWorkItemHandle workItemHandle) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItem(repository, workItemHandle, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, IWorkItemHandle workItemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItem(repository, workItemHandle, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, IWorkItemHandle workItemHandle, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItem(repository, workItemHandle, null, dbg);
    }

    public static IWorkItem getWorkItem(ITeamRepository repository, IWorkItemHandle workItemHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkItem workItem = (IWorkItem)repository.itemManager().fetchCompleteItem((IItemHandle)workItemHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)workItem)});
        }
        return workItem;
    }

    public static List<IWorkItem> getWorkItems(ITeamRepository repository, List<?> workItemList) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItems(repository, workItemList, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItem> getWorkItems(ITeamRepository repository, List<?> workItemList, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItems(repository, workItemList, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItem> getWorkItems(ITeamRepository repository, List<?> workItemList, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItems(repository, workItemList, null, dbg);
    }

    public static List<IWorkItem> getWorkItems(ITeamRepository repository, List<?> workItemList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IWorkItem> result = new ArrayList<IWorkItem>();
        if (workItemList != null && workItemList.size() > 0) {
            if (workItemList.get(0) instanceof Integer) {
                result = CCMWorkItem.getWorkItemsFromIds(repository, workItemList, monitor, dbg);
            } else if (workItemList.get(0) instanceof String) {
                result = Verification.isUUID((String)((String)((Object)workItemList.get(0)))) ? CCMWorkItem.getWorkItemsFromUuids(repository, workItemList, monitor, dbg) : CCMWorkItem.getWorkItemsFromStringIds(repository, workItemList, monitor, dbg);
            } else if (workItemList.get(0) instanceof IWorkItemHandle) {
                result = CCMWorkItem.getWorkItemsFromHandles(repository, workItemList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(result.size())});
        }
        return result;
    }

    private static List<IWorkItem> getWorkItemsFromHandles(ITeamRepository repository, List<IWorkItemHandle> workItemList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List result = repository.itemManager().fetchCompleteItems(workItemList, 0, monitor);
        return result;
    }

    private static List<IWorkItem> getWorkItemsFromIds(ITeamRepository repository, List<Integer> workItemList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IWorkItemHandle> handleList = CCMWorkItem.getWorkItemHandles(repository, workItemList, monitor, dbg);
        List result = repository.itemManager().fetchCompleteItems(handleList, 0, monitor);
        return result;
    }

    private static List<IWorkItem> getWorkItemsFromStringIds(ITeamRepository repository, List<String> workItemList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (String workItem : workItemList) {
            integerList.add(Integer.valueOf(workItem));
        }
        List<IWorkItemHandle> handleList = CCMWorkItem.getWorkItemHandles(repository, integerList, monitor, dbg);
        List result = repository.itemManager().fetchCompleteItems(handleList, 0, monitor);
        return result;
    }

    private static List<IWorkItem> getWorkItemsFromUuids(ITeamRepository repository, List<String> workItemList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkItem> result = new ArrayList<IWorkItem>();
        ArrayList<IWorkItemHandle> handleList = new ArrayList<IWorkItemHandle>();
        for (String uuid : workItemList) {
            handleList.add((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
        }
        result.addAll(repository.itemManager().fetchCompleteItems(handleList, 0, monitor));
        return result;
    }

    public static IWorkItemHandle getWorkItemHandle(String workItemUuid) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle(workItemUuid, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItemHandle getWorkItemHandle(String workItemUuid, IDebugger dbg) throws TeamRepositoryException {
        IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemUuid), null);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workItemHandle)});
        }
        return workItemHandle;
    }

    public static IWorkItemHandle getWorkItemHandle(ITeamRepository repository, Integer workItemId) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle(repository, workItemId, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItemHandle getWorkItemHandle(ITeamRepository repository, Integer workItemId, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle(repository, workItemId, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItemHandle getWorkItemHandle(ITeamRepository repository, Integer workItemId, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle(repository, workItemId, null, dbg);
    }

    public static IWorkItemHandle getWorkItemHandle(ITeamRepository repository, Integer workItemId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle((IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class), workItemId, monitor, dbg);
    }

    public static IWorkItemHandle getWorkItemHandle(ITeamRepository repository, String workItemId) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle(repository, workItemId, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItemHandle getWorkItemHandle(ITeamRepository repository, String workItemId, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle(repository, workItemId, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItemHandle getWorkItemHandle(ITeamRepository repository, String workItemId, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle(repository, workItemId, null, dbg);
    }

    public static IWorkItemHandle getWorkItemHandle(ITeamRepository repository, String workItemId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkItemHandle result = null;
        if (Verification.isUUID((String)workItemId)) {
            result = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemId), null);
        } else {
            IWorkItemClient client = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
            result = client.findWorkItemById(Integer.valueOf(workItemId).intValue(), IWorkItem.FULL_PROFILE, monitor);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static IWorkItemHandle getWorkItemHandle(IWorkItemClient workItemClient, Integer workItemId) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle(workItemClient, workItemId, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItemHandle getWorkItemHandle(IWorkItemClient workItemClient, Integer workItemId, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle(workItemClient, workItemId, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItemHandle getWorkItemHandle(IWorkItemClient workItemClient, Integer workItemId, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandle(workItemClient, workItemId, null, dbg);
    }

    public static IWorkItemHandle getWorkItemHandle(IWorkItemClient workItemClient, Integer workItemId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkItem workItemHandle = workItemClient.findWorkItemById(workItemId.intValue(), IWorkItem.FULL_PROFILE, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workItemHandle)});
        }
        return workItemHandle;
    }

    public static IWorkItemHandle getWorkItemHandleViaId(ITeamRepository repository, String workItemId) {
        return CCMWorkItem.getWorkItemHandleViaId(repository, workItemId, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItemHandle getWorkItemHandleViaId(ITeamRepository repository, String workItemId, IProgressMonitor monitor) {
        return CCMWorkItem.getWorkItemHandleViaId(repository, workItemId, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static IWorkItemHandle getWorkItemHandleViaId(ITeamRepository repository, String workItemId, IDebugger dbg) {
        return CCMWorkItem.getWorkItemHandleViaId(repository, workItemId, null, dbg);
    }

    public static IWorkItemHandle getWorkItemHandleViaId(ITeamRepository repository, String workItemId, IProgressMonitor monitor, IDebugger dbg) {
        IWorkItemHandle result;
        block2: {
            result = null;
            try {
                result = CCMWorkItem.getWorkItemHandle((IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class), Integer.valueOf(workItemId), monitor, dbg);
            }
            catch (TeamRepositoryException e) {
                if (!dbg.isDebug()) break block2;
                e.printStackTrace();
            }
        }
        return result;
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IWorkItemHandle> result = new ArrayList<IWorkItemHandle>();
        IQueryService queryService = ((TeamRepository)repository).getQueryService();
        BaseWorkItemQueryModel.WorkItemQueryModel queryModel = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        IPredicate active = queryModel.archived()._isFalse();
        query.filter(active);
        int options = 512;
        IItemQueryPage resultPage = queryService.queryItems(query, IQueryService.EMPTY_PARAMETERS, options);
        if (resultPage.getSize() > 0) {
            result.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)queryService.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize());
                result.addAll(resultPage.getItemHandles());
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(result)});
        }
        return result;
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IProcessAreaHandle processArea) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(repository, processArea, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(repository, processArea, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IProcessAreaHandle processArea, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(repository, processArea, null, dbg);
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IProcessAreaHandle processArea, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IWorkItemHandle> result = new ArrayList<IWorkItemHandle>();
        IQueryService queryService = ((TeamRepository)repository).getQueryService();
        BaseWorkItemQueryModel.WorkItemQueryModel queryModel = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        IPredicate active = queryModel.archived()._isFalse();
        IPredicate filter = queryModel.category().defaultTeamArea()._eq((IItemHandle)processArea);
        query.filter(filter._and(active));
        int options = 512;
        IItemQueryPage resultPage = queryService.queryItems(query, IQueryService.EMPTY_PARAMETERS, options);
        if (resultPage.getSize() > 0) {
            result.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)queryService.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize());
                result.addAll(resultPage.getItemHandles());
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(result)});
        }
        return result;
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IProjectAreaHandle projectArea) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(repository, projectArea, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(repository, projectArea, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IProjectAreaHandle projectArea, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(repository, projectArea, null, dbg);
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IProjectAreaHandle projectArea, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IWorkItemHandle> result = new ArrayList<IWorkItemHandle>();
        IQueryService queryService = ((TeamRepository)repository).getQueryService();
        BaseWorkItemQueryModel.WorkItemQueryModel queryModel = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        IPredicate active = queryModel.archived()._isFalse();
        IPredicate filter = queryModel.projectArea()._eq((IItemHandle)projectArea);
        query.filter(filter._and(active));
        int options = 512;
        IItemQueryPage resultPage = queryService.queryItems(query, IQueryService.EMPTY_PARAMETERS, options);
        if (resultPage.getSize() > 0) {
            result.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)queryService.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize());
                result.addAll(resultPage.getItemHandles());
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(result)});
        }
        return result;
    }

    public static List<IWorkItemHandle> getWorkItemHandles(List<?> workItemList) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(workItemList, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(List<?> workItemList, IDebugger dbg) throws TeamRepositoryException {
        List<IWorkItemHandle> result = new ArrayList<IWorkItemHandle>();
        if (workItemList != null && workItemList.size() > 0) {
            if (workItemList.get(0) instanceof String) {
                result = CCMWorkItem.getWorkItemHandlesFromUuids(workItemList, dbg);
            } else if (workItemList.get(0) instanceof IWorkItem) {
                result = CCMWorkItem.getWorkItemHandlesFromItems(workItemList, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(result.size())});
        }
        return result;
    }

    private static List<IWorkItemHandle> getWorkItemHandlesFromUuids(List<String> workItemList, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkItemHandle> workItemHandleList = new ArrayList<IWorkItemHandle>();
        for (String workItemUuid : workItemList) {
            workItemHandleList.add((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemUuid), null));
        }
        return workItemHandleList;
    }

    private static List<IWorkItemHandle> getWorkItemHandlesFromItems(List<IWorkItem> workItemList, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkItemHandle> workItemHandleList = new ArrayList<IWorkItemHandle>();
        for (IWorkItem workItem : workItemList) {
            if (workItem != null) {
                workItemHandleList.add((IWorkItemHandle)workItem.getItemHandle());
                continue;
            }
            workItemHandleList.add(null);
        }
        return workItemHandleList;
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, List<?> workItemList) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(repository, workItemList, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, List<?> workItemList, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(repository, workItemList, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, List<?> workItemList, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(repository, workItemList, null, dbg);
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, List<?> workItemList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IWorkItemHandle> result = new ArrayList<IWorkItemHandle>();
        if (workItemList != null && workItemList.size() > 0) {
            if (workItemList.get(0) instanceof Integer) {
                result = CCMWorkItem.getWorkItemHandlesFromIds(repository, workItemList, monitor, dbg);
            } else if (workItemList.get(0) instanceof String) {
                result = Verification.isUUID((String)((String)((Object)workItemList.get(0)))) ? CCMWorkItem.getWorkItemHandlesFromUuids(repository, workItemList, monitor, dbg) : CCMWorkItem.getWorkItemHandlesFromStringIds(repository, workItemList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(result.size())});
        }
        return result;
    }

    private static List<IWorkItemHandle> getWorkItemHandlesFromIds(ITeamRepository repository, List<Integer> workItemList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkItemClient client = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        List result = client.findWorkItemsById(workItemList, monitor);
        return result;
    }

    private static List<IWorkItemHandle> getWorkItemHandlesFromStringIds(ITeamRepository repository, List<String> workItemList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (String workItem : workItemList) {
            integerList.add(Integer.valueOf(workItem));
        }
        return CCMWorkItem.getWorkItemHandlesFromIds(repository, integerList, monitor, dbg);
    }

    private static List<IWorkItemHandle> getWorkItemHandlesFromUuids(ITeamRepository repository, List<String> workItemList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IWorkItemHandle> result = new ArrayList<IWorkItemHandle>();
        for (String uuid : workItemList) {
            result.add((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
        }
        return result;
    }

    public static List<IWorkItemHandle> getWorkItemHandles(IWorkItemClient workItemClient, List<Integer> workItemIds) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(workItemClient, workItemIds, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(IWorkItemClient workItemClient, List<Integer> workItemIds, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(workItemClient, workItemIds, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(IWorkItemClient workItemClient, List<Integer> workItemIds, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemHandles(workItemClient, workItemIds, null, dbg);
    }

    public static List<IWorkItemHandle> getWorkItemHandles(IWorkItemClient workItemClient, List<Integer> workItemIds, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List workItemHandleList = workItemClient.findWorkItemsById(workItemIds, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workItemHandleList.size())});
        }
        return workItemHandleList;
    }

    public static String getWorkItemId(ITeamRepository repository, IWorkItemHandle workItemHandle) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemId(repository, workItemHandle, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static String getWorkItemId(ITeamRepository repository, IWorkItemHandle workItemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemId(repository, workItemHandle, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static String getWorkItemId(ITeamRepository repository, IWorkItemHandle workItemHandle, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemId(repository, workItemHandle, null, dbg);
    }

    public static String getWorkItemId(ITeamRepository repository, IWorkItemHandle workItemHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        String result = null;
        IWorkItem workItem = (IWorkItem)repository.itemManager().fetchPartialItem((IItemHandle)workItemHandle, 0, Arrays.asList(IWorkspace.ITEM_ID_PROPERTY), monitor);
        if (workItem != null) {
            result = Integer.toString(workItem.getId());
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((String)result)});
        }
        return result;
    }

    public static String getWorkItemIdNumber(ITeamRepository repository, IWorkItemHandle workItemHandle) {
        return CCMWorkItem.getWorkItemIdNumber(repository, workItemHandle, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static String getWorkItemIdNumber(ITeamRepository repository, IWorkItemHandle workItemHandle, IProgressMonitor monitor) {
        return CCMWorkItem.getWorkItemIdNumber(repository, workItemHandle, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static String getWorkItemIdNumber(ITeamRepository repository, IWorkItemHandle workItemHandle, IDebugger dbg) {
        return CCMWorkItem.getWorkItemIdNumber(repository, workItemHandle, null, dbg);
    }

    public static String getWorkItemIdNumber(ITeamRepository repository, IWorkItemHandle workItemHandle, IProgressMonitor monitor, IDebugger dbg) {
        String result;
        block4: {
            result = null;
            try {
                IWorkItem workItem = (IWorkItem)repository.itemManager().fetchPartialItem((IItemHandle)workItemHandle, 0, Arrays.asList(IWorkspace.ITEM_ID_PROPERTY), monitor);
                if (workItem != null) {
                    result = Integer.toString(workItem.getId());
                }
            }
            catch (TeamRepositoryException e) {
                if (!dbg.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((String)result)});
        }
        return result;
    }

    public static List<String> getWorkItemIds(ITeamRepository repository, List<IWorkItemHandle> workItemHandles) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemIds(repository, workItemHandles, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<String> getWorkItemIds(ITeamRepository repository, List<IWorkItemHandle> workItemHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemIds(repository, workItemHandles, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<String> getWorkItemIds(ITeamRepository repository, List<IWorkItemHandle> workItemHandles, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemIds(repository, workItemHandles, null, dbg);
    }

    public static List<String> getWorkItemIds(ITeamRepository repository, List<IWorkItemHandle> workItemHandles, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        List workItems = repository.itemManager().fetchPartialItems(workItemHandles, 0, Arrays.asList(IWorkspace.ITEM_ID_PROPERTY), monitor);
        for (IWorkItem workItem : workItems) {
            if (workItem != null) {
                result.add(Integer.toString(workItem.getId()));
                continue;
            }
            result.add(null);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(result.size())});
        }
        return result;
    }

    public static List<IWorkItemType> getWorkItemTypes(IWorkItemClient workItemClient, IProjectAreaHandle projectArea) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemTypes(workItemClient, projectArea, null, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemType> getWorkItemTypes(IWorkItemClient workItemClient, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemTypes(workItemClient, projectArea, monitor, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static List<IWorkItemType> getWorkItemTypes(IWorkItemClient workItemClient, IProjectAreaHandle projectArea, IDebugger dbg) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemTypes(workItemClient, projectArea, null, dbg);
    }

    public static List<IWorkItemType> getWorkItemTypes(IWorkItemClient workItemClient, IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List workItemTypeList = workItemClient.findWorkItemTypes(projectAreaHandle, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workItemTypeList.size())});
        }
        return workItemTypeList;
    }

    public static String getWorkItemUriPrefix(ITeamRepository repository) throws TeamRepositoryException {
        return CCMWorkItem.getWorkItemUriPrefix(repository, (IDebugger)new Debugger(CCMWorkItem.class));
    }

    public static String getWorkItemUriPrefix(ITeamRepository repository, IDebugger dbg) throws TeamRepositoryException {
        String workitemURIPrefix = String.valueOf(repository.getRepositoryURI()) + "resource/itemName/com.ibm.team.workitem.WorkItem/";
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((String)workitemURIPrefix)});
        }
        return workitemURIPrefix;
    }
}

