/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.client.debug.ClientLogString;
import com.ibm.team.build.extensions.client.util.CCMProcessArea;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CCMTeamRepository {
    private static final String className = CCMTeamRepository.class.getSimpleName();

    public static IProjectAreaHandle getProjectAreaHandle(String projectAreaName) throws TeamRepositoryException {
        return CCMTeamRepository.getProjectAreaHandle(projectAreaName, null, (IDebugger)new Debugger(CCMTeamRepository.class));
    }

    public static IProjectAreaHandle getProjectAreaHandle(String projectAreaName, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMTeamRepository.getProjectAreaHandle(projectAreaName, monitor, (IDebugger)new Debugger(CCMTeamRepository.class));
    }

    public static IProjectAreaHandle getProjectAreaHandle(String projectAreaName, IDebugger dbg) throws TeamRepositoryException {
        return CCMTeamRepository.getProjectAreaHandle(projectAreaName, null, dbg);
    }

    public static IProjectAreaHandle getProjectAreaHandle(String projectAreaName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ITeamRepository[] repositories;
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IProjectAreaHandle projectAreaHandle = null;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        block0: while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            List<IProjectArea> projectAreas = CCMProcessArea.getProjectAreas(repository, monitor, dbg);
            for (IProjectArea projectArea : projectAreas) {
                if (!projectArea.getName().equals(projectAreaName)) continue;
                projectAreaHandle = (IProjectAreaHandle)projectArea.getItemHandle();
                break block0;
            }
            ++n2;
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(projectAreaHandle)});
        }
        return projectAreaHandle;
    }

    public static ITeamRepository getRepository(String projectAreaName) throws TeamRepositoryException {
        return CCMTeamRepository.getRepository(projectAreaName, null, (IDebugger)new Debugger(CCMTeamRepository.class));
    }

    public static ITeamRepository getRepository(String projectAreaName, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMTeamRepository.getRepository(projectAreaName, monitor, (IDebugger)new Debugger(CCMTeamRepository.class));
    }

    public static ITeamRepository getRepository(String projectAreaName, IDebugger dbg) throws TeamRepositoryException {
        return CCMTeamRepository.getRepository(projectAreaName, null, dbg);
    }

    public static ITeamRepository getRepository(String projectAreaName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ITeamRepository[] repositories;
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ITeamRepository teamRepository = null;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        block0: while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            List<IProjectArea> projectAreas = CCMProcessArea.getProjectAreas(repository, monitor, dbg);
            for (IProjectArea projectArea : projectAreas) {
                if (!projectArea.getName().equals(projectAreaName)) continue;
                teamRepository = repository;
                break block0;
            }
            ++n2;
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), ClientLogString.valueOf(teamRepository)});
        }
        return teamRepository;
    }

    public static List<ITeamRepository> getRepositoryList() {
        return CCMTeamRepository.getRepositoryList((IDebugger)new Debugger(CCMTeamRepository.class));
    }

    public static List<ITeamRepository> getRepositoryList(IDebugger dbg) {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        ArrayList<ITeamRepository> teamRepositoryList = new ArrayList<ITeamRepository>(Arrays.asList(repositories));
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(teamRepositoryList.size())});
        }
        return teamRepositoryList;
    }
}

