/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.extensions.common.IGetProcessArea;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.internal.common.query.BaseProcessAreaQueryModel;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class CCMProcessArea {
    private static final String className = CCMProcessArea.class.getSimpleName();

    public static IProcessArea getProcessArea(ITeamRepository repository, URI processAreaUri) throws TeamRepositoryException {
        return CCMProcessArea.getProcessArea(repository, processAreaUri, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, URI processAreaUri, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProcessArea(repository, processAreaUri, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, URI processAreaUri, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessArea(repository, processAreaUri, null, dbg);
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, URI processAreaUri, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IProcessClientService processClient = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
        IProcessArea processArea = processClient.findProcessArea(processAreaUri, IProcessItemService.ALL_PROPERTIES, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)processArea)});
        }
        return processArea;
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, String processArea) throws TeamRepositoryException {
        return CCMProcessArea.getProcessArea(repository, processArea, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, String processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProcessArea(repository, processArea, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, String processArea, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessArea(repository, processArea, null, dbg);
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, String processArea, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (Verification.isUUID((String)processArea)) {
            return CCMProcessArea.getProcessArea(repository, (IProcessAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)processArea), null), monitor, dbg);
        }
        return CCMProcessArea.getProcessArea(repository, URI.create(processArea.replaceAll(" ", "%20").replaceAll("\\[", "%5B").replaceAll("]", "%5D")), monitor, dbg);
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, IProcessAreaHandle processAreaHandle) throws TeamRepositoryException {
        return CCMProcessArea.getProcessArea(repository, processAreaHandle, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, IProcessAreaHandle processAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProcessArea(repository, processAreaHandle, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, IProcessAreaHandle processAreaHandle, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessArea(repository, processAreaHandle, null, dbg);
    }

    public static IProcessArea getProcessArea(ITeamRepository repository, IProcessAreaHandle processAreaHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)processArea)});
        }
        return processArea;
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreas(repository, false, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreas(repository, false, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreas(repository, false, null, dbg);
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreas(repository, false, monitor, dbg);
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, boolean archived) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreas(repository, archived, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, boolean archived, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreas(repository, archived, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, boolean archived, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreas(repository, archived, null, dbg);
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, boolean archived, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        int options;
        IItemQueryPage resultPage;
        ArrayList handles = new ArrayList();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        BaseProcessAreaQueryModel.ProcessAreaQueryModel queryModel = BaseProcessAreaQueryModel.ProcessAreaQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        if (!archived) {
            IPredicate notArchived = queryModel.archived()._isFalse();
            query.filter(notArchived);
        }
        if ((resultPage = buildClient.queryItems(query, IQueryService.EMPTY_PARAMETERS, options = 512, monitor)).getSize() > 0) {
            handles.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                handles.addAll(resultPage.getItemHandles());
            }
        }
        List<IProcessArea> result = CCMProcessArea.getProcessAreas(repository, handles, monitor, dbg);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(result)});
        }
        return result;
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, List<?> areaList) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreas(repository, areaList, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, List<?> areaList, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreas(repository, areaList, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, List<?> areaList, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreas(repository, areaList, null, dbg);
    }

    public static List<IProcessArea> getProcessAreas(ITeamRepository repository, List<?> areaList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IProcessArea> processAreaList = new ArrayList<IProcessArea>();
        if (areaList != null && areaList.size() > 0) {
            if (areaList.get(0) instanceof String) {
                processAreaList = Verification.isUUID((String)((String)areaList.get(0))) ? CCMProcessArea.getProcessAreasFromUuids(repository, areaList, monitor, dbg) : CCMProcessArea.getProcessAreasFromNames(repository, areaList, monitor, dbg);
            } else if (areaList.get(0) instanceof IProcessAreaHandle) {
                processAreaList = CCMProcessArea.getProcessAreasFromHandles(repository, areaList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(processAreaList.size())});
        }
        return processAreaList;
    }

    private static List<IProcessArea> getProcessAreasFromHandles(ITeamRepository repository, List<IProcessAreaHandle> processAreaList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List result = repository.itemManager().fetchCompleteItems(processAreaList, 0, monitor);
        return result;
    }

    private static List<IProcessArea> getProcessAreasFromNames(ITeamRepository repository, List<String> processAreaList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IProcessArea> result = new ArrayList<IProcessArea>();
        for (String processAreaName : processAreaList) {
            result.add(CCMProcessArea.getProcessArea(repository, URI.create(processAreaName.replaceAll(" ", "%20").replaceAll("\\[", "%5B").replaceAll("]", "%5D")), monitor, dbg));
        }
        return result;
    }

    private static List<IProcessArea> getProcessAreasFromUuids(ITeamRepository repository, List<String> processAreaList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IProcessArea> result = new ArrayList<IProcessArea>();
        ArrayList<IProcessAreaHandle> handleList = new ArrayList<IProcessAreaHandle>();
        for (String uuid : processAreaList) {
            handleList.add((IProcessAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
        }
        result.addAll(repository.itemManager().fetchCompleteItems(handleList, 0, monitor));
        return result;
    }

    public static String getProcessAreaPath(ITeamRepository repository, IProcessArea processArea, IProjectArea projectArea) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaPath(repository, processArea, projectArea, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static String getProcessAreaPath(ITeamRepository repository, IProcessArea processArea, IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaPath(repository, processArea, projectArea, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static String getProcessAreaPath(ITeamRepository repository, IProcessArea processArea, IProjectArea projectArea, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaPath(repository, processArea, projectArea, null, dbg);
    }

    public static final String getProcessAreaPath(ITeamRepository repository, IProcessArea processArea, IProjectArea projectArea, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        StringBuilder sb = new StringBuilder();
        String result = null;
        if (processArea instanceof ITeamAreaHandle) {
            sb.insert(0, processArea.getName());
            sb.insert(0, "/");
            ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchySnapshot();
            ITeamAreaHandle parent = (ITeamAreaHandle)processArea;
            do {
                if ((parent = hierarchy.getParent(parent)) == null) continue;
                IProcessArea team = CCMProcessArea.getProcessArea(repository, (IProcessAreaHandle)parent, monitor, dbg);
                sb.insert(0, team.getName());
                sb.insert(0, "/");
            } while (parent != null);
        }
        sb.insert(0, projectArea.getName());
        result = sb.toString();
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.value((Object)result)});
        }
        return result;
    }

    public static final String getProcessAreaPath(ITeamRepository repository, IProcessArea processArea, IProjectArea projectArea, IGetProcessArea getter) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaPath(repository, processArea, projectArea, getter, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static final String getProcessAreaPath(ITeamRepository repository, IProcessArea processArea, IProjectArea projectArea, IGetProcessArea getter, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaPath(repository, processArea, projectArea, getter, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static final String getProcessAreaPath(ITeamRepository repository, IProcessArea processArea, IProjectArea projectArea, IGetProcessArea getter, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaPath(repository, processArea, projectArea, getter, null, dbg);
    }

    public static final String getProcessAreaPath(ITeamRepository repository, IProcessArea processArea, IProjectArea projectArea, IGetProcessArea getter, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchySnapshot();
        ITeamAreaHandle parent = (ITeamAreaHandle)processArea;
        StringBuilder sb = new StringBuilder();
        String result = null;
        sb.insert(0, processArea.getName());
        sb.insert(0, "/");
        do {
            if ((parent = hierarchy.getParent(parent)) == null) continue;
            IProcessArea team = getter.execute((IProcessAreaHandle)parent);
            sb.insert(0, team.getName());
            sb.insert(0, "/");
        } while (parent != null);
        sb.insert(0, projectArea.getName());
        result = sb.toString();
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.value((Object)result)});
        }
        return result;
    }

    public static IProcessAreaHandle getProcessAreaHandle(ITeamRepository repository, URI processAreaUri) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaHandle(repository, processAreaUri, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProcessAreaHandle getProcessAreaHandle(ITeamRepository repository, URI processAreaUri, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaHandle(repository, processAreaUri, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProcessAreaHandle getProcessAreaHandle(ITeamRepository repository, URI processAreaUri, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaHandle(repository, processAreaUri, null, dbg);
    }

    public static IProcessAreaHandle getProcessAreaHandle(ITeamRepository repository, URI processAreaUri, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IProcessClientService processClient = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
        IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)processClient.findProcessArea(processAreaUri, IProcessItemService.ALL_PROPERTIES, monitor).getItemHandle();
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)processAreaHandle)});
        }
        return processAreaHandle;
    }

    public static IProcessAreaHandle getProcessAreaHandle(ITeamRepository repository, String processAreaName) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaHandle(repository, processAreaName, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProcessAreaHandle getProcessAreaHandle(ITeamRepository repository, String processAreaName, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaHandle(repository, processAreaName, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProcessAreaHandle getProcessAreaHandle(ITeamRepository repository, String processAreaName, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaHandle(repository, processAreaName, null, dbg);
    }

    public static IProcessAreaHandle getProcessAreaHandle(ITeamRepository repository, String processAreaName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProcessAreaHandle(repository, URI.create(processAreaName.replaceAll(" ", "%20").replaceAll("\\[", "%5B").replaceAll("]", "%5D")), monitor, dbg);
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, IProjectAreaHandle projectAreaHandle) throws TeamRepositoryException {
        return CCMProcessArea.getProjectArea(repository, projectAreaHandle, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProjectArea(repository, projectAreaHandle, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, IProjectAreaHandle projectAreaHandle, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProjectArea(repository, projectAreaHandle, null, dbg);
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IProjectArea projectArea = (IProjectArea)repository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)projectArea)});
        }
        return projectArea;
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, URI projectAreaUri) throws TeamRepositoryException {
        return CCMProcessArea.getProjectArea(repository, projectAreaUri, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, URI projectAreaUri, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProjectArea(repository, projectAreaUri, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, URI projectAreaUri, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProjectArea(repository, projectAreaUri, null, dbg);
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, URI projectAreaUri, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IProcessClientService processClient = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
        IProjectArea projectArea = (IProjectArea)processClient.findProcessArea(projectAreaUri, IProcessItemService.ALL_PROPERTIES, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)projectArea)});
        }
        return projectArea;
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, String projectArea) throws TeamRepositoryException {
        return CCMProcessArea.getProjectArea(repository, projectArea, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, String projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProjectArea(repository, projectArea, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, String projectArea, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProjectArea(repository, projectArea, null, dbg);
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, String projectArea, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (Verification.isUUID((String)projectArea)) {
            return CCMProcessArea.getProjectArea(repository, (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)projectArea), null), monitor, dbg);
        }
        return CCMProcessArea.getProjectArea(repository, URI.create(projectArea.replaceAll(" ", "%20").replaceAll("\\[", "%5B").replaceAll("]", "%5D")), monitor, dbg);
    }

    public static List<IProjectArea> getProjectAreas(ITeamRepository repository) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreas(repository, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static List<IProjectArea> getProjectAreas(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreas(repository, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static List<IProjectArea> getProjectAreas(ITeamRepository repository, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreas(repository, null, dbg);
    }

    public static List<IProjectArea> getProjectAreas(ITeamRepository repository, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List projectAreaList = repository.itemManager().fetchCompleteItems(repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(projectAreaList.size())});
        }
        return projectAreaList;
    }

    public static Map<String, IProjectArea> getProjectAreaMap(ITeamRepository repository) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreaMap(repository, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static Map<String, IProjectArea> getProjectAreaMap(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreaMap(repository, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static Map<String, IProjectArea> getProjectAreaMap(ITeamRepository repository, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreaMap(repository, null, dbg);
    }

    public static Map<String, IProjectArea> getProjectAreaMap(ITeamRepository repository, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List projectAreas = repository.itemManager().fetchCompleteItems(repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, monitor);
        HashMap<String, IProjectArea> result = new HashMap<String, IProjectArea>(projectAreas.size());
        for (IProjectArea projectArea : projectAreas) {
            result.put(projectArea.getItemId().getUuidValue(), projectArea);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(result.size())});
        }
        return result;
    }

    public static List<IProjectArea> getProjectAreas(ITeamRepository repository, List<?> areaList) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreas(repository, areaList, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static List<IProjectArea> getProjectAreas(ITeamRepository repository, List<?> areaList, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreas(repository, areaList, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static List<IProjectArea> getProjectAreas(ITeamRepository repository, List<?> areaList, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreas(repository, areaList, null, dbg);
    }

    public static List<IProjectArea> getProjectAreas(ITeamRepository repository, List<?> areaList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IProjectArea> projectAreaList = new ArrayList<IProjectArea>();
        if (areaList != null && areaList.size() > 0) {
            if (areaList.get(0) instanceof String) {
                projectAreaList = Verification.isUUID((String)((String)areaList.get(0))) ? CCMProcessArea.getProjectAreasFromUuids(repository, areaList, monitor, dbg) : CCMProcessArea.getProjectAreasFromNames(repository, areaList, monitor, dbg);
            } else if (areaList.get(0) instanceof IProjectAreaHandle) {
                projectAreaList = CCMProcessArea.getProjectAreasFromHandles(repository, areaList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(projectAreaList.size())});
        }
        return projectAreaList;
    }

    private static List<IProjectArea> getProjectAreasFromHandles(ITeamRepository repository, List<IProjectAreaHandle> projectAreaList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List result = repository.itemManager().fetchCompleteItems(projectAreaList, 0, monitor);
        return result;
    }

    private static List<IProjectArea> getProjectAreasFromNames(ITeamRepository repository, List<String> projectAreaList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IProjectArea> result = new ArrayList<IProjectArea>();
        for (String projectAreaName : projectAreaList) {
            result.add(CCMProcessArea.getProjectArea(repository, URI.create(projectAreaName.replaceAll(" ", "%20").replaceAll("\\[", "%5B").replaceAll("]", "%5D")), monitor, dbg));
        }
        return result;
    }

    private static List<IProjectArea> getProjectAreasFromUuids(ITeamRepository repository, List<String> projectAreaList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IProjectArea> result = new ArrayList<IProjectArea>();
        ArrayList<IProjectAreaHandle> handleList = new ArrayList<IProjectAreaHandle>();
        for (String uuid : projectAreaList) {
            handleList.add((IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
        }
        result.addAll(repository.itemManager().fetchCompleteItems(projectAreaList, 0, monitor));
        return result;
    }

    public static IProjectAreaHandle getProjectAreaHandle(ITeamRepository repository, URI projectAreaUri) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreaHandle(repository, projectAreaUri, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProjectAreaHandle getProjectAreaHandle(ITeamRepository repository, URI projectAreaUri, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreaHandle(repository, projectAreaUri, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProjectAreaHandle getProjectAreaHandle(ITeamRepository repository, URI projectAreaUri, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreaHandle(repository, projectAreaUri, null, dbg);
    }

    public static IProjectAreaHandle getProjectAreaHandle(ITeamRepository repository, URI projectAreaUri, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IProcessClientService processClient = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)processClient.findProcessArea(projectAreaUri, IProcessItemService.ALL_PROPERTIES, monitor).getItemHandle();
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)projectAreaHandle)});
        }
        return projectAreaHandle;
    }

    public static IProjectAreaHandle getProjectAreaHandle(ITeamRepository repository, String projectAreaName) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreaHandle(repository, projectAreaName, null, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProjectAreaHandle getProjectAreaHandle(ITeamRepository repository, String projectAreaName, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreaHandle(repository, projectAreaName, monitor, (IDebugger)new Debugger(CCMProcessArea.class));
    }

    public static IProjectAreaHandle getProjectAreaHandle(ITeamRepository repository, String projectAreaName, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreaHandle(repository, projectAreaName, null, dbg);
    }

    public static IProjectAreaHandle getProjectAreaHandle(ITeamRepository repository, String projectAreaName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return CCMProcessArea.getProjectAreaHandle(repository, URI.create(projectAreaName.replaceAll(" ", "%20").replaceAll("\\[", "%5B").replaceAll("]", "%5D")), monitor, dbg);
    }
}

