/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CCMIteration {
    private static final String className = CCMIteration.class.getSimpleName();

    public static IIterationHandle getIterationHandle(ITeamRepository repository, IProjectArea projectArea, String iterationName) throws TeamRepositoryException {
        return CCMIteration.getIterationHandle(repository, projectArea, iterationName, null, (IDebugger)new Debugger(CCMIteration.class));
    }

    public static IIterationHandle getIterationHandle(ITeamRepository repository, IProjectArea projectArea, String iterationName, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMIteration.getIterationHandle(repository, projectArea, iterationName, monitor, (IDebugger)new Debugger(CCMIteration.class));
    }

    public static IIterationHandle getIterationHandle(ITeamRepository repository, IProjectArea projectArea, String iterationName, IDebugger dbg) throws TeamRepositoryException {
        return CCMIteration.getIterationHandle(repository, projectArea, iterationName, null, dbg);
    }

    public static IIterationHandle getIterationHandle(ITeamRepository repository, IProjectArea projectArea, String iterationName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IIterationHandle result = null;
        IDevelopmentLineHandle[] developmentLineHandles = projectArea.getDevelopmentLines();
        List developmentLineList = repository.itemManager().fetchCompleteItems(Arrays.asList(developmentLineHandles), 0, monitor);
        block0: for (IDevelopmentLine developmentLine : developmentLineList) {
            IIterationHandle[] iterationHandles = developmentLine.getIterations();
            List iterationList = repository.itemManager().fetchCompleteItems(Arrays.asList(iterationHandles), 0, monitor);
            LinkedList iterationQueue = new LinkedList();
            iterationQueue.addAll(iterationList);
            while (!iterationQueue.isEmpty()) {
                IIteration iteration = (IIteration)iterationQueue.remove();
                if (iteration.isArchived()) continue;
                if (iteration.getName() != null && iteration.getName().equals(iterationName)) {
                    result = (IIterationHandle)iteration.getItemHandle();
                    break block0;
                }
                if (iteration.getChildren() == null) continue;
                List iterationChildren = repository.itemManager().fetchCompleteItems(Arrays.asList(iteration.getChildren()), 0, monitor);
                iterationQueue.addAll(iterationChildren);
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(result)});
        }
        return result;
    }
}

