/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CCMChangeSetItems {
    private static final String className = CCMChangeSetItems.class.getSimpleName();

    public static List<IWorkItem> getWorkItems(ITeamRepository repository, IWorkspaceManager workspaceManager, IChangeSetHandle changeSetHandle) throws TeamRepositoryException {
        return CCMChangeSetItems.getWorkItems(repository, workspaceManager, changeSetHandle, null, (IDebugger)new Debugger(CCMChangeSetItems.class));
    }

    public static List<IWorkItem> getWorkItems(ITeamRepository repository, IWorkspaceManager workspaceManager, IChangeSetHandle changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return CCMChangeSetItems.getWorkItems(repository, workspaceManager, changeSetHandle, monitor, (IDebugger)new Debugger(CCMChangeSetItems.class));
    }

    public static List<IWorkItem> getWorkItems(ITeamRepository repository, IWorkspaceManager workspaceManager, IChangeSetHandle changeSetHandle, IDebugger dbg) throws TeamRepositoryException {
        return CCMChangeSetItems.getWorkItems(repository, workspaceManager, changeSetHandle, null, dbg);
    }

    public static List<IWorkItem> getWorkItems(ITeamRepository repository, IWorkspaceManager workspaceManager, IChangeSetHandle changeSetHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IWorkItemHandle> workItemHandleList = new ArrayList<IWorkItemHandle>();
        List<Object> workItemList = new ArrayList<IWorkItem>();
        List linkSummary = workspaceManager.getChangeSetLinkSummary(Arrays.asList(changeSetHandle), monitor);
        for (IChangeSetLinkSummary link : linkSummary) {
            List linksHandles = link.getLinks();
            List linkItems = repository.itemManager().fetchCompleteItems(linksHandles, 0, monitor);
            for (ILink linkItem : linkItems) {
                IReference targetRef = linkItem.getTargetRef();
                if (!targetRef.isItemReference() || !(((IItemReference)targetRef).getReferencedItem() instanceof IWorkItemHandle)) continue;
                IWorkItemHandle workItemHandle = (IWorkItemHandle)((IItemReference)targetRef).getReferencedItem();
                workItemHandleList.add(workItemHandle);
            }
        }
        if (workItemHandleList.size() > 0) {
            workItemList = repository.itemManager().fetchCompleteItems(workItemHandleList, 0, monitor);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workItemList.size())});
        }
        return workItemList;
    }
}

