/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.extensions.client.util.BuildDefinition;
import com.ibm.team.build.extensions.client.util.BuildResult;
import com.ibm.team.build.extensions.client.util.CCMItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.internal.client.workitem.WorkItemHelper;
import com.ibm.team.build.internal.common.helper.ItemHelper;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.ILinkFactory;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.internal.links.LinksPackage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IHelperType;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildWorkItems {
    private static final String className = BuildWorkItems.class.getSimpleName();

    public static IReference getBuildResultReference(ITeamRepository repository, IBuildResultHandle resultHandle) throws TeamRepositoryException {
        return BuildWorkItems.getBuildResultReference(repository, resultHandle, null, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static IReference getBuildResultReference(ITeamRepository repository, IBuildResultHandle resultHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildWorkItems.getBuildResultReference(repository, resultHandle, monitor, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static IReference getBuildResultReference(ITeamRepository repository, IBuildResultHandle resultHandle, IDebugger dbg) throws TeamRepositoryException {
        return BuildWorkItems.getBuildResultReference(repository, resultHandle, null, dbg);
    }

    public static IReference getBuildResultReference(ITeamRepository repository, IBuildResultHandle resultHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildResult buildResult = BuildResult.getBuildResult(repository, resultHandle, monitor, dbg);
        IBuildDefinition buildDefinition = BuildDefinition.getBuildDefinition(repository, buildResult, monitor, dbg);
        IHelperType helperType = IHelperType.IRegistry.INSTANCE.getHelperType(LinksPackage.eINSTANCE.getReference().getName(), "com.ibm.team.links");
        String buildComment = ItemHelper.validateStringAttributeLength((String)(String.valueOf(buildDefinition.getId()) + " " + buildResult.getLabel()), (IType)helperType, (String)LinksPackage.eINSTANCE.getReference_Comment().getName());
        IItemReference reference = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)buildResult, buildComment);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object)reference)});
        }
        return reference;
    }

    public static IReference getBuildResultReference(ITeamRepository repository, IBuildResult buildResult) throws TeamRepositoryException {
        return BuildWorkItems.getBuildResultReference(repository, buildResult, null, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static IReference getBuildResultReference(ITeamRepository repository, IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildWorkItems.getBuildResultReference(repository, buildResult, monitor, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static IReference getBuildResultReference(ITeamRepository repository, IBuildResult buildResult, IDebugger dbg) throws TeamRepositoryException {
        return BuildWorkItems.getBuildResultReference(repository, buildResult, null, dbg);
    }

    public static IReference getBuildResultReference(ITeamRepository repository, IBuildResult buildResult, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildDefinition buildDefinition = BuildDefinition.getBuildDefinition(repository, buildResult, monitor, dbg);
        IHelperType helperType = IHelperType.IRegistry.INSTANCE.getHelperType(LinksPackage.eINSTANCE.getReference().getName(), "com.ibm.team.links");
        String buildComment = ItemHelper.validateStringAttributeLength((String)(String.valueOf(buildDefinition.getId()) + " " + buildResult.getLabel()), (IType)helperType, (String)LinksPackage.eINSTANCE.getReference_Comment().getName());
        IItemReference reference = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)buildResult, buildComment);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object)reference)});
        }
        return reference;
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ILinkManager linkManager, IBuildResult buildResult) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandles(linkManager, buildResult, null, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ILinkManager linkManager, IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandles(linkManager, buildResult, monitor, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ILinkManager linkManager, IBuildResult buildResult, IDebugger dbg) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandles(linkManager, buildResult, null, dbg);
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ILinkManager linkManager, IBuildResult buildResult, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IWorkItemHandle> workItemHandleList = new ArrayList<IWorkItemHandle>();
        ILinkQueryPage linkQueryPage = linkManager.findLinksByTarget("com.ibm.team.build.linktype.includedWorkItems", (IReference)IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)buildResult), monitor);
        ILinkCollection linkCollection = linkQueryPage.getAllLinksFromHereOn();
        for (ILink link : linkCollection) {
            IReference reference = link.getSourceRef();
            if (!reference.isItemReference() || ((IItemReference)reference).getReferencedItem() == null || !(((IItemReference)reference).getReferencedItem() instanceof IWorkItemHandle)) continue;
            IWorkItemHandle workItemHandle = (IWorkItemHandle)((IItemReference)reference).getReferencedItem();
            workItemHandleList.add(workItemHandle);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workItemHandleList.size())});
        }
        return workItemHandleList;
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IBuildResult buildResult) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandles(repository, buildResult, null, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandles(repository, buildResult, monitor, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IBuildResult buildResult, IDebugger dbg) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandles(repository, buildResult, null, dbg);
    }

    public static List<IWorkItemHandle> getWorkItemHandles(ITeamRepository repository, IBuildResult buildResult, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IWorkItemHandle> workItemHandleList = new ArrayList<IWorkItemHandle>();
        ILinkManager linkManager = (ILinkManager)repository.getClientLibrary(ILinkManager.class);
        ILinkQueryPage linkQueryPage = linkManager.findLinksByTarget("com.ibm.team.build.linktype.includedWorkItems", (IReference)IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)buildResult), monitor);
        ILinkCollection linkCollection = linkQueryPage.getAllLinksFromHereOn();
        for (ILink link : linkCollection) {
            IReference reference = link.getSourceRef();
            if (!reference.isItemReference() || ((IItemReference)reference).getReferencedItem() == null || !(((IItemReference)reference).getReferencedItem() instanceof IWorkItemHandle)) continue;
            IWorkItemHandle workItemHandle = (IWorkItemHandle)((IItemReference)reference).getReferencedItem();
            workItemHandleList.add(workItemHandle);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workItemHandleList.size())});
        }
        return workItemHandleList;
    }

    public static Map<String, IWorkItemHandle> getWorkItemHandleMap(ILinkManager linkManager, IBuildResult buildResult) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandleMap(linkManager, buildResult, null, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static Map<String, IWorkItemHandle> getWorkItemHandleMap(ILinkManager linkManager, IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandleMap(linkManager, buildResult, monitor, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static Map<String, IWorkItemHandle> getWorkItemHandleMap(ILinkManager linkManager, IBuildResult buildResult, IDebugger dbg) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandleMap(linkManager, buildResult, null, dbg);
    }

    public static Map<String, IWorkItemHandle> getWorkItemHandleMap(ILinkManager linkManager, IBuildResult buildResult, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        HashMap<String, IWorkItemHandle> workItemHandleMap = new HashMap<String, IWorkItemHandle>();
        ILinkQueryPage linkQueryPage = linkManager.findLinksByTarget("com.ibm.team.build.linktype.includedWorkItems", (IReference)IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)buildResult), monitor);
        ILinkCollection linkCollection = linkQueryPage.getAllLinksFromHereOn();
        for (ILink link : linkCollection) {
            IReference reference = link.getSourceRef();
            if (!reference.isItemReference() || ((IItemReference)reference).getReferencedItem() == null) continue;
            IWorkItemHandle workItemHandle = (IWorkItemHandle)((IItemReference)reference).getReferencedItem();
            workItemHandleMap.put(workItemHandle.getItemId().getUuidValue(), workItemHandle);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workItemHandleMap.size())});
        }
        return workItemHandleMap;
    }

    public static Map<String, IWorkItemHandle> getWorkItemHandleMap(ITeamRepository repository, IBuildResult buildResult) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandleMap(repository, buildResult, null, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static Map<String, IWorkItemHandle> getWorkItemHandleMap(ITeamRepository repository, IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandleMap(repository, buildResult, monitor, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static Map<String, IWorkItemHandle> getWorkItemHandleMap(ITeamRepository repository, IBuildResult buildResult, IDebugger dbg) throws TeamRepositoryException {
        return BuildWorkItems.getWorkItemHandleMap(repository, buildResult, null, dbg);
    }

    public static Map<String, IWorkItemHandle> getWorkItemHandleMap(ITeamRepository repository, IBuildResult buildResult, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        HashMap<String, IWorkItemHandle> workItemHandleMap = new HashMap<String, IWorkItemHandle>();
        ILinkManager linkManager = (ILinkManager)repository.getClientLibrary(ILinkManager.class);
        ILinkQueryPage linkQueryPage = linkManager.findLinksByTarget("com.ibm.team.build.linktype.includedWorkItems", (IReference)IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)buildResult), monitor);
        ILinkCollection linkCollection = linkQueryPage.getAllLinksFromHereOn();
        for (ILink link : linkCollection) {
            IReference reference = link.getSourceRef();
            if (!reference.isItemReference() || ((IItemReference)reference).getReferencedItem() == null) continue;
            IWorkItemHandle workItemHandle = (IWorkItemHandle)((IItemReference)reference).getReferencedItem();
            workItemHandleMap.put(workItemHandle.getItemId().getUuidValue(), workItemHandle);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workItemHandleMap.size())});
        }
        return workItemHandleMap;
    }

    public static ILink linkWorkItem(IBuildDefinition buildDefinition, IBuildResult buildResult, IWorkItemHandle workItemHandle, IWorkItem workItem) throws TeamRepositoryException {
        return BuildWorkItems.linkWorkItem(buildDefinition, buildResult, workItemHandle, workItem, null, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static ILink linkWorkItem(IBuildDefinition buildDefinition, IBuildResult buildResult, IWorkItemHandle workItemHandle, IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildWorkItems.linkWorkItem(buildDefinition, buildResult, workItemHandle, workItem, monitor, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static ILink linkWorkItem(IBuildDefinition buildDefinition, IBuildResult buildResult, IWorkItemHandle workItemHandle, IWorkItem workItem, IDebugger dbg) throws TeamRepositoryException {
        return BuildWorkItems.linkWorkItem(buildDefinition, buildResult, workItemHandle, workItem, null, dbg);
    }

    public static ILink linkWorkItem(IBuildDefinition buildDefinition, IBuildResult buildResult, IWorkItemHandle workItemHandle, IWorkItem workItem, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IItemReference targetReference;
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IHelperType helperType = IHelperType.IRegistry.INSTANCE.getHelperType(LinksPackage.eINSTANCE.getReference().getName(), "com.ibm.team.links");
        String buildComment = ItemHelper.validateStringAttributeLength((String)(String.valueOf(buildDefinition.getId()) + " " + buildResult.getLabel()), (IType)helperType, (String)LinksPackage.eINSTANCE.getReference_Comment().getName());
        IItemReference sourceReference = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)buildResult, buildComment);
        if (workItem == null) {
            targetReference = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)workItemHandle);
        } else {
            String targetComment = ItemHelper.validateStringAttributeLength((String)WorkItemTextUtilities.getWorkItemText((IWorkItem)workItem), (IType)helperType, (String)LinksPackage.eINSTANCE.getReference_Comment().getName());
            targetReference = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)workItemHandle, targetComment);
        }
        ILink link = ILinkFactory.INSTANCE.createLink("com.ibm.team.build.linktype.includedWorkItems", (IReference)sourceReference, (IReference)targetReference);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)link)});
        }
        return link;
    }

    public static void setWorkItems(ITeamRepository repository, String buildResultUUID, Map<String, IWorkItem> workItemMap) throws TeamRepositoryException {
        BuildWorkItems.setWorkItems(repository, buildResultUUID, workItemMap, null, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static void setWorkItems(ITeamRepository repository, String buildResultUUID, Map<String, IWorkItem> workItemMap, IProgressMonitor monitor) throws TeamRepositoryException {
        BuildWorkItems.setWorkItems(repository, buildResultUUID, workItemMap, monitor, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static void setWorkItems(ITeamRepository repository, String buildResultUUID, Map<String, IWorkItem> workItemMap, IDebugger dbg) throws TeamRepositoryException {
        BuildWorkItems.setWorkItems(repository, buildResultUUID, workItemMap, null, dbg);
    }

    public static void setWorkItems(ITeamRepository repository, String buildResultUUID, Map<String, IWorkItem> workItemMap, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildResult buildResult = BuildResult.getPartialBuildResult(repository, buildResultUUID, monitor, dbg);
        IBuildDefinition buildDefinition = BuildDefinition.getBuildDefinition(repository, buildResult, monitor, dbg);
        ILinkManager linkManager = (ILinkManager)repository.getClientLibrary(ILinkManager.class);
        ArrayList<ILink> linkList = new ArrayList<ILink>();
        ArrayList<IWorkItemHandle> workItemHandleList = new ArrayList<IWorkItemHandle>();
        Map<String, IWorkItemHandle> workItemHandleMap = BuildWorkItems.getWorkItemHandleMap(linkManager, buildResult, monitor, dbg);
        for (String workItemId : workItemMap.keySet()) {
            IWorkItem workItem = workItemMap.get(workItemId);
            IWorkItemHandle workItemHandle = (IWorkItemHandle)workItem.getItemHandle();
            if (workItemHandleMap.containsKey(workItemHandle.getItemId().getUuidValue())) continue;
            linkList.add(BuildWorkItems.linkWorkItem(buildDefinition, buildResult, workItemHandle, workItem, monitor, dbg));
            workItemHandleList.add(workItemHandle);
        }
        linkManager.saveLinks(linkList, monitor);
        WorkItemHelper.setFixedInBuild((ITeamRepository)repository, (IBuildResultHandle)buildResult, (IWorkItemHandle[])workItemHandleList.toArray(new IWorkItemHandle[workItemHandleList.size()]));
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(linkList.size())});
        }
    }

    public static void setWorkItems(ITeamRepository repository, String buildResultUUID, List<IWorkItem> workItems) throws TeamRepositoryException {
        BuildWorkItems.setWorkItems(repository, buildResultUUID, workItems, null, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static void setWorkItems(ITeamRepository repository, String buildResultUUID, List<IWorkItem> workItems, IProgressMonitor monitor) throws TeamRepositoryException {
        BuildWorkItems.setWorkItems(repository, buildResultUUID, workItems, monitor, (IDebugger)new Debugger(BuildWorkItems.class));
    }

    public static void setWorkItems(ITeamRepository repository, String buildResultUUID, List<IWorkItem> workItems, IDebugger dbg) throws TeamRepositoryException {
        BuildWorkItems.setWorkItems(repository, buildResultUUID, workItems, null, dbg);
    }

    public static void setWorkItems(ITeamRepository repository, String buildResultUUID, List<IWorkItem> workItems, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildResult buildResult = BuildResult.getPartialBuildResult(repository, buildResultUUID, monitor, dbg);
        IBuildDefinition buildDefinition = BuildDefinition.getBuildDefinition(repository, buildResult, monitor, dbg);
        ILinkManager linkManager = (ILinkManager)repository.getClientLibrary(ILinkManager.class);
        ArrayList<ILink> linkList = new ArrayList<ILink>();
        List<IWorkItemHandle> workItemHandles = BuildWorkItems.getWorkItemHandles(linkManager, buildResult, monitor, dbg);
        ArrayList<IWorkItemHandle> workItemHandleList = new ArrayList<IWorkItemHandle>();
        for (IWorkItem workItem : workItems) {
            IWorkItemHandle workItemHandle = (IWorkItemHandle)workItem.getItemHandle();
            if (CCMItem.contains(workItemHandles, workItemHandle, dbg)) continue;
            linkList.add(BuildWorkItems.linkWorkItem(buildDefinition, buildResult, workItemHandle, workItem, monitor, dbg));
            workItemHandleList.add(workItemHandle);
        }
        linkManager.saveLinks(linkList, monitor);
        WorkItemHelper.setFixedInBuild((ITeamRepository)repository, (IBuildResultHandle)buildResult, (IWorkItemHandle[])workItemHandleList.toArray(new IWorkItemHandle[workItemHandleList.size()]));
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(linkList.size())});
        }
    }
}

