/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.extensions.client.nls.Messages;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.build.internal.common.model.query.BaseBuildResultQueryModel;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildResult {
    private static final String className = BuildResult.class.getSimpleName();

    public static IBuildResult getBuildResult(ITeamRepository repository, String resultString) throws TeamRepositoryException {
        return BuildResult.getBuildResult(repository, resultString, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBuildResult getBuildResult(ITeamRepository repository, String resultString, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getBuildResult(repository, resultString, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBuildResult getBuildResult(ITeamRepository repository, String resultString, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getBuildResult(repository, resultString, null, dbg);
    }

    public static IBuildResult getBuildResult(ITeamRepository repository, String resultString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildResult buildResult = null;
        if (Verification.isUUID((String)resultString)) {
            buildResult = (IBuildResult)repository.itemManager().fetchCompleteItem(IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)resultString), null), 0, monitor);
        } else {
            ITeamBuildClient client = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
            ArrayList handles = new ArrayList();
            BaseBuildResultQueryModel.BuildResultQueryModel buildResultQueryModel = BaseBuildResultQueryModel.BuildResultQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
            IPredicate filter = buildResultQueryModel.label()._eq(resultString);
            query.filter(filter);
            int options = 512;
            IItemQueryPage resultPage = client.queryItems(query, IQueryService.EMPTY_PARAMETERS, options, monitor);
            if (resultPage.getSize() > 0) {
                handles.addAll(resultPage.getItemHandles());
                while (resultPage.hasNext()) {
                    resultPage = (IItemQueryPage)client.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                    handles.addAll(resultPage.getItemHandles());
                }
            }
            if (handles.size() == 1) {
                buildResult = (IBuildResult)repository.itemManager().fetchCompleteItem((IItemHandle)handles.get(0), 0, monitor);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildResult)});
        }
        return buildResult;
    }

    public static IBuildResult getBuildResult(ITeamRepository repository, IBuildResultHandle buildResultHandle) throws TeamRepositoryException {
        return BuildResult.getBuildResult(repository, buildResultHandle, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBuildResult getBuildResult(ITeamRepository repository, IBuildResultHandle buildResultHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getBuildResult(repository, buildResultHandle, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBuildResult getBuildResult(ITeamRepository repository, IBuildResultHandle buildResultHandle, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getBuildResult(repository, buildResultHandle, null, dbg);
    }

    public static IBuildResult getBuildResult(ITeamRepository repository, IBuildResultHandle buildResultHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildResult buildResult = (IBuildResult)repository.itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildResult)});
        }
        return buildResult;
    }

    public static List<IBuildResult> getBuildResults(ITeamRepository repository, List<?> resultList) throws TeamRepositoryException {
        return BuildResult.getBuildResults(repository, resultList, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static List<IBuildResult> getBuildResults(ITeamRepository repository, List<?> resultList, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getBuildResults(repository, resultList, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static List<IBuildResult> getBuildResults(ITeamRepository repository, List<?> resultList, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getBuildResults(repository, resultList, null, dbg);
    }

    public static List<IBuildResult> getBuildResults(ITeamRepository repository, List<?> resultList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IBuildResult> result = new ArrayList<IBuildResult>();
        if (resultList != null && resultList.size() > 0) {
            if (resultList.get(0) instanceof String) {
                result = Verification.isUUID((String)((String)resultList.get(0))) ? BuildResult.getBuildResultsFromUuids(repository, resultList, monitor, dbg) : BuildResult.getBuildResultsFromLabels(repository, resultList, monitor, dbg);
            } else if (resultList.get(0) instanceof IBuildResultHandle) {
                result = BuildResult.getBuildResultsFromHandles(repository, resultList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(result)});
        }
        return result;
    }

    private static List<IBuildResult> getBuildResultsFromHandles(ITeamRepository repository, List<IBuildResultHandle> resultList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return repository.itemManager().fetchCompleteItems(resultList, 0, monitor);
    }

    private static List<IBuildResult> getBuildResultsFromLabels(ITeamRepository repository, List<String> resultList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IBuildResultHandle> handles = new ArrayList<IBuildResultHandle>();
        for (String label : resultList) {
            ITeamBuildClient client = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
            ArrayList queryHandles = new ArrayList();
            BaseBuildResultQueryModel.BuildResultQueryModel buildResultQueryModel = BaseBuildResultQueryModel.BuildResultQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
            IPredicate filter = buildResultQueryModel.label()._eq(label);
            query.filter(filter);
            int options = 512;
            IItemQueryPage resultPage = client.queryItems(query, IQueryService.EMPTY_PARAMETERS, options, monitor);
            if (resultPage.getSize() > 0) {
                queryHandles.addAll(resultPage.getItemHandles());
                while (resultPage.hasNext()) {
                    resultPage = (IItemQueryPage)client.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                    queryHandles.addAll(resultPage.getItemHandles());
                }
            }
            if (queryHandles.size() != 1) continue;
            handles.add((IBuildResultHandle)queryHandles.get(0));
        }
        return repository.itemManager().fetchCompleteItems(handles, 0, monitor);
    }

    private static List<IBuildResult> getBuildResultsFromUuids(ITeamRepository repository, List<String> resultList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IBuildResultHandle> handles = new ArrayList<IBuildResultHandle>();
        for (String uuid : resultList) {
            handles.add((IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
        }
        return repository.itemManager().fetchCompleteItems(handles, 0, monitor);
    }

    public static IFetchResult getBuildResults(ITeamRepository repository, IBuildDefinition buildDefinition) throws TeamRepositoryException {
        return BuildResult.getBuildResults(repository, buildDefinition, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IFetchResult getBuildResults(ITeamRepository repository, IBuildDefinition buildDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getBuildResults(repository, buildDefinition, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IFetchResult getBuildResults(ITeamRepository repository, IBuildDefinition buildDefinition, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getBuildResults(repository, buildDefinition, null, dbg);
    }

    public static IFetchResult getBuildResults(ITeamRepository repository, IBuildDefinition buildDefinition, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IFetchResult fetchResult;
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        ArrayList buildResultHandleList = new ArrayList();
        BaseBuildResultQueryModel.BuildResultQueryModel buildResultQueryModel = BaseBuildResultQueryModel.BuildResultQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
        IPredicate itemHandle = buildResultQueryModel.buildDefinition()._eq(query.newItemHandleArg());
        IPredicate noPersonal = buildResultQueryModel.personalBuild()._isFalse();
        IPredicate completed = buildResultQueryModel.buildState()._eq(BuildState.COMPLETED.name());
        query.filter(itemHandle._and(noPersonal)._and(completed));
        query.orderByDsc((IField)buildResultQueryModel.buildStartTime());
        Object[] parameters = new Object[]{buildDefinition.getItemHandle()};
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, parameters, options, monitor);
        if (resultPage.getSize() > 0) {
            buildResultHandleList.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                buildResultHandleList.addAll(resultPage.getItemHandles());
            }
        }
        if ((fetchResult = repository.itemManager().fetchCompleteItemsPermissionAware(buildResultHandleList, 1, monitor)).hasPermissionDeniedItems()) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_BUILD_PERMISSION_BUILDRESULT, (Object)buildDefinition.getId(), (Object[])new Object[0]));
        }
        if (fetchResult.hasNotFoundItems()) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_BUILD_NOTFOUND_BUILDRESULT, (Object)buildDefinition.getId(), (Object[])new Object[0]));
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(fetchResult.getRetrievedItems().size())});
        }
        return fetchResult;
    }

    public static IFetchResult getBuildResults(ITeamRepository repository, IBuildDefinition buildDefinition, IPredicate[] filters) throws TeamRepositoryException {
        return BuildResult.getBuildResults(repository, buildDefinition, filters, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IFetchResult getBuildResults(ITeamRepository repository, IBuildDefinition buildDefinition, IPredicate[] filters, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getBuildResults(repository, buildDefinition, filters, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IFetchResult getBuildResults(ITeamRepository repository, IBuildDefinition buildDefinition, IPredicate[] filters, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getBuildResults(repository, buildDefinition, filters, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IFetchResult getBuildResults(ITeamRepository repository, IBuildDefinition buildDefinition, IPredicate[] filters, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IFetchResult fetchResult;
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        ArrayList buildResultHandleList = new ArrayList();
        BaseBuildResultQueryModel.BuildResultQueryModel buildResultQueryModel = BaseBuildResultQueryModel.BuildResultQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
        IPredicate itemHandle = buildResultQueryModel.buildDefinition()._eq(query.newItemHandleArg());
        if (filters != null && filters.length > 0) {
            int i = 0;
            while (i < filters.length) {
                itemHandle = itemHandle._and(filters[i]);
                ++i;
            }
        }
        query.filter(itemHandle);
        query.orderByDsc((IField)buildResultQueryModel.buildStartTime());
        Object[] parameters = new Object[]{buildDefinition.getItemHandle()};
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, parameters, options, monitor);
        if (resultPage.getSize() > 0) {
            buildResultHandleList.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                buildResultHandleList.addAll(resultPage.getItemHandles());
            }
        }
        if ((fetchResult = repository.itemManager().fetchCompleteItemsPermissionAware(buildResultHandleList, 1, monitor)).hasPermissionDeniedItems()) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_BUILD_PERMISSION_BUILDRESULT, (Object)buildDefinition.getId(), (Object[])new Object[0]));
        }
        if (fetchResult.hasNotFoundItems()) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_BUILD_NOTFOUND_BUILDRESULT, (Object)buildDefinition.getId(), (Object[])new Object[0]));
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(fetchResult.getRetrievedItems().size())});
        }
        return fetchResult;
    }

    public static List<IBuildResultHandle> getBuildResultHandles(ITeamRepository repository, IBuildDefinition buildDefinition) throws TeamRepositoryException {
        return BuildResult.getBuildResultHandles(repository, buildDefinition, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static List<IBuildResultHandle> getBuildResultHandles(ITeamRepository repository, IBuildDefinition buildDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getBuildResultHandles(repository, buildDefinition, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static List<IBuildResultHandle> getBuildResultHandles(ITeamRepository repository, IBuildDefinition buildDefinition, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getBuildResultHandles(repository, buildDefinition, null, dbg);
    }

    public static List<IBuildResultHandle> getBuildResultHandles(ITeamRepository repository, IBuildDefinition buildDefinition, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        ArrayList<IBuildResultHandle> buildResultHandleList = new ArrayList<IBuildResultHandle>();
        BaseBuildResultQueryModel.BuildResultQueryModel buildResultQueryModel = BaseBuildResultQueryModel.BuildResultQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
        IPredicate itemHandle = buildResultQueryModel.buildDefinition()._eq(query.newItemHandleArg());
        IPredicate noPersonal = buildResultQueryModel.personalBuild()._isFalse();
        IPredicate completed = buildResultQueryModel.buildState()._eq(BuildState.COMPLETED.name());
        query.filter(itemHandle._and(noPersonal)._and(completed));
        query.orderByDsc((IField)buildResultQueryModel.buildStartTime());
        Object[] parameters = new Object[]{buildDefinition.getItemHandle()};
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, parameters, options, monitor);
        if (resultPage.getSize() > 0) {
            buildResultHandleList.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                buildResultHandleList.addAll(resultPage.getItemHandles());
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(buildResultHandleList.size())});
        }
        return buildResultHandleList;
    }

    public static IBuildResult getCurrentBuildResult(ITeamRepository repository, String buildResultUUID) throws TeamRepositoryException {
        return BuildResult.getCurrentBuildResult(repository, buildResultUUID, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBuildResult getCurrentBuildResult(ITeamRepository repository, String buildResultUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getCurrentBuildResult(repository, buildResultUUID, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBuildResult getCurrentBuildResult(ITeamRepository repository, String buildResultUUID, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getCurrentBuildResult(repository, buildResultUUID, null, dbg);
    }

    public static IBuildResult getCurrentBuildResult(ITeamRepository repository, String buildResultUUID, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildResult buildResult = (IBuildResult)repository.itemManager().fetchCompleteItem(IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null), 1, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildResult)});
        }
        return buildResult;
    }

    public static IBuildResult getPartialBuildResult(ITeamRepository repository, String buildResultUUID) throws TeamRepositoryException {
        return BuildResult.getPartialBuildResult(repository, buildResultUUID, (IProgressMonitor)new NullProgressMonitor(), (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBuildResult getPartialBuildResult(ITeamRepository repository, String buildResultUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getPartialBuildResult(repository, buildResultUUID, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBuildResult getPartialBuildResult(ITeamRepository repository, String buildResultUUID, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getPartialBuildResult(repository, buildResultUUID, (IProgressMonitor)new NullProgressMonitor(), dbg);
    }

    public static IBuildResult getPartialBuildResult(ITeamRepository repository, String buildResultUUID, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildResult buildResult = (IBuildResult)repository.itemManager().fetchPartialItem(IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null), 1, Arrays.asList(IBuildResult.PROPERTIES_VIEW_ITEM), monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildResult)});
        }
        return buildResult;
    }

    public static IBuildResult getPartialBuildResult(ITeamRepository repository, String buildResultUUID, List<String> properties) throws TeamRepositoryException {
        return BuildResult.getPartialBuildResult(repository, buildResultUUID, properties, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBuildResult getPartialBuildResult(ITeamRepository repository, String buildResultUUID, List<String> properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getPartialBuildResult(repository, buildResultUUID, properties, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBuildResult getPartialBuildResult(ITeamRepository repository, String buildResultUUID, List<String> properties, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getPartialBuildResult(repository, buildResultUUID, properties, null, dbg);
    }

    public static IBuildResult getPartialBuildResult(ITeamRepository repository, String buildResultUUID, List<String> properties, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildResult buildResult = (IBuildResult)repository.itemManager().fetchPartialItem(IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null), 1, properties, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildResult)});
        }
        return buildResult;
    }

    public static IWorkspace getBuildResultAutoDeliverTargetContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient) throws TeamRepositoryException {
        return BuildResult.getBuildResultAutoDeliverTargetContribution(buildResult, teamBuildClient, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IWorkspace getBuildResultAutoDeliverTargetContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getBuildResultAutoDeliverTargetContribution(buildResult, teamBuildClient, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IWorkspace getBuildResultAutoDeliverTargetContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getBuildResultAutoDeliverTargetContribution(buildResult, teamBuildClient, null, dbg);
    }

    public static IWorkspace getBuildResultAutoDeliverTargetContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildResultContribution[] workspaceContribution = teamBuildClient.getBuildResultContributions((IBuildResultHandle)buildResult, new String[]{"autoDeliverTarget"}, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workspaceContribution.length)});
        }
        return workspaceContribution.length > 0 ? (IWorkspace)workspaceContribution[0].getExtendedContribution() : null;
    }

    public static IBaselineSetHandle getBuildResultSnapshotContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient) throws TeamRepositoryException {
        return BuildResult.getBuildResultSnapshotContribution(buildResult, teamBuildClient, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBaselineSetHandle getBuildResultSnapshotContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getBuildResultSnapshotContribution(buildResult, teamBuildClient, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IBaselineSetHandle getBuildResultSnapshotContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getBuildResultSnapshotContribution(buildResult, teamBuildClient, null, dbg);
    }

    public static IBaselineSetHandle getBuildResultSnapshotContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildResultContribution[] snapshotContribution = teamBuildClient.getBuildResultContributions((IBuildResultHandle)buildResult, new String[]{"buildSnapshot"}, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(snapshotContribution.length)});
        }
        return snapshotContribution.length > 0 ? (IBaselineSetHandle)snapshotContribution[0].getExtendedContribution() : null;
    }

    public static IWorkspace getBuildResultWorkspaceContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient) throws TeamRepositoryException {
        return BuildResult.getBuildResultWorkspaceContribution(buildResult, teamBuildClient, null, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IWorkspace getBuildResultWorkspaceContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildResult.getBuildResultWorkspaceContribution(buildResult, teamBuildClient, monitor, (IDebugger)new Debugger(BuildResult.class));
    }

    public static IWorkspace getBuildResultWorkspaceContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient, IDebugger dbg) throws TeamRepositoryException {
        return BuildResult.getBuildResultWorkspaceContribution(buildResult, teamBuildClient, null, dbg);
    }

    public static IWorkspace getBuildResultWorkspaceContribution(IBuildResult buildResult, ITeamBuildClient teamBuildClient, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildResultContribution[] workspaceContribution = teamBuildClient.getBuildResultContributions((IBuildResultHandle)buildResult, new String[]{"buildWorkspace"}, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(workspaceContribution.length)});
        }
        return workspaceContribution.length > 0 ? (IWorkspace)workspaceContribution[0].getExtendedContribution() : null;
    }
}

