/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.extensions.client.nls.Messages;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.build.internal.common.model.dto.IBuildItemNamePair;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildFolder {
    private static final String className = BuildFolder.class.getSimpleName();

    public static IBuildFolder createBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderName) throws TeamRepositoryException {
        return BuildFolder.createBuildFolder(repository, processArea, parentFolder, folderName, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolder createBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderName, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.createBuildFolder(repository, processArea, parentFolder, folderName, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolder createBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderName, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.createBuildFolder(repository, processArea, parentFolder, folderName, null, dbg);
    }

    public static IBuildFolder createBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.createBuildFolder((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), processArea, parentFolder, folderName, monitor, dbg);
    }

    public static IBuildFolder createBuildFolder(ITeamBuildClient buildClient, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildFolder buildFolder = BuildItemFactory.createBuildFolder();
        buildFolder.setName(folderName);
        buildFolder.setParent(parentFolder);
        buildFolder.setProcessArea(processArea);
        buildFolder = buildClient.save(buildFolder, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildFolder)});
        }
        return buildFolder;
    }

    public static IBuildFolderHandle createBuildFoldersForPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath) throws TeamRepositoryException {
        return BuildFolder.createBuildFoldersForPath((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), processArea, folderPath, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolderHandle createBuildFoldersForPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.createBuildFoldersForPath((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), processArea, folderPath, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolderHandle createBuildFoldersForPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.createBuildFoldersForPath((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), processArea, folderPath, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolderHandle createBuildFoldersForPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.createBuildFoldersForPath((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), processArea, folderPath, monitor, dbg);
    }

    public static IBuildFolderHandle createBuildFoldersForPath(ITeamBuildClient buildClient, IProcessAreaHandle processArea, String folderPath, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildFolderHandle result = null;
        String[] folderNames = StringUtil.stripLeading((String)folderPath, (String)"/").split("/");
        if (folderNames.length > 0) {
            IBuildFolderHandle folderHandle = null;
            IBuildFolderHandle parentHandle = null;
            int i = 0;
            while (i < folderNames.length) {
                folderHandle = BuildFolder.findBuildFolder(buildClient, processArea, parentHandle, folderNames[i], monitor, dbg);
                if (folderHandle == null) {
                    int j = i;
                    while (j < folderNames.length) {
                        folderHandle = BuildFolder.createBuildFolder(buildClient, processArea, parentHandle, folderNames[j], monitor, dbg);
                        if (folderHandle == null) {
                            throw new TeamRepositoryException(NLS.bind((String)Messages.UTIL_BUILD_UNABLE_TO_CREATE_FOLDER, (Object)LogString.valueOf((String)folderNames[j]), (Object[])new Object[0]));
                        }
                        parentHandle = folderHandle;
                        ++j;
                    }
                    break;
                }
                parentHandle = folderHandle;
                ++i;
            }
            result = folderHandle;
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static void deleteBuildFolder(ITeamRepository repository, IBuildFolderHandle folderHandle) throws TeamRepositoryException {
        BuildFolder.deleteBuildFolder(repository, folderHandle, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static void deleteBuildFolder(ITeamRepository repository, IBuildFolderHandle folderHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        BuildFolder.deleteBuildFolder(repository, folderHandle, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static void deleteBuildFolder(ITeamRepository repository, IBuildFolderHandle folderHandle, IDebugger dbg) throws TeamRepositoryException {
        BuildFolder.deleteBuildFolder(repository, folderHandle, null, dbg);
    }

    public static void deleteBuildFolder(ITeamRepository repository, IBuildFolderHandle folderHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        BuildFolder.deleteBuildFolder((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), folderHandle, monitor, dbg);
    }

    public static void deleteBuildFolder(ITeamBuildClient buildClient, IBuildFolderHandle folderHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        String folderHandleUuid = LogString.valueOf((IItemHandle)folderHandle);
        buildClient.delete(new IBuildFolderHandle[]{folderHandle}, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), folderHandleUuid});
        }
    }

    public static void deleteBuildFolders(ITeamRepository repository, IBuildFolderHandle[] folderHandles) throws TeamRepositoryException {
        BuildFolder.deleteBuildFolders(repository, folderHandles, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static void deleteBuildFolders(ITeamRepository repository, IBuildFolderHandle[] folderHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        BuildFolder.deleteBuildFolders(repository, folderHandles, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static void deleteBuildFolders(ITeamRepository repository, IBuildFolderHandle[] folderHandles, IDebugger dbg) throws TeamRepositoryException {
        BuildFolder.deleteBuildFolders(repository, folderHandles, null, dbg);
    }

    public static void deleteBuildFolders(ITeamRepository repository, IBuildFolderHandle[] folderHandles, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        BuildFolder.deleteBuildFolders((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), folderHandles, monitor, dbg);
    }

    public static void deleteBuildFolders(ITeamBuildClient buildClient, IBuildFolderHandle[] folderHandles, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        String folderHandleCount = Integer.toString(folderHandles.length);
        buildClient.delete(folderHandles, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), folderHandleCount});
        }
    }

    public static IBuildFolderHandle findBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderName) throws TeamRepositoryException {
        return BuildFolder.findBuildFolder(repository, processArea, parentFolder, folderName, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolderHandle findBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderName, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.findBuildFolder(repository, processArea, parentFolder, folderName, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolderHandle findBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderName, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.findBuildFolder(repository, processArea, parentFolder, folderName, null, dbg);
    }

    public static IBuildFolderHandle findBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.findBuildFolder((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), processArea, parentFolder, folderName, monitor, dbg);
    }

    public static IBuildFolderHandle findBuildFolder(ITeamBuildClient buildClient, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderName, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildFolderHandle result = null;
        IBuildItemNamePair[] buildItemNamePair = buildClient.getChildrenOfFolder(parentFolder, new IProcessAreaHandle[]{processArea}, monitor);
        int i = 0;
        while (i < buildItemNamePair.length) {
            if (buildItemNamePair[i].getName().equals(folderName) && buildItemNamePair[i].getItem() instanceof IBuildFolderHandle) {
                result = (IBuildFolderHandle)buildItemNamePair[i].getItem();
                break;
            }
            ++i;
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static Map<String, IBuildFolderHandle> findBuildFolders(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderPath) throws TeamRepositoryException {
        return BuildFolder.findBuildFolders(repository, processArea, parentFolder, folderPath, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static Map<String, IBuildFolderHandle> findBuildFolders(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderPath, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.findBuildFolders(repository, processArea, parentFolder, folderPath, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static Map<String, IBuildFolderHandle> findBuildFolders(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderPath, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.findBuildFolders(repository, processArea, parentFolder, folderPath, null, dbg);
    }

    public static Map<String, IBuildFolderHandle> findBuildFolders(ITeamRepository repository, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderPath, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.findBuildFolders((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), processArea, parentFolder, folderPath, monitor, dbg);
    }

    public static Map<String, IBuildFolderHandle> findBuildFolders(ITeamBuildClient buildClient, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, String folderPath, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        HashMap<String, IBuildFolderHandle> buildFolderHandleMap = new HashMap<String, IBuildFolderHandle>();
        IBuildItemNamePair[] buildItemNamePair = buildClient.getChildrenOfFolder(parentFolder, new IProcessAreaHandle[]{processArea}, monitor);
        int i = 0;
        while (i < buildItemNamePair.length) {
            if (buildItemNamePair[i].getItem() instanceof IBuildFolderHandle) {
                String currentPath = String.valueOf(folderPath) + "/" + buildItemNamePair[i].getName();
                IBuildFolderHandle currentHandle = (IBuildFolderHandle)buildItemNamePair[i].getItem();
                buildFolderHandleMap.put(currentPath, currentHandle);
                buildFolderHandleMap.putAll(BuildFolder.findBuildFolders(buildClient, processArea, currentHandle, currentPath, monitor, dbg));
            }
            ++i;
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(buildFolderHandleMap.size())});
        }
        return buildFolderHandleMap;
    }

    public static IBuildFolderHandle findBuildFolderByPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath) throws TeamRepositoryException {
        return BuildFolder.findBuildFolderByPath(repository, processArea, folderPath, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolderHandle findBuildFolderByPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.findBuildFolderByPath(repository, processArea, folderPath, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolderHandle findBuildFolderByPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.findBuildFolderByPath(repository, processArea, folderPath, null, dbg);
    }

    public static IBuildFolderHandle findBuildFolderByPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.findBuildFolderByPath((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), processArea, folderPath, monitor, dbg);
    }

    public static IBuildFolderHandle findBuildFolderByPath(ITeamBuildClient buildClient, IProcessAreaHandle processArea, String folderPath, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildFolderHandle result = null;
        String[] folderNames = StringUtil.stripLeading((String)folderPath, (String)"/").split("/");
        if (folderNames.length > 0) {
            IBuildFolderHandle folderHandle = null;
            int i = 0;
            while (i < folderNames.length) {
                if ((folderHandle = BuildFolder.findBuildFolder(buildClient, processArea, folderHandle, folderNames[i], monitor, dbg)) == null) break;
                ++i;
            }
            result = folderHandle;
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static IBuildFolderHandle findBuildFolderViaPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath) {
        return BuildFolder.findBuildFolderViaPath(repository, processArea, folderPath, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolderHandle findBuildFolderViaPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath, IProgressMonitor monitor) {
        return BuildFolder.findBuildFolderViaPath(repository, processArea, folderPath, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolderHandle findBuildFolderViaPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath, IDebugger dbg) {
        return BuildFolder.findBuildFolderViaPath(repository, processArea, folderPath, null, dbg);
    }

    public static IBuildFolderHandle findBuildFolderViaPath(ITeamRepository repository, IProcessAreaHandle processArea, String folderPath, IProgressMonitor monitor, IDebugger dbg) {
        IBuildFolderHandle result;
        block2: {
            result = null;
            try {
                result = BuildFolder.findBuildFolderByPath(repository, processArea, folderPath, monitor, dbg);
            }
            catch (TeamRepositoryException e) {
                if (!dbg.isDebug()) break block2;
                e.printStackTrace();
            }
        }
        return result;
    }

    public static List<IBuildFolderHandle> findBuildFoldersByPath(ITeamRepository repository, IProcessAreaHandle processArea, List<String> folderPathList) throws TeamRepositoryException {
        return BuildFolder.findBuildFoldersByPath(repository, processArea, folderPathList, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<IBuildFolderHandle> findBuildFoldersByPath(ITeamRepository repository, IProcessAreaHandle processArea, List<String> folderPathList, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.findBuildFoldersByPath(repository, processArea, folderPathList, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<IBuildFolderHandle> findBuildFoldersByPath(ITeamRepository repository, IProcessAreaHandle processArea, List<String> folderPathList, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.findBuildFoldersByPath(repository, processArea, folderPathList, null, dbg);
    }

    public static List<IBuildFolderHandle> findBuildFoldersByPath(ITeamRepository repository, IProcessAreaHandle processArea, List<String> folderPathList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.findBuildFoldersByPath((ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class), processArea, folderPathList, monitor, dbg);
    }

    public static List<IBuildFolderHandle> findBuildFoldersByPath(ITeamBuildClient buildClient, IProcessAreaHandle processArea, List<String> folderPathList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IBuildFolderHandle> result = new ArrayList<IBuildFolderHandle>();
        for (String folderPath : folderPathList) {
            String[] folderNames = StringUtil.stripLeading((String)folderPath, (String)"/").split("/");
            if (folderNames.length <= 0) continue;
            IBuildFolderHandle folderHandle = null;
            int i = 0;
            while (i < folderNames.length) {
                if ((folderHandle = BuildFolder.findBuildFolder(buildClient, processArea, folderHandle, folderNames[i], monitor, dbg)) == null) break;
                ++i;
            }
            result.add(folderHandle);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(result.size())});
        }
        return result;
    }

    public static IBuildItemNamePair[] getAncestors(ITeamBuildClient buildClient, IItemHandle itemHandle) throws TeamRepositoryException {
        return BuildFolder.getAncestors(buildClient, itemHandle, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildItemNamePair[] getAncestors(ITeamBuildClient buildClient, IItemHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.getAncestors(buildClient, itemHandle, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildItemNamePair[] getAncestors(ITeamBuildClient buildClient, IItemHandle itemHandle, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getAncestors(buildClient, itemHandle, null, dbg);
    }

    public static IBuildItemNamePair[] getAncestors(ITeamBuildClient buildClient, IItemHandle itemHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        Object[] result = buildClient.getAncestorFolders(itemHandle, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object[])result)});
        }
        return result;
    }

    public static IBuildFolder getBuildFolder(ITeamRepository repository, IBuildFolderHandle folderHandle) throws TeamRepositoryException {
        return BuildFolder.getBuildFolder(repository, folderHandle, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolder getBuildFolder(ITeamRepository repository, IBuildFolderHandle folderHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.getBuildFolder(repository, folderHandle, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolder getBuildFolder(ITeamRepository repository, IBuildFolderHandle folderHandle, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getBuildFolder(repository, folderHandle, null, dbg);
    }

    public static IBuildFolder getBuildFolder(ITeamRepository repository, IBuildFolderHandle folderHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildFolder result = (IBuildFolder)repository.itemManager().fetchCompleteItem((IItemHandle)folderHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)result)});
        }
        return result;
    }

    public static IBuildFolder getBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, String folderString) throws TeamRepositoryException {
        return BuildFolder.getBuildFolder(repository, processArea, folderString, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolder getBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, String folderString, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.getBuildFolder(repository, processArea, folderString, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildFolder getBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, String folderString, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getBuildFolder(repository, processArea, folderString, null, dbg);
    }

    public static IBuildFolder getBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, String folderString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildFolder result = null;
        if (Verification.isUUID((String)folderString)) {
            result = (IBuildFolder)repository.itemManager().fetchCompleteItem(IBuildFolder.ITEM_TYPE.createItemHandle(UUID.valueOf((String)folderString), null), 0, monitor);
        } else {
            IBuildFolderHandle folderHandle = BuildFolder.findBuildFolderByPath(repository, processArea, folderString, monitor, dbg);
            if (folderHandle != null) {
                result = (IBuildFolder)repository.itemManager().fetchCompleteItem((IItemHandle)folderHandle, 0, monitor);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)result)});
        }
        return result;
    }

    public static String getBuildFolderPath(ITeamRepository repository, IBuildDefinitionHandle definitionHandle) throws TeamRepositoryException {
        return BuildFolder.getBuildFolderPath(repository, definitionHandle, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static String getBuildFolderPath(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.getBuildFolderPath(repository, definitionHandle, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static String getBuildFolderPath(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getBuildFolderPath(repository, definitionHandle, null, dbg);
    }

    public static String getBuildFolderPath(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        String result = "";
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        IBuildItemNamePair[] buildItemNamePair = buildClient.getAncestorFolders((IItemHandle)definitionHandle, monitor);
        int i = 0;
        while (i < buildItemNamePair.length) {
            if (buildItemNamePair[i].getItem() instanceof IBuildFolderHandle) {
                result = "/" + buildItemNamePair[i].getName() + result;
            }
            ++i;
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((String)result)});
        }
        return result;
    }

    public static List<IBuildFolder> getBuildFolders(ITeamRepository repository, List<IBuildFolderHandle> folderList) throws TeamRepositoryException {
        return BuildFolder.getBuildFolders(repository, folderList, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<IBuildFolder> getBuildFolders(ITeamRepository repository, List<IBuildFolderHandle> folderList, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.getBuildFolders(repository, folderList, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<IBuildFolder> getBuildFolders(ITeamRepository repository, List<IBuildFolderHandle> folderList, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getBuildFolders(repository, folderList, null, dbg);
    }

    public static List<IBuildFolder> getBuildFolders(ITeamRepository repository, List<IBuildFolderHandle> folderList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getBuildFolders(repository, null, folderList, monitor, dbg);
    }

    public static List<IBuildFolder> getBuildFolders(ITeamRepository repository, IProcessAreaHandle processArea, List<?> folderList) throws TeamRepositoryException {
        return BuildFolder.getBuildFolders(repository, processArea, folderList, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<IBuildFolder> getBuildFolders(ITeamRepository repository, IProcessAreaHandle processArea, List<?> folderList, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.getBuildFolders(repository, processArea, folderList, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<IBuildFolder> getBuildFolders(ITeamRepository repository, IProcessAreaHandle processArea, List<?> folderList, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getBuildFolders(repository, processArea, folderList, null, dbg);
    }

    public static List<IBuildFolder> getBuildFolders(ITeamRepository repository, IProcessAreaHandle processArea, List<?> folderList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        List<IBuildFolder> result = new ArrayList<IBuildFolder>();
        if (folderList != null && folderList.size() > 0) {
            if (folderList.get(0) instanceof IBuildFolderHandle) {
                result = BuildFolder.getBuildFoldersFromHandles(repository, folderList, monitor, dbg);
            } else if (folderList.get(0) instanceof String) {
                result = Verification.isUUID((String)((String)folderList.get(0))) ? BuildFolder.getBuildFoldersFromUuids(repository, processArea, folderList, monitor, dbg) : BuildFolder.getBuildFoldersFromIds(repository, processArea, folderList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(result)});
        }
        return result;
    }

    private static List<IBuildFolder> getBuildFoldersFromHandles(ITeamRepository repository, List<IBuildFolderHandle> folderList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List result = repository.itemManager().fetchCompleteItems(folderList, 0, monitor);
        return result;
    }

    private static List<IBuildFolder> getBuildFoldersFromIds(ITeamRepository repository, IProcessAreaHandle processArea, List<String> folderList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IBuildFolder> result = new ArrayList<IBuildFolder>();
        List<IBuildFolderHandle> folderHandles = BuildFolder.findBuildFoldersByPath(repository, processArea, folderList, monitor, dbg);
        if (folderHandles != null) {
            result.addAll(repository.itemManager().fetchCompleteItems(folderHandles, 0, monitor));
        }
        return result;
    }

    private static List<IBuildFolder> getBuildFoldersFromUuids(ITeamRepository repository, IProcessAreaHandle processArea, List<String> folderList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IBuildFolder> result = new ArrayList<IBuildFolder>();
        ArrayList<IBuildFolderHandle> handleList = new ArrayList<IBuildFolderHandle>(folderList.size());
        for (String folder : folderList) {
            handleList.add((IBuildFolderHandle)IBuildFolder.ITEM_TYPE.createItemHandle(UUID.valueOf((String)folder), null));
        }
        if (handleList.size() > 0) {
            result.addAll(repository.itemManager().fetchCompleteItems(handleList, 0, monitor));
        }
        return result;
    }

    public static List<IBuildFolderHandle> getBuildFolderHandles(List<IBuildFolder> buildFolderList) throws TeamRepositoryException {
        return BuildFolder.getBuildFolderHandles(buildFolderList, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<IBuildFolderHandle> getBuildFolderHandles(List<IBuildFolder> buildFolderList, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.getBuildFolderHandles(buildFolderList, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<IBuildFolderHandle> getBuildFolderHandles(List<IBuildFolder> buildFolderList, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getBuildFolderHandles(buildFolderList, null, dbg);
    }

    public static List<IBuildFolderHandle> getBuildFolderHandles(List<IBuildFolder> buildFolderList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IBuildFolderHandle> folderHandleList = new ArrayList<IBuildFolderHandle>();
        for (IBuildFolder buildFolder : buildFolderList) {
            if (buildFolder != null) {
                folderHandleList.add((IBuildFolderHandle)buildFolder.getItemHandle());
                continue;
            }
            folderHandleList.add(null);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(folderHandleList.size())});
        }
        return folderHandleList;
    }

    public static IBuildItemNamePair[] getChildren(ITeamBuildClient buildClient, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder) throws TeamRepositoryException {
        return BuildFolder.getChildren(buildClient, processArea, parentFolder, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildItemNamePair[] getChildren(ITeamBuildClient buildClient, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.getChildren(buildClient, processArea, parentFolder, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static IBuildItemNamePair[] getChildren(ITeamBuildClient buildClient, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getChildren(buildClient, processArea, parentFolder, null, dbg);
    }

    public static IBuildItemNamePair[] getChildren(ITeamBuildClient buildClient, IProcessAreaHandle processArea, IBuildFolderHandle parentFolder, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        Object[] result = buildClient.getChildrenOfFolder(parentFolder, new IProcessAreaHandle[]{processArea}, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((Object[])result)});
        }
        return result;
    }

    public static String getFolderPath(ITeamRepository repository, IBuildFolderHandle folderHandle) throws TeamRepositoryException {
        return BuildFolder.getFolderPath(repository, folderHandle, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static String getFolderPath(ITeamRepository repository, IBuildFolderHandle folderHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.getFolderPath(repository, folderHandle, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static String getFolderPath(ITeamRepository repository, IBuildFolderHandle folderHandle, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getFolderPath(repository, folderHandle, null, dbg);
    }

    public static String getFolderPath(ITeamRepository repository, IBuildFolderHandle folderHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildFolder buildFolder = (IBuildFolder)repository.itemManager().fetchCompleteItem((IItemHandle)folderHandle, 0, monitor);
        String result = "/" + buildFolder.getName();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        IBuildItemNamePair[] buildItemNamePair = buildClient.getAncestorFolders((IItemHandle)folderHandle, monitor);
        int i = 0;
        while (i < buildItemNamePair.length) {
            if (buildItemNamePair[i].getItem() instanceof IBuildFolderHandle) {
                result = "/" + buildItemNamePair[i].getName() + result;
            }
            ++i;
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((String)result)});
        }
        return result;
    }

    public static String getFolderPathName(ITeamRepository repository, IBuildFolderHandle folderHandle) {
        return BuildFolder.getFolderPathName(repository, folderHandle, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static String getFolderPathName(ITeamRepository repository, IBuildFolderHandle folderHandle, IProgressMonitor monitor) {
        return BuildFolder.getFolderPathName(repository, folderHandle, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static String getFolderPathName(ITeamRepository repository, IBuildFolderHandle folderHandle, IDebugger dbg) {
        return BuildFolder.getFolderPathName(repository, folderHandle, null, dbg);
    }

    public static String getFolderPathName(ITeamRepository repository, IBuildFolderHandle folderHandle, IProgressMonitor monitor, IDebugger dbg) {
        String result;
        block3: {
            result = folderHandle.getItemId().getUuidValue();
            try {
                String pathName = BuildFolder.getFolderPath(repository, folderHandle, monitor, dbg);
                if (pathName != null) {
                    result = pathName;
                }
            }
            catch (TeamRepositoryException e) {
                if (!dbg.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        return result;
    }

    public static List<String> getFolderPaths(ITeamRepository repository, List<IBuildFolderHandle> folderHandles) throws TeamRepositoryException {
        return BuildFolder.getFolderPaths(repository, folderHandles, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<String> getFolderPaths(ITeamRepository repository, List<IBuildFolderHandle> folderHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildFolder.getFolderPaths(repository, folderHandles, monitor, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<String> getFolderPaths(ITeamRepository repository, List<IBuildFolderHandle> folderHandles, IDebugger dbg) throws TeamRepositoryException {
        return BuildFolder.getFolderPaths(repository, folderHandles, null, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static List<String> getFolderPaths(ITeamRepository repository, List<IBuildFolderHandle> folderHandles, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        for (IBuildFolderHandle folderHandle : folderHandles) {
            if (folderHandle != null) {
                result.add(BuildFolder.getFolderPath(repository, folderHandle, monitor, dbg));
                continue;
            }
            result.add(null);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(result.size())});
        }
        return result;
    }

    public static String getMessageBinding(IBuildFolder buildFolder) {
        return BuildFolder.getMessageBinding(buildFolder, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static String getMessageBinding(IBuildFolder buildFolder, IDebugger dbg) {
        String result = "";
        try {
            result = buildFolder == null ? "null" : (buildFolder.getName() != null ? buildFolder.getName() : (buildFolder.getItemId() != null ? buildFolder.getItemId().getUuidValue() : "null"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildFolder)});
        }
        return result;
    }

    public static void log(IBuildFolder buildFolder) throws TeamRepositoryException {
        BuildFolder.log(buildFolder, (IDebugger)new Debugger(BuildFolder.class));
    }

    public static void log(IBuildFolder buildFolder, IDebugger dbg) throws TeamRepositoryException {
        StringBuilder display = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        if (buildFolder == null) {
            display.append(newLine);
            display.append("IBuildFolder: null");
        } else {
            try {
                display.append(newLine);
                display.append("IBuildFolder: " + LogString.valueOf((String)buildFolder.getName()) + newLine);
                display.append("  getContextId:         " + LogString.valueOf((UUID)buildFolder.getContextId()) + newLine);
                display.append("  getFullState:         " + LogString.valueOf((IItem)buildFolder.getFullState()) + newLine);
                display.append("  getItemHandle:        " + LogString.valueOf((IItemHandle)buildFolder.getItemHandle()) + newLine);
                display.append("  getItemId:            " + LogString.valueOf((UUID)buildFolder.getItemId()) + newLine);
                display.append("  getItemType:          " + LogString.valueOf((Object)buildFolder.getItemType()) + newLine);
                display.append("  getModifiedBy:        " + LogString.valueOf((IItemHandle)buildFolder.getModifiedBy()) + newLine);
                display.append("  getName:              " + LogString.valueOf((String)buildFolder.getName()) + newLine);
                display.append("  getOrigin:            " + LogString.valueOf((Object)buildFolder.getOrigin()) + newLine);
                display.append("  getParent:            " + LogString.valueOf((IItemHandle)buildFolder.getParent()) + newLine);
                display.append("  getProcessArea:       " + LogString.valueOf((IItemHandle)buildFolder.getProcessArea()) + newLine);
                display.append("  getRequestedModified: " + LogString.valueOf((Date)buildFolder.getRequestedModified()) + newLine);
                display.append("  getRequestedStateId:  " + LogString.valueOf((UUID)buildFolder.getRequestedStateId()) + newLine);
                display.append("  getStateHandle:       " + LogString.valueOf((IItemHandle)buildFolder.getStateHandle()) + newLine);
                display.append("  getStateId:           " + LogString.valueOf((UUID)buildFolder.getStateId()) + newLine);
                display.append("  hasFullState:         " + LogString.valueOf((boolean)buildFolder.hasFullState()) + newLine);
                display.append("  hasHistory:           " + LogString.valueOf((boolean)buildFolder.hasHistory()) + newLine);
                display.append("  hasStateId:           " + LogString.valueOf((boolean)buildFolder.hasStateId()) + newLine);
                display.append("  hashCode:             " + LogString.valueOf((int)buildFolder.hashCode()) + newLine);
                display.append("  isAuditable:          " + LogString.valueOf((boolean)buildFolder.isAuditable()) + newLine);
                display.append("  isComplete:           " + LogString.valueOf((boolean)buildFolder.isComplete()) + newLine);
                display.append("  isConfigurationAware: " + LogString.valueOf((boolean)buildFolder.isConfigurationAware()) + newLine);
                display.append("  isImmutable:          " + LogString.valueOf((boolean)buildFolder.isImmutable()) + newLine);
                display.append("  isNewItem:            " + LogString.valueOf((boolean)buildFolder.isNewItem()) + newLine);
                display.append("  isRedactedCopy:       " + LogString.valueOf((boolean)buildFolder.isRedactedCopy()) + newLine);
                display.append("  isSimple:             " + LogString.valueOf((boolean)buildFolder.isSimple()) + newLine);
                display.append("  isUnmanaged:          " + LogString.valueOf((boolean)buildFolder.isUnmanaged()) + newLine);
                display.append("  isWorkingCopy:        " + LogString.valueOf((boolean)buildFolder.isWorkingCopy()) + newLine);
                display.append("  modified:             " + LogString.valueOf((Date)buildFolder.modified()) + newLine);
                display.append("  size:                 " + LogString.valueOf((long)buildFolder.size()) + newLine);
            }
            catch (Exception e) {
                dbg.log(e.toString());
            }
        }
        dbg.log(display.toString());
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildFolder)});
        }
    }
}

