/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.buildengine.IBuildEngineTemplate;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.build.internal.common.model.query.BaseBuildEngineQueryModel;
import com.ibm.team.build.internal.common.registry.BuildEngineTemplateExtension;
import com.ibm.team.build.internal.common.registry.BuildEngineTemplateExtensionManager;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildEngine {
    private static final String className = BuildEngine.class.getSimpleName();

    public static IBuildEngine createBuildEngine(ITeamRepository repository, IProcessAreaHandle processArea, String templateId, String id, String description, boolean active, boolean polling, int threshold, List<IBuildProperty> buildPropertyList) throws TeamRepositoryException {
        return BuildEngine.createBuildEngine(repository, processArea, templateId, id, description, active, polling, threshold, buildPropertyList, null, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static IBuildEngine createBuildEngine(ITeamRepository repository, IProcessAreaHandle processArea, String templateId, String id, String description, boolean active, boolean polling, int threshold, List<IBuildProperty> buildPropertyList, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildEngine.createBuildEngine(repository, processArea, templateId, id, description, active, polling, threshold, buildPropertyList, monitor, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static IBuildEngine createBuildEngine(ITeamRepository repository, IProcessAreaHandle processArea, String templateId, String id, String description, boolean active, boolean polling, int threshold, List<IBuildProperty> buildPropertyList, IDebugger dbg) throws TeamRepositoryException {
        return BuildEngine.createBuildEngine(repository, processArea, templateId, id, description, active, polling, threshold, buildPropertyList, null, dbg);
    }

    public static IBuildEngine createBuildEngine(ITeamRepository repository, IProcessAreaHandle processArea, String templateId, String id, String description, boolean active, boolean polling, int threshold, List<IBuildProperty> buildPropertyList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildEngine buildEngine = BuildItemFactory.createBuildEngine();
        BuildEngineTemplateExtension template = BuildEngineTemplateExtensionManager.getInstance().getBuildEngineTemplate(templateId);
        buildEngine.initializeConfiguration((IBuildEngineTemplate)template);
        buildEngine.setId(id);
        buildEngine.setDescription(description);
        buildEngine.setProcessArea(processArea);
        buildEngine.setActive(active);
        buildEngine.setRequestProcessingEnabled(polling);
        buildEngine.setMonitoringThreshold(threshold);
        buildEngine.getProperties().addAll(buildPropertyList);
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        buildEngine = buildClient.save(buildEngine, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), buildEngine.getItemId().getUuidValue()});
        }
        return buildEngine;
    }

    public static void deleteBuildEngine(ITeamRepository repository, IBuildEngineHandle engineHandle) throws TeamRepositoryException {
        BuildEngine.deleteBuildEngine(repository, engineHandle, null, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static void deleteBuildEngine(ITeamRepository repository, IBuildEngineHandle engineHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        BuildEngine.deleteBuildEngine(repository, engineHandle, monitor, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static void deleteBuildEngine(ITeamRepository repository, IBuildEngineHandle engineHandle, IDebugger dbg) throws TeamRepositoryException {
        BuildEngine.deleteBuildEngine(repository, engineHandle, null, dbg);
    }

    public static void deleteBuildEngine(ITeamRepository repository, IBuildEngineHandle engineHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        String itemUuid = LogString.valueOf((IItemHandle)engineHandle);
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        buildClient.delete(engineHandle, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), itemUuid});
        }
    }

    public static IBuildEngine getBuildEngine(ITeamRepository repository, String engineId) throws TeamRepositoryException {
        return BuildEngine.getBuildEngine(repository, engineId, null, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static IBuildEngine getBuildEngine(ITeamRepository repository, String engineId, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildEngine.getBuildEngine(repository, engineId, monitor, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static IBuildEngine getBuildEngine(ITeamRepository repository, String engineId, IDebugger dbg) throws TeamRepositoryException {
        return BuildEngine.getBuildEngine(repository, engineId, null, dbg);
    }

    public static IBuildEngine getBuildEngine(ITeamRepository repository, String engineId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildEngine buildEngine = null;
        if (Verification.isUUID((String)engineId)) {
            IItemManager client = repository.itemManager();
            buildEngine = (IBuildEngine)client.fetchCompleteItem(IBuildEngine.ITEM_TYPE.createItemHandle(UUID.valueOf((String)engineId), null), 0, monitor);
        } else {
            ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
            buildEngine = buildClient.getBuildEngine(engineId, monitor);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildEngine)});
        }
        return buildEngine;
    }

    public static IBuildEngine getBuildEngine(ITeamRepository repository, IBuildEngineHandle engineHandle) throws TeamRepositoryException {
        return BuildEngine.getBuildEngine(repository, engineHandle, null, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static IBuildEngine getBuildEngine(ITeamRepository repository, IBuildEngineHandle engineHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildEngine.getBuildEngine(repository, engineHandle, monitor, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static IBuildEngine getBuildEngine(ITeamRepository repository, IBuildEngineHandle engineHandle, IDebugger dbg) throws TeamRepositoryException {
        return BuildEngine.getBuildEngine(repository, engineHandle, null, dbg);
    }

    public static IBuildEngine getBuildEngine(ITeamRepository repository, IBuildEngineHandle engineHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildEngine buildEngine = (IBuildEngine)repository.itemManager().fetchCompleteItem((IItemHandle)engineHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildEngine)});
        }
        return buildEngine;
    }

    public static List<IBuildEngine> getBuildEngines(ITeamRepository repository, List<?> engineList) throws TeamRepositoryException {
        return BuildEngine.getBuildEngines(repository, engineList, null, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static List<IBuildEngine> getBuildEngines(ITeamRepository repository, List<?> engineList, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildEngine.getBuildEngines(repository, engineList, monitor, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static List<IBuildEngine> getBuildEngines(ITeamRepository repository, List<?> engineList, IDebugger dbg) throws TeamRepositoryException {
        return BuildEngine.getBuildEngines(repository, engineList, null, dbg);
    }

    public static List<IBuildEngine> getBuildEngines(ITeamRepository repository, List<?> engineList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IBuildEngine> buildEngineList = new ArrayList<IBuildEngine>();
        if (engineList != null && engineList.size() > 0) {
            if (engineList.get(0) instanceof IBuildEngineHandle) {
                buildEngineList = BuildEngine.getBuildEnginesFromHandles(repository, engineList, monitor, dbg);
            } else if (engineList.get(0) instanceof String) {
                buildEngineList = Verification.isUUID((String)((String)engineList.get(0))) ? BuildEngine.getBuildEnginesFromUuids(repository, engineList, monitor, dbg) : BuildEngine.getBuildEnginesFromIds(repository, engineList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(buildEngineList)});
        }
        return buildEngineList;
    }

    private static List<IBuildEngine> getBuildEnginesFromHandles(ITeamRepository repository, List<IBuildEngineHandle> engineList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List buildEngineList = repository.itemManager().fetchCompleteItems(engineList, 0, monitor);
        return buildEngineList;
    }

    private static List<IBuildEngine> getBuildEnginesFromIds(ITeamRepository repository, List<String> engineList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IBuildEngine> buildEngineList = new ArrayList<IBuildEngine>();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        for (String engineId : engineList) {
            buildEngineList.add(buildClient.getBuildEngine(engineId, monitor));
        }
        return buildEngineList;
    }

    private static List<IBuildEngine> getBuildEnginesFromUuids(ITeamRepository repository, List<String> engineList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IItemManager client = repository.itemManager();
        ArrayList<IBuildEngine> buildEngineList = new ArrayList<IBuildEngine>();
        for (String engineId : engineList) {
            buildEngineList.add((IBuildEngine)client.fetchCompleteItem(IBuildEngine.ITEM_TYPE.createItemHandle(UUID.valueOf((String)engineId), null), 0, monitor));
        }
        return buildEngineList;
    }

    public static IBuildEngineHandle getBuildEngineHandle(ITeamRepository repository, String engineId) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandle(repository, engineId, null, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static IBuildEngineHandle getBuildEngineHandle(ITeamRepository repository, String engineId, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandle(repository, engineId, monitor, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static IBuildEngineHandle getBuildEngineHandle(ITeamRepository repository, String engineId, IDebugger dbg) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandle(repository, engineId, null, dbg);
    }

    public static IBuildEngineHandle getBuildEngineHandle(ITeamRepository repository, String engineId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildEngineHandle result = null;
        result = Verification.isUUID((String)engineId) ? (IBuildEngineHandle)IBuildEngine.ITEM_TYPE.createItemHandle(UUID.valueOf((String)engineId), null) : BuildEngine.getBuildEngineHandleFromId(repository, engineId, monitor, dbg);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    private static IBuildEngineHandle getBuildEngineHandleFromId(ITeamRepository repository, String engineId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildEngineHandle result = null;
        ArrayList handleList = new ArrayList();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        BaseBuildEngineQueryModel.BuildEngineQueryModel queryModel = BaseBuildEngineQueryModel.BuildEngineQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        IPredicate notArchived = queryModel.processArea().archived()._isFalse();
        IPredicate idValue = queryModel.id()._eq(engineId);
        query.filter(notArchived._and(idValue));
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, IQueryService.EMPTY_PARAMETERS, options, monitor);
        if (resultPage.getSize() > 0) {
            handleList.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                handleList.addAll(resultPage.getItemHandles());
            }
        }
        if (handleList.size() == 1) {
            result = (IBuildEngineHandle)handleList.get(0);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandles(repository, null, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandles(repository, monitor, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IDebugger dbg) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandles(repository, null, dbg);
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IBuildEngineHandle> buildEngineHandleList = new ArrayList<IBuildEngineHandle>();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        BaseBuildEngineQueryModel.BuildEngineQueryModel queryModel = BaseBuildEngineQueryModel.BuildEngineQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        IPredicate notArchived = queryModel.processArea().archived()._isFalse();
        query.filter(notArchived);
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, IQueryService.EMPTY_PARAMETERS, options, monitor);
        if (resultPage.getSize() > 0) {
            buildEngineHandleList.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                buildEngineHandleList.addAll(resultPage.getItemHandles());
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(buildEngineHandleList)});
        }
        return buildEngineHandleList;
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IBuildDefinitionHandle definitionHandle) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandles(repository, definitionHandle, null, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandles(repository, definitionHandle, monitor, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IDebugger dbg) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandles(repository, definitionHandle, null, dbg);
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IBuildEngineHandle> buildEngineHandleList = new ArrayList<IBuildEngineHandle>();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        BaseBuildEngineQueryModel.BuildEngineQueryModel queryModel = BaseBuildEngineQueryModel.BuildEngineQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        IPredicate build = queryModel.supportedBuildDefinitions()._contains((IItemHandle)definitionHandle);
        IPredicate notArchived = queryModel.processArea().archived()._isFalse();
        query.filter(build._and(notArchived));
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, IQueryService.EMPTY_PARAMETERS, options, monitor);
        if (resultPage.getSize() > 0) {
            buildEngineHandleList.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                buildEngineHandleList.addAll(resultPage.getItemHandles());
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(buildEngineHandleList)});
        }
        return buildEngineHandleList;
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IProcessAreaHandle processArea) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandles(repository, processArea, null, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandles(repository, processArea, monitor, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IProcessAreaHandle processArea, IDebugger dbg) throws TeamRepositoryException {
        return BuildEngine.getBuildEngineHandles(repository, processArea, null, dbg);
    }

    public static List<IBuildEngineHandle> getBuildEngineHandles(ITeamRepository repository, IProcessAreaHandle processArea, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IBuildEngineHandle> buildEngineHandleList = new ArrayList<IBuildEngineHandle>();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        BaseBuildEngineQueryModel.BuildEngineQueryModel queryModel = BaseBuildEngineQueryModel.BuildEngineQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        IPredicate area = queryModel.processArea()._eq((IItemHandle)processArea);
        query.filter(area);
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, IQueryService.EMPTY_PARAMETERS, options, monitor);
        if (resultPage.getSize() > 0) {
            buildEngineHandleList.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                buildEngineHandleList.addAll(resultPage.getItemHandles());
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(buildEngineHandleList)});
        }
        return buildEngineHandleList;
    }

    public static String getMessageBinding(IBuildEngine buildEngine) {
        return BuildEngine.getMessageBinding(buildEngine, (IDebugger)new Debugger(BuildEngine.class));
    }

    public static String getMessageBinding(IBuildEngine buildEngine, IDebugger dbg) {
        String result = "";
        try {
            result = buildEngine == null ? "null" : (buildEngine.getId() != null ? buildEngine.getId() : (buildEngine.getItemId() != null ? buildEngine.getItemId().getUuidValue() : "null"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildEngine)});
        }
        return result;
    }

    public void log(IBuildEngine buildEngine) throws TeamRepositoryException {
        this.log(buildEngine, (IDebugger)new Debugger(BuildEngine.class));
    }

    public void log(IBuildEngine buildEngine, IDebugger dbg) throws TeamRepositoryException {
        StringBuilder display = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        if (buildEngine == null) {
            display.append(newLine);
            display.append("IBuildEngine: null");
        } else {
            try {
                display.append(newLine);
                display.append("IBuildEngine: " + LogString.valueOf((String)buildEngine.getId()) + newLine);
                display.append("  getContextId:                 " + LogString.valueOf((UUID)buildEngine.getContextId()) + newLine);
                display.append("  getDescription:               " + LogString.valueOf((String)buildEngine.getDescription()) + newLine);
                display.append("  getFullState:                 " + LogString.valueOf((IItem)buildEngine.getFullState()) + newLine);
                display.append("  getId:                        " + LogString.valueOf((String)buildEngine.getId()) + newLine);
                display.append("  getItemHandle:                " + LogString.valueOf((IItemHandle)buildEngine.getItemHandle()) + newLine);
                display.append("  getItemId:                    " + LogString.valueOf((UUID)buildEngine.getItemId()) + newLine);
                display.append("  getItemType:                  " + LogString.valueOf((Object)buildEngine.getItemType()) + newLine);
                display.append("  getMergePredecessorState:     " + LogString.valueOf((IItemHandle)buildEngine.getMergePredecessorState()) + newLine);
                display.append("  getModifiedBy:                " + LogString.valueOf((IItemHandle)buildEngine.getModifiedBy()) + newLine);
                display.append("  getMonitoringThreshold:       " + LogString.valueOf((int)buildEngine.getMonitoringThreshold()) + newLine);
                display.append("  getOrigin:                    " + LogString.valueOf((Object)buildEngine.getOrigin()) + newLine);
                display.append("  getPredecessorState:          " + LogString.valueOf((IItemHandle)buildEngine.getPredecessorState()) + newLine);
                display.append("  getProcessArea:               " + LogString.valueOf((IItemHandle)buildEngine.getProcessArea()) + newLine);
                display.append("  getProperties:                " + LogString.valueOf((List)buildEngine.getProperties()) + newLine);
                display.append("  getRequestedModified:         " + LogString.valueOf((Date)buildEngine.getRequestedModified()) + newLine);
                display.append("  getRequestedStateId:          " + LogString.valueOf((UUID)buildEngine.getRequestedStateId()) + newLine);
                display.append("  getStateHandle:               " + LogString.valueOf((IItemHandle)buildEngine.getStateHandle()) + newLine);
                display.append("  getStateId:                   " + LogString.valueOf((UUID)buildEngine.getStateId()) + newLine);
                display.append("  hasFullState:                 " + LogString.valueOf((boolean)buildEngine.hasFullState()) + newLine);
                display.append("  hasHistory:                   " + LogString.valueOf((boolean)buildEngine.hasHistory()) + newLine);
                display.append("  hasStateId:                   " + LogString.valueOf((boolean)buildEngine.hasStateId()) + newLine);
                display.append("  hashCode:                     " + LogString.valueOf((int)buildEngine.hashCode()) + newLine);
                display.append("  isActive:                     " + LogString.valueOf((boolean)buildEngine.isActive()) + newLine);
                display.append("  isAuditable:                  " + LogString.valueOf((boolean)buildEngine.isAuditable()) + newLine);
                display.append("  isComplete:                   " + LogString.valueOf((boolean)buildEngine.isComplete()) + newLine);
                display.append("  isConfigurationAware:         " + LogString.valueOf((boolean)buildEngine.isConfigurationAware()) + newLine);
                display.append("  isImmutable:                  " + LogString.valueOf((boolean)buildEngine.isImmutable()) + newLine);
                display.append("  isNewItem:                    " + LogString.valueOf((boolean)buildEngine.isNewItem()) + newLine);
                display.append("  isRedactedCopy:               " + LogString.valueOf((boolean)buildEngine.isRedactedCopy()) + newLine);
                display.append("  isRequestProcessingEnabled:   " + LogString.valueOf((boolean)buildEngine.isRequestProcessingEnabled()) + newLine);
                display.append("  isSimple:                     " + LogString.valueOf((boolean)buildEngine.isSimple()) + newLine);
                display.append("  isThresholdMonitoringEnabled: " + LogString.valueOf((boolean)buildEngine.isThresholdMonitoringEnabled()) + newLine);
                display.append("  isUnmanaged:                  " + LogString.valueOf((boolean)buildEngine.isUnmanaged()) + newLine);
                display.append("  isWorkingCopy:                " + LogString.valueOf((boolean)buildEngine.isWorkingCopy()) + newLine);
                display.append("  modified:                     " + LogString.valueOf((Date)buildEngine.modified()) + newLine);
                display.append("  size:                         " + LogString.valueOf((long)buildEngine.size()) + newLine);
            }
            catch (Exception e) {
                dbg.log(e.toString());
            }
        }
        dbg.log(display.toString());
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildEngine)});
        }
    }
}

