/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client.util;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildDefinition {
    private static final String className = BuildDefinition.class.getSimpleName();

    public static void deleteBuildDefinition(ITeamRepository repository, IBuildDefinitionHandle definitionHandle) throws TeamRepositoryException {
        BuildDefinition.deleteBuildDefinition(repository, definitionHandle, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static void deleteBuildDefinition(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        BuildDefinition.deleteBuildDefinition(repository, definitionHandle, monitor, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static void deleteBuildDefinition(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IDebugger dbg) throws TeamRepositoryException {
        BuildDefinition.deleteBuildDefinition(repository, definitionHandle, null, dbg);
    }

    public static void deleteBuildDefinition(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        String itemUuid = LogString.valueOf((IItemHandle)definitionHandle);
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        buildClient.delete(definitionHandle, monitor);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), itemUuid});
        }
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, IBuildResult buildResult) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinition(repository, buildResult, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinition(repository, buildResult, monitor, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, IBuildResult buildResult, IDebugger dbg) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinition(repository, buildResult, null, dbg);
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, IBuildResult buildResult, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildDefinition buildDefinition = (IBuildDefinition)repository.itemManager().fetchCompleteItem((IItemHandle)buildResult.getBuildDefinition(), 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildDefinition)});
        }
        return buildDefinition;
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, String buildId) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinition(repository, buildId, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, String buildId, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinition(repository, buildId, monitor, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, String buildId, IDebugger dbg) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinition(repository, buildId, null, dbg);
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, String buildId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildDefinition buildDefinition = null;
        if (Verification.isUUID((String)buildId)) {
            IItemManager client = repository.itemManager();
            buildDefinition = (IBuildDefinition)client.fetchCompleteItem(IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildId), null), 0, monitor);
        } else {
            ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
            buildDefinition = buildClient.getBuildDefinition(buildId, monitor);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildDefinition)});
        }
        return buildDefinition;
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, IBuildDefinitionHandle definitionHandle) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinition(repository, definitionHandle, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinition(repository, definitionHandle, monitor, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IDebugger dbg) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinition(repository, definitionHandle, null, dbg);
    }

    public static IBuildDefinition getBuildDefinition(ITeamRepository repository, IBuildDefinitionHandle definitionHandle, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildDefinition buildDefinition = (IBuildDefinition)repository.itemManager().fetchCompleteItem((IItemHandle)definitionHandle, 0, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)buildDefinition)});
        }
        return buildDefinition;
    }

    public static List<IBuildDefinition> getBuildDefinitions(ITeamRepository repository, List<?> definitionList) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitions(repository, definitionList, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinition> getBuildDefinitions(ITeamRepository repository, List<?> definitionList, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitions(repository, definitionList, monitor, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinition> getBuildDefinitions(ITeamRepository repository, List<?> definitionList, IDebugger dbg) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitions(repository, definitionList, null, dbg);
    }

    public static List<IBuildDefinition> getBuildDefinitions(ITeamRepository repository, List<?> definitionList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List<IBuildDefinition> buildDefinitionList = new ArrayList<IBuildDefinition>();
        if (definitionList != null && definitionList.size() > 0) {
            if (definitionList.get(0) instanceof IBuildDefinitionHandle) {
                buildDefinitionList = BuildDefinition.getBuildDefinitionsFromHandles(repository, definitionList, monitor, dbg);
            } else if (definitionList.get(0) instanceof String) {
                buildDefinitionList = Verification.isUUID((String)((String)definitionList.get(0))) ? BuildDefinition.getBuildDefinitionsFromUuids(repository, definitionList, monitor, dbg) : BuildDefinition.getBuildDefinitionsFromIds(repository, definitionList, monitor, dbg);
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(buildDefinitionList)});
        }
        return buildDefinitionList;
    }

    private static List<IBuildDefinition> getBuildDefinitionsFromHandles(ITeamRepository repository, List<IBuildDefinitionHandle> definitionList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List buildDefinitionList = repository.itemManager().fetchCompleteItems(definitionList, 0, monitor);
        return buildDefinitionList;
    }

    private static List<IBuildDefinition> getBuildDefinitionsFromIds(ITeamRepository repository, List<String> definitionList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ArrayList<IBuildDefinition> buildDefinitionList = new ArrayList<IBuildDefinition>();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        for (String definitionId : definitionList) {
            buildDefinitionList.add(buildClient.getBuildDefinition(definitionId, monitor));
        }
        return buildDefinitionList;
    }

    private static List<IBuildDefinition> getBuildDefinitionsFromUuids(ITeamRepository repository, List<String> definitionList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IItemManager client = repository.itemManager();
        ArrayList<IBuildDefinition> buildDefinitionList = new ArrayList<IBuildDefinition>();
        for (String definitionId : definitionList) {
            buildDefinitionList.add((IBuildDefinition)client.fetchCompleteItem(IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)definitionId), null), 0, monitor));
        }
        return buildDefinitionList;
    }

    public static List<IBuildDefinition> getBuildDefinitions(ITeamRepository repository, List<IBuildDefinitionHandle> definitionList, List<String> requiredList) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitions(repository, definitionList, requiredList, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinition> getBuildDefinitions(ITeamRepository repository, List<IBuildDefinitionHandle> definitionList, List<String> requiredList, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitions(repository, definitionList, requiredList, monitor, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinition> getBuildDefinitions(ITeamRepository repository, List<IBuildDefinitionHandle> definitionList, List<String> requiredList, IDebugger dbg) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitions(repository, definitionList, requiredList, null, dbg);
    }

    public static List<IBuildDefinition> getBuildDefinitions(ITeamRepository repository, List<IBuildDefinitionHandle> definitionList, List<String> requiredList, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        List buildDefinitionList = repository.itemManager().fetchPartialItems(definitionList, 0, requiredList, monitor);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((List)buildDefinitionList)});
        }
        return buildDefinitionList;
    }

    public static IBuildDefinitionHandle getBuildDefinitionHandle(ITeamRepository repository, String definitionId) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandle(repository, definitionId, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static IBuildDefinitionHandle getBuildDefinitionHandle(ITeamRepository repository, String definitionId, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandle(repository, definitionId, monitor, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static IBuildDefinitionHandle getBuildDefinitionHandle(ITeamRepository repository, String definitionId, IDebugger dbg) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandle(repository, definitionId, null, dbg);
    }

    public static IBuildDefinitionHandle getBuildDefinitionHandle(ITeamRepository repository, String definitionId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildDefinitionHandle result = Verification.isUUID((String)definitionId) ? (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)definitionId), null) : BuildDefinition.getBuildDefinitionHandleFromId(repository, definitionId, monitor, dbg);
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    private static IBuildDefinitionHandle getBuildDefinitionHandleFromId(ITeamRepository repository, String definitionId, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IBuildDefinitionHandle result = null;
        ArrayList handleList = new ArrayList();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel queryModel = BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        IPredicate notArchived = queryModel.processArea().archived()._isFalse();
        IPredicate idValue = queryModel.id()._eq(definitionId);
        query.filter(notArchived._and(idValue));
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, IQueryService.EMPTY_PARAMETERS, options, monitor);
        if (resultPage.getSize() > 0) {
            handleList.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                handleList.addAll(resultPage.getItemHandles());
            }
        }
        if (handleList.size() == 1) {
            result = (IBuildDefinitionHandle)handleList.get(0);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)result)});
        }
        return result;
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandles(repository, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandles(repository, monitor, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IDebugger dbg) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandles(repository, null, dbg);
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IBuildDefinitionHandle> buildDefinitionHandleList = new ArrayList<IBuildDefinitionHandle>();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel queryModel = BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        IPredicate notArchived = queryModel.processArea().archived()._isFalse();
        query.filter(notArchived);
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, IQueryService.EMPTY_PARAMETERS, options, monitor);
        if (resultPage.getSize() > 0) {
            buildDefinitionHandleList.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                buildDefinitionHandleList.addAll(resultPage.getItemHandles());
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(buildDefinitionHandleList)});
        }
        return buildDefinitionHandleList;
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IProcessAreaHandle processArea) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandles(repository, processArea, false, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandles(repository, processArea, false, monitor, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IProcessAreaHandle processArea, IDebugger dbg) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandles(repository, processArea, false, null, dbg);
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IProcessAreaHandle processArea, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandles(repository, processArea, false, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IProcessAreaHandle processArea, boolean archived) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandles(repository, processArea, archived, null, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IProcessAreaHandle processArea, boolean archived, IProgressMonitor monitor) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandles(repository, processArea, archived, monitor, (IDebugger)new Debugger(BuildDefinition.class));
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IProcessAreaHandle processArea, boolean archived, IDebugger dbg) throws TeamRepositoryException {
        return BuildDefinition.getBuildDefinitionHandles(repository, processArea, archived, null, dbg);
    }

    public static List<IBuildDefinitionHandle> getBuildDefinitionHandles(ITeamRepository repository, IProcessAreaHandle processArea, boolean archived, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IPredicate area;
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IBuildDefinitionHandle> buildDefinitionHandleList = new ArrayList<IBuildDefinitionHandle>();
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel queryModel = BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        if (!archived) {
            area = queryModel.processArea()._eq((IItemHandle)processArea);
            IPredicate arch = queryModel.processArea().archived()._isFalse();
            query.filter(area._and(arch));
        } else {
            area = queryModel.processArea()._eq((IItemHandle)processArea);
            query.filter(area);
        }
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, IQueryService.EMPTY_PARAMETERS, options, monitor);
        if (resultPage.getSize() > 0) {
            buildDefinitionHandleList.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                buildDefinitionHandleList.addAll(resultPage.getItemHandles());
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(buildDefinitionHandleList)});
        }
        return buildDefinitionHandleList;
    }
}

