/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.extensions.client.BuildCacheFactory;
import com.ibm.team.build.extensions.common.IFetchItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildItemFetch
implements IFetchItem {
    private final IDebugger dbg;
    private final String simpleName;
    private final ITeamRepository repository;
    private final IProgressMonitor monitor;
    private final IProjectAreaHandle projectArea;
    private final boolean fetch;
    private final List<IItemHandle> itemsToFetch = new ArrayList<IItemHandle>();

    public BuildItemFetch(ITeamRepository repository, IProjectAreaHandle projectArea, IProgressMonitor monitor, String dialog, boolean fetch) {
        this.repository = repository;
        this.projectArea = projectArea;
        this.monitor = monitor;
        this.fetch = fetch;
        this.dbg = new Debugger(this.getClass());
        this.simpleName = this.getClass().getSimpleName();
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public final IItem execute(IItemHandle handle) {
        if (handle == null) {
            return null;
        }
        IItem item = null;
        String uuid = handle.getItemId().getUuidValue();
        if (handle instanceof IBuildDefinitionHandle) {
            if (BuildCacheFactory.containsBuildDefinition(this.repository, (IProcessAreaHandle)this.projectArea) && BuildCacheFactory.getBuildDefinition(this.repository, (IProcessAreaHandle)this.projectArea).containsUuid(uuid)) {
                item = (IItem)BuildCacheFactory.getBuildDefinition(this.repository, (IProcessAreaHandle)this.projectArea).getUuid(uuid);
            }
        } else if (handle instanceof IBuildEngineHandle && BuildCacheFactory.containsBuildEngine(this.repository, (IProcessAreaHandle)this.projectArea) && BuildCacheFactory.getBuildEngine(this.repository, (IProcessAreaHandle)this.projectArea).containsUuid(uuid)) {
            item = (IItem)BuildCacheFactory.getBuildEngine(this.repository, (IProcessAreaHandle)this.projectArea).getUuid(uuid);
        }
        if (item == null && this.fetch) {
            try {
                item = this.repository.itemManager().fetchCompleteItem(handle, 0, this.monitor);
                if (item != null) {
                    if (item instanceof IBuildDefinition) {
                        BuildCacheFactory.addBuildDefinition(this.repository, (IProcessAreaHandle)this.projectArea, (IBuildDefinition)item);
                    } else if (item instanceof IBuildEngine) {
                        BuildCacheFactory.addBuildEngine(this.repository, (IProcessAreaHandle)this.projectArea, (IBuildEngine)item);
                    }
                }
            }
            catch (TeamRepositoryException e) {
                throw new RuntimeException(NLS.bind((String)Common.COMMON_BUILDITEMFETCH_FAILED_ITEM, (Object)LogField.valueOf((IItemHandle)handle), (Object[])new Object[0]), e);
            }
        }
        if (item == null && !this.fetch) {
            this.itemsToFetch.add(handle);
        }
        return item;
    }

    public final void fetchItems(IProgressMonitor monitor) {
        try {
            List items = this.repository.itemManager().fetchCompleteItems(this.itemsToFetch, 0, monitor);
            for (IItem item : items) {
                if (item == null) continue;
                if (item instanceof IBuildDefinition) {
                    BuildCacheFactory.addBuildDefinition(this.repository, (IProcessAreaHandle)this.projectArea, (IBuildDefinition)item);
                    continue;
                }
                if (!(item instanceof IBuildEngine)) continue;
                BuildCacheFactory.addBuildEngine(this.repository, (IProcessAreaHandle)this.projectArea, (IBuildEngine)item);
            }
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(NLS.bind((String)Common.COMMON_BUILDITEMFETCH_FAILED_ITEMS, (Object)LogField.valueOf(this.itemsToFetch), (Object[])new Object[0]), e);
        }
    }

    public final boolean hasItemsToFetch() {
        return Verification.isNonEmpty(this.itemsToFetch);
    }
}

