/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.extensions.client.BuildCacheItemWorkspaceHandle;
import com.ibm.team.build.extensions.client.util.SCMWorkspace;
import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.IBuildCacheLoadExecute;
import com.ibm.team.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildCacheLoadWorkspaceHandle
implements IBuildCacheLoad,
IBuildCacheLoadExecute<IWorkspaceHandle>,
Callable<IBuildCacheLoad> {
    private final BuildCacheItemWorkspaceHandle buildCacheItem;
    private final ITeamRepository repository;
    private final IProcessAreaHandle processArea;
    private final String processAreaId;
    private final IBuildCachePlatform.Platform platform;
    private final IWorkspace item;
    private final List<IWorkspace> items;
    private final IWorkspaceHandle itemHandle;
    private final List<IWorkspaceHandle> itemHandles;
    private final String itemString;
    private final List<String> itemStrings;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<IWorkspaceHandle> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public BuildCacheLoadWorkspaceHandle(ITeamRepository repository, BuildCacheItemWorkspaceHandle buildCacheItem, IWorkspace item, List<IWorkspace> items, IWorkspaceHandle itemHandle, List<IWorkspaceHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this(repository, null, IBuildCachePlatform.Platform.none, buildCacheItem, item, items, itemHandle, itemHandles, itemString, itemStrings, dbg);
    }

    public BuildCacheLoadWorkspaceHandle(ITeamRepository repository, IProcessAreaHandle processArea, IBuildCachePlatform.Platform platform, BuildCacheItemWorkspaceHandle buildCacheItem, IWorkspace item, List<IWorkspace> items, IWorkspaceHandle itemHandle, List<IWorkspaceHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this.repository = repository;
        this.processArea = processArea;
        this.processAreaId = processArea == null ? null : processArea.getItemId().getUuidValue();
        this.platform = platform;
        this.buildCacheItem = buildCacheItem;
        this.item = item;
        this.items = items;
        this.itemHandle = itemHandle;
        this.itemHandles = itemHandles;
        this.itemString = itemString;
        this.itemStrings = itemStrings;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    public List<IWorkspaceHandle> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public IBuildCacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.item != null || this.items != null || this.itemHandle != null || this.itemHandles != null || this.itemString != null || this.itemStrings != null) {
            ArrayList<IWorkspaceHandle> itemList = new ArrayList<IWorkspaceHandle>();
            if (this.item != null) {
                itemList.add((IWorkspaceHandle)this.item);
            }
            if (this.items != null) {
                itemList.addAll(this.items);
            }
            if (this.itemHandle != null) {
                itemList.add(this.itemHandle);
            }
            if (this.itemHandles != null) {
                itemList.addAll(this.itemHandles);
            }
            if (this.itemString != null) {
                itemList.add(SCMWorkspace.getWorkspaceHandle(this.repository, this.itemString, this.monitor, this.dbg));
            }
            if (this.itemStrings != null) {
                itemList.addAll(SCMWorkspace.getWorkspaceHandles(this.repository, this.itemStrings, this.monitor, this.dbg));
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IWorkspaceHandle> itemMapByName = new HashMap<String, IWorkspaceHandle>();
            HashMap<String, IWorkspaceHandle> itemMapByUuid = new HashMap<String, IWorkspaceHandle>();
            for (IWorkspaceHandle item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = SCMWorkspace.getWorkspaceName(this.repository, item, this.monitor, this.dbg);
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            this.buildCacheItem.setPartial();
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.addAllItemList((List<IWorkspaceHandle>)itemList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.addAllItemMapByName((Map<String, IWorkspaceHandle>)itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.addAllItemMapByUuid((Map<String, IWorkspaceHandle>)itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            IWorkspaceSearchCriteria workspaceSearchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
            List itemList = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository).findWorkspaces(workspaceSearchCriteria, Integer.MAX_VALUE, this.monitor);
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IWorkspaceHandle> itemMapByName = new HashMap<String, IWorkspaceHandle>();
            HashMap<String, IWorkspaceHandle> itemMapByUuid = new HashMap<String, IWorkspaceHandle>();
            for (IWorkspaceHandle item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = SCMWorkspace.getWorkspaceName(this.repository, item, this.monitor, this.dbg);
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            if (this.usage == -1) {
                this.buildCacheItem.setComplete();
            } else {
                this.buildCacheItem.setPartial();
            }
            if (!this.append) {
                this.buildCacheItem.clear();
                this.buildCacheItem.clearPlatformEntry();
                this.buildCacheItem.setUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.setItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.setItemMapByName((Map<String, IWorkspaceHandle>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.setItemMapByUuid((Map<String, IWorkspaceHandle>)itemMapByUuid);
                }
            } else {
                this.buildCacheItem.addUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.addAllItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.addAllItemMapByName((Map<String, IWorkspaceHandle>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.addAllItemMapByUuid((Map<String, IWorkspaceHandle>)itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    public final void setAppend(boolean append) {
        this.append = append;
    }

    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

