/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.extensions.client.BuildCacheItemWorkspace;
import com.ibm.team.build.extensions.client.util.SCMComponent;
import com.ibm.team.build.extensions.client.util.SCMWorkspace;
import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.IBuildCacheLoadExecute;
import com.ibm.team.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.build.extensions.common.IWorkspaceContent;
import com.ibm.team.build.extensions.common.WorkspaceContent;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildCacheLoadWorkspace
implements IBuildCacheLoad,
IBuildCacheLoadExecute<IWorkspaceContent>,
Callable<IBuildCacheLoad> {
    private final BuildCacheItemWorkspace buildCacheItem;
    private final ITeamRepository repository;
    private final IProcessAreaHandle processArea;
    private final String processAreaId;
    private final IBuildCachePlatform.Platform platform;
    private final IWorkspace item;
    private final List<IWorkspace> items;
    private final IWorkspaceHandle itemHandle;
    private final List<IWorkspaceHandle> itemHandles;
    private final String itemString;
    private final List<String> itemStrings;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<IWorkspaceContent> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public BuildCacheLoadWorkspace(ITeamRepository repository, BuildCacheItemWorkspace buildCacheItem, IWorkspace item, List<IWorkspace> items, IWorkspaceHandle itemHandle, List<IWorkspaceHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this(repository, null, IBuildCachePlatform.Platform.none, buildCacheItem, item, items, itemHandle, itemHandles, itemString, itemStrings, dbg);
    }

    public BuildCacheLoadWorkspace(ITeamRepository repository, IProcessAreaHandle processArea, IBuildCachePlatform.Platform platform, BuildCacheItemWorkspace buildCacheItem, IWorkspace item, List<IWorkspace> items, IWorkspaceHandle itemHandle, List<IWorkspaceHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this.repository = repository;
        this.processArea = processArea;
        this.processAreaId = processArea == null ? null : processArea.getItemId().getUuidValue();
        this.platform = platform;
        this.buildCacheItem = buildCacheItem;
        this.item = item;
        this.items = items;
        this.itemHandle = itemHandle;
        this.itemHandles = itemHandles;
        this.itemString = itemString;
        this.itemStrings = itemStrings;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    public List<IWorkspaceContent> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public IBuildCacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.item != null || this.items != null || this.itemHandle != null || this.itemHandles != null || this.itemString != null || this.itemStrings != null) {
            ArrayList<IWorkspace> itemList = new ArrayList<IWorkspace>();
            if (this.item != null) {
                itemList.add(this.item);
            }
            if (this.items != null) {
                itemList.addAll(this.items);
            }
            if (this.itemHandle != null) {
                itemList.add(SCMWorkspace.getWorkspace(this.repository, this.itemHandle, this.monitor, this.dbg));
            }
            if (this.itemHandles != null) {
                itemList.addAll(SCMWorkspace.getWorkspaces(this.repository, this.itemHandles, this.monitor, this.dbg));
            }
            if (this.itemString != null) {
                itemList.add(SCMWorkspace.getWorkspace(this.repository, this.itemString, this.monitor, this.dbg));
            }
            if (this.itemStrings != null) {
                itemList.addAll(SCMWorkspace.getWorkspaces(this.repository, this.itemStrings, this.monitor, this.dbg));
            }
            itemList.removeAll(Collections.singleton(null));
            ArrayList<IWorkspaceContent> contentList = new ArrayList<IWorkspaceContent>();
            HashMap<String, IWorkspaceContent> itemMapByName = new HashMap<String, IWorkspaceContent>();
            HashMap<String, IWorkspaceContent> itemMapByUuid = new HashMap<String, IWorkspaceContent>();
            for (IWorkspace item : itemList) {
                IWorkspaceConnection workspaceConnection = SCMWorkspace.getWorkspaceConnection(this.repository, (IWorkspaceHandle)item.getItemHandle(), this.monitor, this.dbg);
                String workspaceName = item.getName();
                String workspaceUuid = item.getItemId().getUuidValue();
                List<IComponentHandle> componentHandleList = SCMComponent.getComponentByWorkspace(this.repository, workspaceConnection, this.dbg);
                List<IComponent> componentList = SCMComponent.getComponentList(this.repository, componentHandleList, this.monitor, this.dbg);
                HashMap<String, IComponent> componentMapByName = new HashMap<String, IComponent>();
                HashMap<String, IComponent> componentMapByUuid = new HashMap<String, IComponent>();
                for (IComponent component : componentList) {
                    String componentName = component.getName();
                    componentMapByName.put(componentName, component);
                    String componentUuid = component.getItemId().getUuidValue();
                    componentMapByUuid.put(componentUuid, component);
                }
                WorkspaceContent workspaceContent = new WorkspaceContent(item);
                workspaceContent.setWorkspaceName(workspaceName);
                workspaceContent.setWorkspaceUuid(workspaceUuid);
                workspaceContent.setComponentList(componentList);
                workspaceContent.setComponentHandleList(componentHandleList);
                workspaceContent.setComponentMapByName(componentMapByName);
                workspaceContent.setComponentMapByUuid(componentMapByUuid);
                if (this.buildCacheItem.hasItemMapByName()) {
                    itemMapByName.put(workspaceName, (IWorkspaceContent)workspaceContent);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                itemMapByUuid.put(workspaceUuid, (IWorkspaceContent)workspaceContent);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            this.buildCacheItem.setPartial();
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.addAllItemList((List<IWorkspaceContent>)contentList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.addAllItemMapByName((Map<String, IWorkspaceContent>)itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.addAllItemMapByUuid((Map<String, IWorkspaceContent>)itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = contentList;
            }
        } else {
            IWorkspaceSearchCriteria workspaceSearchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
            List itemHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository).findWorkspaces(workspaceSearchCriteria, Integer.MAX_VALUE, this.monitor);
            List<IWorkspace> itemList = SCMWorkspace.getWorkspaces(this.repository, itemHandles, this.monitor, this.dbg);
            ArrayList<IWorkspaceContent> contentList = new ArrayList<IWorkspaceContent>();
            HashMap<String, IWorkspaceContent> itemMapByName = new HashMap<String, IWorkspaceContent>();
            HashMap<String, IWorkspaceContent> itemMapByUuid = new HashMap<String, IWorkspaceContent>();
            for (IWorkspace item : itemList) {
                IWorkspaceConnection workspaceConnection = SCMWorkspace.getWorkspaceConnection(this.repository, (IWorkspaceHandle)item.getItemHandle(), this.monitor, this.dbg);
                String workspaceName = item.getName();
                String workspaceUuid = item.getItemId().getUuidValue();
                List<IComponentHandle> componentHandleList = SCMComponent.getComponentByWorkspace(this.repository, workspaceConnection, this.dbg);
                List<IComponent> componentList = SCMComponent.getComponentList(this.repository, componentHandleList, this.monitor, this.dbg);
                HashMap<String, IComponent> componentMapByName = new HashMap<String, IComponent>();
                HashMap<String, IComponent> componentMapByUuid = new HashMap<String, IComponent>();
                for (IComponent component : componentList) {
                    String componentName = component.getName();
                    componentMapByName.put(componentName, component);
                    String componentUuid = component.getItemId().getUuidValue();
                    componentMapByUuid.put(componentUuid, component);
                }
                WorkspaceContent workspaceContent = new WorkspaceContent(item);
                workspaceContent.setWorkspaceName(workspaceName);
                workspaceContent.setWorkspaceUuid(workspaceUuid);
                workspaceContent.setComponentList(componentList);
                workspaceContent.setComponentHandleList(componentHandleList);
                workspaceContent.setComponentMapByName(componentMapByName);
                workspaceContent.setComponentMapByUuid(componentMapByUuid);
                if (this.buildCacheItem.hasItemMapByName()) {
                    itemMapByName.put(workspaceName, (IWorkspaceContent)workspaceContent);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                itemMapByUuid.put(workspaceUuid, (IWorkspaceContent)workspaceContent);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            if (this.usage == -1) {
                this.buildCacheItem.setComplete();
            } else {
                this.buildCacheItem.setPartial();
            }
            if (!this.append) {
                this.buildCacheItem.clear();
                this.buildCacheItem.clearPlatformEntry();
                this.buildCacheItem.setUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, contentList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.setItemList((List<IWorkspaceContent>)contentList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.setItemMapByName((Map<String, IWorkspaceContent>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.setItemMapByUuid((Map<String, IWorkspaceContent>)itemMapByUuid);
                }
            } else {
                this.buildCacheItem.addUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, contentList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.addAllItemList((List<IWorkspaceContent>)contentList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.addAllItemMapByName((Map<String, IWorkspaceContent>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.addAllItemMapByUuid((Map<String, IWorkspaceContent>)itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = contentList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    public final void setAppend(boolean append) {
        this.append = append;
    }

    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

