/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.extensions.client.BuildCacheItemWorkItem;
import com.ibm.team.build.extensions.client.util.CCMWorkItem;
import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.IBuildCacheLoadExecute;
import com.ibm.team.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildCacheLoadWorkItem
implements IBuildCacheLoad,
IBuildCacheLoadExecute<IWorkItem>,
Callable<IBuildCacheLoad> {
    private final BuildCacheItemWorkItem buildCacheItem;
    private final ITeamRepository repository;
    private final IProcessAreaHandle processArea;
    private final String processAreaId;
    private final IBuildCachePlatform.Platform platform;
    private final IWorkItem item;
    private final List<IWorkItem> items;
    private final IWorkItemHandle itemHandle;
    private final List<IWorkItemHandle> itemHandles;
    private final String itemString;
    private final List<String> itemStrings;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<IWorkItem> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public BuildCacheLoadWorkItem(ITeamRepository repository, BuildCacheItemWorkItem buildCacheItem, IWorkItem item, List<IWorkItem> items, IWorkItemHandle itemHandle, List<IWorkItemHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this(repository, null, IBuildCachePlatform.Platform.none, buildCacheItem, item, items, itemHandle, itemHandles, itemString, itemStrings, dbg);
    }

    public BuildCacheLoadWorkItem(ITeamRepository repository, IProcessAreaHandle processArea, IBuildCachePlatform.Platform platform, BuildCacheItemWorkItem buildCacheItem, IWorkItem item, List<IWorkItem> items, IWorkItemHandle itemHandle, List<IWorkItemHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this.repository = repository;
        this.processArea = processArea;
        this.processAreaId = processArea == null ? null : processArea.getItemId().getUuidValue();
        this.platform = platform;
        this.buildCacheItem = buildCacheItem;
        this.item = item;
        this.items = items;
        this.itemHandle = itemHandle;
        this.itemHandles = itemHandles;
        this.itemString = itemString;
        this.itemStrings = itemStrings;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    public List<IWorkItem> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public IBuildCacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.item != null || this.items != null || this.itemHandle != null || this.itemHandles != null || this.itemString != null || this.itemStrings != null) {
            ArrayList<IWorkItem> itemList = new ArrayList<IWorkItem>();
            if (this.item != null) {
                itemList.add(this.item);
            }
            if (this.items != null) {
                itemList.addAll(this.items);
            }
            if (this.itemHandle != null) {
                itemList.add(CCMWorkItem.getWorkItem(this.repository, this.itemHandle, this.monitor, this.dbg));
            }
            if (this.itemHandles != null) {
                itemList.addAll(CCMWorkItem.getWorkItems(this.repository, this.itemHandles, this.monitor, this.dbg));
            }
            if (this.itemString != null) {
                itemList.add(CCMWorkItem.getWorkItem(this.repository, this.itemString, this.monitor, this.dbg));
            }
            if (this.itemStrings != null) {
                itemList.addAll(CCMWorkItem.getWorkItems(this.repository, this.itemStrings, this.monitor, this.dbg));
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IWorkItem> itemMapByName = new HashMap<String, IWorkItem>();
            HashMap<String, IWorkItem> itemMapByUuid = new HashMap<String, IWorkItem>();
            for (IWorkItem item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = Integer.toString(item.getId());
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            this.buildCacheItem.setPartial();
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.addAllItemList((List<IWorkItem>)itemList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.addAllItemMapByName((Map<String, IWorkItem>)itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.addAllItemMapByUuid((Map<String, IWorkItem>)itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            List<IWorkItemHandle> itemHandles = this.processArea == null ? CCMWorkItem.getWorkItemHandles(this.repository, this.monitor, this.dbg) : CCMWorkItem.getWorkItemHandles(this.repository, this.processArea, this.monitor, this.dbg);
            List<IWorkItem> itemList = CCMWorkItem.getWorkItems(this.repository, itemHandles, this.monitor, this.dbg);
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IWorkItem> itemMapByName = new HashMap<String, IWorkItem>();
            HashMap<String, IWorkItem> itemMapByUuid = new HashMap<String, IWorkItem>();
            for (IWorkItem item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = Integer.toString(item.getId());
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            if (this.usage == -1) {
                this.buildCacheItem.setComplete();
            } else {
                this.buildCacheItem.setPartial();
            }
            if (!this.append) {
                this.buildCacheItem.clear();
                this.buildCacheItem.clearPlatformEntry();
                this.buildCacheItem.setUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.setItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.setItemMapByName((Map<String, IWorkItem>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.setItemMapByUuid((Map<String, IWorkItem>)itemMapByUuid);
                }
            } else {
                this.buildCacheItem.addUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.addAllItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.addAllItemMapByName((Map<String, IWorkItem>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.addAllItemMapByUuid((Map<String, IWorkItem>)itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    public final void setAppend(boolean append) {
        this.append = append;
    }

    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

