/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.extensions.client.BuildCacheItemBuildResult;
import com.ibm.team.build.extensions.client.util.BuildResult;
import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.IBuildCacheLoadExecute;
import com.ibm.team.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildCacheLoadBuildResult
implements IBuildCacheLoad,
IBuildCacheLoadExecute<IBuildResult>,
Callable<IBuildCacheLoad> {
    private final BuildCacheItemBuildResult buildCacheItem;
    private final ITeamRepository repository;
    private final IProcessAreaHandle processArea;
    private final String processAreaId;
    private final IBuildDefinition buildDefinition;
    private final String buildDefinitionId;
    private final IBuildCachePlatform.Platform platform;
    private final IBuildResult item;
    private final List<IBuildResult> items;
    private final IBuildResultHandle itemHandle;
    private final List<IBuildResultHandle> itemHandles;
    private final String itemString;
    private final List<String> itemStrings;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<IBuildResult> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public BuildCacheLoadBuildResult(ITeamRepository repository, IBuildDefinition buildDefinition, BuildCacheItemBuildResult buildCacheItem, IBuildResult item, List<IBuildResult> items, IBuildResultHandle itemHandle, List<IBuildResultHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this(repository, null, IBuildCachePlatform.Platform.none, buildDefinition, buildCacheItem, item, items, itemHandle, itemHandles, itemString, itemStrings, dbg);
    }

    public BuildCacheLoadBuildResult(ITeamRepository repository, IProcessAreaHandle processArea, IBuildCachePlatform.Platform platform, IBuildDefinition buildDefinition, BuildCacheItemBuildResult buildCacheItem, IBuildResult item, List<IBuildResult> items, IBuildResultHandle itemHandle, List<IBuildResultHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this.repository = repository;
        this.processArea = processArea;
        this.processAreaId = processArea == null ? null : processArea.getItemId().getUuidValue();
        this.buildDefinition = buildDefinition;
        this.buildDefinitionId = buildDefinition.getItemId().getUuidValue();
        this.platform = platform;
        this.buildCacheItem = buildCacheItem;
        this.item = item;
        this.items = items;
        this.itemHandle = itemHandle;
        this.itemHandles = itemHandles;
        this.itemString = itemString;
        this.itemStrings = itemStrings;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    public List<IBuildResult> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public IBuildCacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.item != null || this.items != null || this.itemHandle != null || this.itemHandles != null || this.itemString != null || this.itemStrings != null) {
            ArrayList<IBuildResult> itemList = new ArrayList<IBuildResult>();
            if (this.item != null) {
                itemList.add(this.item);
            }
            if (this.items != null) {
                itemList.addAll(this.items);
            }
            if (this.itemHandle != null) {
                itemList.add(BuildResult.getBuildResult(this.repository, this.itemHandle, this.monitor, this.dbg));
            }
            if (this.itemHandles != null) {
                itemList.addAll(BuildResult.getBuildResults(this.repository, this.itemHandles, this.monitor, this.dbg));
            }
            if (this.itemString != null) {
                itemList.add(BuildResult.getBuildResult(this.repository, this.itemString, this.monitor, this.dbg));
            }
            if (this.itemStrings != null) {
                itemList.addAll(BuildResult.getBuildResults(this.repository, this.itemStrings, this.monitor, this.dbg));
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildResult> itemMapByName = new HashMap<String, IBuildResult>();
            HashMap<String, IBuildResult> itemMapByUuid = new HashMap<String, IBuildResult>();
            for (IBuildResult item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = item.getLabel();
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle((IItemHandle)this.buildDefinition);
            this.buildCacheItem.setItemHandleId(this.buildDefinitionId);
            this.buildCacheItem.setPartial();
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.addAllItemList((List<IBuildResult>)itemList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.addAllItemMapByName((Map<String, IBuildResult>)itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.addAllItemMapByUuid((Map<String, IBuildResult>)itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            IFetchResult fetchResult = BuildResult.getBuildResults(this.repository, this.buildDefinition, this.monitor, this.dbg);
            List itemList = fetchResult.getRetrievedItems();
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildResult> itemMapByName = new HashMap<String, IBuildResult>();
            HashMap<String, IBuildResult> itemMapByUuid = new HashMap<String, IBuildResult>();
            for (IBuildResult item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = item.getLabel();
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle((IItemHandle)this.buildDefinition);
            this.buildCacheItem.setItemHandleId(this.buildDefinition.getItemId().getUuidValue());
            if (this.usage == -1) {
                this.buildCacheItem.setComplete();
            } else {
                this.buildCacheItem.setPartial();
            }
            if (!this.append) {
                this.buildCacheItem.clear();
                this.buildCacheItem.clearPlatformEntry();
                this.buildCacheItem.setUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.setItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.setItemMapByName((Map<String, IBuildResult>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.setItemMapByUuid((Map<String, IBuildResult>)itemMapByUuid);
                }
            } else {
                this.buildCacheItem.addUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.addAllItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.addAllItemMapByName((Map<String, IBuildResult>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.addAllItemMapByUuid((Map<String, IBuildResult>)itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    public final void setAppend(boolean append) {
        this.append = append;
    }

    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

