/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.extensions.client.BuildCacheItemBuildFolderHandle;
import com.ibm.team.build.extensions.client.util.BuildFolder;
import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.IBuildCacheLoadExecute;
import com.ibm.team.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildCacheLoadBuildFolderHandle
implements IBuildCacheLoad,
IBuildCacheLoadExecute<IBuildFolderHandle>,
Callable<IBuildCacheLoad> {
    private final BuildCacheItemBuildFolderHandle buildCacheItem;
    private final ITeamRepository repository;
    private final IProcessAreaHandle processArea;
    private final String processAreaId;
    private final IBuildCachePlatform.Platform platform;
    private final IBuildFolder item;
    private final List<IBuildFolder> items;
    private final IBuildFolderHandle itemHandle;
    private final List<IBuildFolderHandle> itemHandles;
    private final String itemString;
    private final List<String> itemStrings;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<IBuildFolderHandle> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public BuildCacheLoadBuildFolderHandle(ITeamRepository repository, IProcessAreaHandle processArea, BuildCacheItemBuildFolderHandle buildCacheItem, IBuildFolder item, List<IBuildFolder> items, IBuildFolderHandle itemHandle, List<IBuildFolderHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this(repository, processArea, IBuildCachePlatform.Platform.none, buildCacheItem, item, items, itemHandle, itemHandles, itemString, itemStrings, dbg);
    }

    public BuildCacheLoadBuildFolderHandle(ITeamRepository repository, IProcessAreaHandle processArea, IBuildCachePlatform.Platform platform, BuildCacheItemBuildFolderHandle buildCacheItem, IBuildFolder item, List<IBuildFolder> items, IBuildFolderHandle itemHandle, List<IBuildFolderHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this.repository = repository;
        this.processArea = processArea;
        this.processAreaId = processArea == null ? null : processArea.getItemId().getUuidValue();
        this.platform = platform;
        this.buildCacheItem = buildCacheItem;
        this.item = item;
        this.items = items;
        this.itemHandle = itemHandle;
        this.itemHandles = itemHandles;
        this.itemString = itemString;
        this.itemStrings = itemStrings;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    public List<IBuildFolderHandle> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public IBuildCacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.item != null || this.items != null || this.itemHandle != null || this.itemHandles != null || this.itemString != null || this.itemStrings != null) {
            ArrayList<IBuildFolderHandle> itemList = new ArrayList<IBuildFolderHandle>();
            if (this.item != null) {
                itemList.add((IBuildFolderHandle)this.item);
            }
            if (this.items != null) {
                itemList.addAll(this.items);
            }
            if (this.itemHandle != null) {
                itemList.add(this.itemHandle);
            }
            if (this.itemHandles != null) {
                itemList.addAll(this.itemHandles);
            }
            if (this.itemString != null) {
                itemList.add((IBuildFolderHandle)BuildFolder.getBuildFolder(this.repository, this.buildCacheItem.getProcessArea(), this.itemString, this.monitor, this.dbg));
            }
            if (this.itemStrings != null) {
                itemList.addAll(BuildFolder.getBuildFolders(this.repository, this.buildCacheItem.getProcessArea(), this.itemStrings, this.monitor, this.dbg));
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildFolderHandle> itemMapByName = new HashMap<String, IBuildFolderHandle>();
            HashMap<String, IBuildFolderHandle> itemMapByUuid = new HashMap<String, IBuildFolderHandle>();
            for (IBuildFolderHandle item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = BuildFolder.getFolderPath(this.repository, item, this.monitor, this.dbg);
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            this.buildCacheItem.setPartial();
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.addAllItemList((List<IBuildFolderHandle>)itemList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.addAllItemMapByName((Map<String, IBuildFolderHandle>)itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.addAllItemMapByUuid((Map<String, IBuildFolderHandle>)itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            Map<String, IBuildFolderHandle> folderHandleMap = BuildFolder.findBuildFolders(this.repository, this.processArea, null, "", this.monitor, this.dbg);
            ArrayList<IBuildFolderHandle> itemList = new ArrayList<IBuildFolderHandle>(folderHandleMap.values());
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildFolderHandle> itemMapByName = new HashMap<String, IBuildFolderHandle>();
            HashMap<String, IBuildFolderHandle> itemMapByUuid = new HashMap<String, IBuildFolderHandle>();
            for (Map.Entry<String, IBuildFolderHandle> entry : folderHandleMap.entrySet()) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = entry.getKey();
                    itemMapByName.put(itemName, entry.getValue());
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = entry.getValue().getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, entry.getValue());
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            if (this.usage == -1) {
                this.buildCacheItem.setComplete();
            } else {
                this.buildCacheItem.setPartial();
            }
            if (!this.append) {
                this.buildCacheItem.clear();
                this.buildCacheItem.clearPlatformEntry();
                this.buildCacheItem.setUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.setItemList((List<IBuildFolderHandle>)itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.setItemMapByName((Map<String, IBuildFolderHandle>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.setItemMapByUuid((Map<String, IBuildFolderHandle>)itemMapByUuid);
                }
            } else {
                this.buildCacheItem.addUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.addAllItemList((List<IBuildFolderHandle>)itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.addAllItemMapByName((Map<String, IBuildFolderHandle>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.addAllItemMapByUuid((Map<String, IBuildFolderHandle>)itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    public final void setAppend(boolean append) {
        this.append = append;
    }

    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

