/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.extensions.client.BuildCacheItemBuildFolder;
import com.ibm.team.build.extensions.client.util.BuildFolder;
import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.IBuildCacheLoadExecute;
import com.ibm.team.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.build.extensions.common.ItemArrayList;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildCacheLoadBuildFolder
implements IBuildCacheLoad,
IBuildCacheLoadExecute<IBuildFolder>,
Callable<IBuildCacheLoad> {
    private final BuildCacheItemBuildFolder buildCacheItem;
    private final ITeamRepository repository;
    private final IProcessAreaHandle processArea;
    private final String processAreaId;
    private final IBuildCachePlatform.Platform platform;
    private final IBuildFolder item;
    private final List<IBuildFolder> items;
    private final IBuildFolderHandle itemHandle;
    private final List<IBuildFolderHandle> itemHandles;
    private final String itemString;
    private final List<String> itemStrings;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<IBuildFolder> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public BuildCacheLoadBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, BuildCacheItemBuildFolder buildCacheItem, IBuildFolder item, List<IBuildFolder> items, IBuildFolderHandle itemHandle, List<IBuildFolderHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this(repository, processArea, IBuildCachePlatform.Platform.none, buildCacheItem, item, items, itemHandle, itemHandles, itemString, itemStrings, dbg);
    }

    public BuildCacheLoadBuildFolder(ITeamRepository repository, IProcessAreaHandle processArea, IBuildCachePlatform.Platform platform, BuildCacheItemBuildFolder buildCacheItem, IBuildFolder item, List<IBuildFolder> items, IBuildFolderHandle itemHandle, List<IBuildFolderHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this.repository = repository;
        this.processArea = processArea;
        this.processAreaId = processArea == null ? null : processArea.getItemId().getUuidValue();
        this.platform = platform;
        this.buildCacheItem = buildCacheItem;
        this.item = item;
        this.items = items;
        this.itemHandle = itemHandle;
        this.itemHandles = itemHandles;
        this.itemString = itemString;
        this.itemStrings = itemStrings;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    public List<IBuildFolder> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public IBuildCacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.item != null || this.items != null || this.itemHandle != null || this.itemHandles != null || this.itemString != null || this.itemStrings != null) {
            ArrayList<IBuildFolder> itemList = new ArrayList<IBuildFolder>();
            if (this.item != null) {
                itemList.add(this.item);
            }
            if (this.items != null) {
                itemList.addAll(this.items);
            }
            if (this.itemHandle != null) {
                itemList.add(BuildFolder.getBuildFolder(this.repository, this.itemHandle, this.monitor, this.dbg));
            }
            if (this.itemHandles != null) {
                itemList.addAll(BuildFolder.getBuildFolders(this.repository, this.itemHandles, this.monitor, this.dbg));
            }
            if (this.itemString != null) {
                itemList.add(BuildFolder.getBuildFolder(this.repository, this.buildCacheItem.getProcessArea(), this.itemString, this.monitor, this.dbg));
            }
            if (this.itemStrings != null) {
                itemList.addAll(BuildFolder.getBuildFolders(this.repository, this.buildCacheItem.getProcessArea(), this.itemStrings, this.monitor, this.dbg));
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildFolder> itemMapByName = new HashMap<String, IBuildFolder>();
            HashMap<String, IBuildFolder> itemMapByUuid = new HashMap<String, IBuildFolder>();
            for (IBuildFolder item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = BuildFolder.getFolderPath(this.repository, (IBuildFolderHandle)item, this.monitor, this.dbg);
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            this.buildCacheItem.setPartial();
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.addAllItemList((List<IBuildFolder>)itemList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.addAllItemMapByName((Map<String, IBuildFolder>)itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.addAllItemMapByUuid((Map<String, IBuildFolder>)itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            Map<String, IBuildFolderHandle> folderHandleMap = BuildFolder.findBuildFolders(this.repository, this.processArea, null, "", this.monitor, this.dbg);
            ItemArrayList itemList = new ItemArrayList(BuildFolder.getBuildFolders(this.repository, new ArrayList<IBuildFolderHandle>(folderHandleMap.values()), this.monitor, this.dbg));
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildFolder> itemMapByName = new HashMap<String, IBuildFolder>();
            HashMap<String, IBuildFolder> itemMapByUuid = new HashMap<String, IBuildFolder>();
            for (Map.Entry<String, IBuildFolderHandle> entry : folderHandleMap.entrySet()) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = entry.getKey();
                    itemMapByName.put(itemName, (IBuildFolder)itemList.get((IItemHandle)entry.getValue()));
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = ((IBuildFolder)itemList.get((IItemHandle)entry.getValue())).getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, (IBuildFolder)itemList.get((IItemHandle)entry.getValue()));
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            if (this.usage == -1) {
                this.buildCacheItem.setComplete();
            } else {
                this.buildCacheItem.setPartial();
            }
            if (!this.append) {
                this.buildCacheItem.clear();
                this.buildCacheItem.clearPlatformEntry();
                this.buildCacheItem.setUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, (List<IBuildFolder>)itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.setItemList((List<IBuildFolder>)itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.setItemMapByName((Map<String, IBuildFolder>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.setItemMapByUuid((Map<String, IBuildFolder>)itemMapByUuid);
                }
            } else {
                this.buildCacheItem.addUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, (List<IBuildFolder>)itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.addAllItemList((List<IBuildFolder>)itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.addAllItemMapByName((Map<String, IBuildFolder>)itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.addAllItemMapByUuid((Map<String, IBuildFolder>)itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    public final void setAppend(boolean append) {
        this.append = append;
    }

    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

