/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class BuildCacheLoad {
    private static volatile BuildCacheLoad instance;
    private ExecutorService executor;
    private ExecutorCompletionService<IBuildCacheLoad> requests;
    private Integer requestThreadMax = 16;
    private Long requestTimeoutInt = 8000L;
    private final List<IBuildCacheLoad> requestsList = new ArrayList<IBuildCacheLoad>();
    private final List<IBuildCacheLoad> completeList = new ArrayList<IBuildCacheLoad>();

    private BuildCacheLoad() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BuildCacheLoad getInstance() {
        if (instance != null) return instance;
        Class<BuildCacheLoad> clazz = BuildCacheLoad.class;
        synchronized (BuildCacheLoad.class) {
            if (instance != null) return instance;
            instance = new BuildCacheLoad();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        BuildCacheLoad buildCacheLoad = this;
        synchronized (buildCacheLoad) {
            if (this.executor == null) {
                this.executor = Executors.newFixedThreadPool(this.requestThreadMax);
                this.requests = new ExecutorCompletionService(this.executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void term() {
        BuildCacheLoad buildCacheLoad = this;
        synchronized (buildCacheLoad) {
            if (this.executor != null) {
                this.executor.shutdownNow();
                this.completeList.clear();
                this.requestsList.clear();
                this.requests = null;
                this.executor = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(IBuildCacheLoad request) throws TeamRepositoryException {
        Class<BuildCacheLoad> clazz = BuildCacheLoad.class;
        synchronized (BuildCacheLoad.class) {
            this.init();
            if (this.requests == null) {
                throw new TeamRepositoryException(Common.COMMON_BUILDCACHELOAD_FAILED);
            }
            this.requestsList.add(request);
            this.requests.submit((Callable)request);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loaded() throws TeamRepositoryException {
        Class<BuildCacheLoad> clazz = BuildCacheLoad.class;
        synchronized (BuildCacheLoad.class) {
            if (this.requests != null) {
                try {
                    while (!this.completeList.containsAll(this.requestsList)) {
                        Future<IBuildCacheLoad> future = this.requests.poll(this.requestTimeoutInt, TimeUnit.MILLISECONDS);
                        if (future == null) {
                            this.term();
                            throw new TeamRepositoryException(Common.COMMON_BUILDCACHELOAD_TIMEOUT);
                        }
                        this.completeList.add(future.get());
                    }
                }
                catch (InterruptedException e) {
                    this.term();
                    throw new TeamRepositoryException(Common.COMMON_BUILDCACHELOAD_EXCPINT, (Throwable)e);
                }
                catch (ExecutionException e) {
                    this.term();
                    throw new TeamRepositoryException(Common.COMMON_BUILDCACHELOAD_EXCPEXC, (Throwable)e);
                }
            } else {
                throw new TeamRepositoryException(Common.COMMON_BUILDCACHELOAD_NOTINIT);
            }
            this.term();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Integer getRequestThreadMax() {
        Integer result;
        Integer n = this.requestThreadMax;
        synchronized (n) {
            result = this.requestThreadMax;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Long getRequestTimeoutInt() {
        Long result;
        Long l = this.requestTimeoutInt;
        synchronized (l) {
            result = this.requestTimeoutInt;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLoading() {
        Class<BuildCacheLoad> clazz = BuildCacheLoad.class;
        synchronized (BuildCacheLoad.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.requestsList.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRequestThreadMax(Integer requestThreadMax) {
        Integer n = requestThreadMax;
        synchronized (n) {
            this.requestThreadMax = requestThreadMax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getRequestTimeoutInt(Long requestTimeoutInt) {
        Long l = requestTimeoutInt;
        synchronized (l) {
            this.requestTimeoutInt = requestTimeoutInt;
        }
    }
}

