/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.build.extensions.common.ItemArrayList;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuildCacheItemWorkItem
implements IBuildCacheItem<IWorkItem>,
IBuildCachePlatform<IWorkItem> {
    private ITeamRepository repository;
    private IProcessAreaHandle processArea;
    private IItemHandle itemHandle;
    private String repositoryId;
    private String processAreaId;
    private String itemHandleId;
    private boolean partial;
    private boolean standard;
    private boolean complete;
    private final boolean hasItemList;
    private final boolean hasItemMapByName;
    private final boolean hasItemMapByUuid;
    private ItemArrayList<IWorkItem> itemList;
    private Map<String, IWorkItem> itemMapByName;
    private Map<String, IWorkItem> itemMapByUuid;
    private final Set<Integer> usages = new HashSet<Integer>();
    private final Map<IBuildCachePlatform.Platform, Map<Integer, List<IWorkItem>>> platformLists = new HashMap<IBuildCachePlatform.Platform, Map<Integer, List<IWorkItem>>>();

    public BuildCacheItemWorkItem(boolean hasItemList, boolean hasItemMapByName, boolean hasItemMapByUuid) throws TeamRepositoryException {
        this.hasItemList = hasItemList;
        this.hasItemMapByName = hasItemMapByName;
        this.hasItemMapByUuid = hasItemMapByUuid;
        if (!this.hasItemList && !this.hasItemMapByName && this.hasItemMapByUuid) {
            throw new TeamRepositoryException(NLS.bind((String)Common.COMMON_BUILDCACHE_ITEM_EMPTY, (Object)this.getClass().getSimpleName(), (Object[])new Object[0]));
        }
        if (this.hasItemList) {
            this.itemList = new ItemArrayList();
        }
        if (this.hasItemMapByName) {
            this.itemMapByName = Collections.synchronizedMap(new HashMap());
        }
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid = Collections.synchronizedMap(new HashMap());
        }
    }

    public final void addUsage(int usage) {
        this.usages.add(usage);
    }

    public final boolean hasUsage(int usage) {
        return this.usages.contains(usage);
    }

    public final void setUsage(int usage) {
        this.usages.clear();
        this.usages.add(usage);
    }

    public final List<IWorkItem> getPlatformEntry(IBuildCachePlatform.Platform platform, Integer usage) {
        if (this.platformLists.containsKey(platform)) {
            return this.platformLists.get(platform).get(usage);
        }
        return null;
    }

    public final void clearPlatformEntry() {
        this.platformLists.clear();
    }

    public final boolean hasPlatformEntry(IBuildCachePlatform.Platform platform) {
        return this.platformLists.containsKey(platform);
    }

    public final boolean hasPlatformEntry(IBuildCachePlatform.Platform platform, Integer usage) {
        if (this.platformLists.containsKey(platform)) {
            return this.platformLists.get(platform).containsKey(usage);
        }
        return false;
    }

    public final void setPlatformEntry(IBuildCachePlatform.Platform platform, Integer usage, List<IWorkItem> items) {
        if (!this.platformLists.containsKey(platform)) {
            this.platformLists.put(platform, new HashMap());
        }
        this.platformLists.get(platform).put(usage, items);
    }

    @Override
    public final ITeamRepository getRepository() {
        return this.repository;
    }

    @Override
    public final IProcessAreaHandle getProcessArea() {
        return this.processArea;
    }

    @Override
    public final IItemHandle getItemHandle() {
        return this.itemHandle;
    }

    @Override
    public final String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public final String getProcessAreaId() {
        return this.processAreaId;
    }

    @Override
    public final String getItemHandleId() {
        return this.itemHandleId;
    }

    @Override
    public final List<?> getList() {
        return this.itemList;
    }

    @Override
    public final List<IWorkItem> getItemList() {
        return this.itemList;
    }

    @Override
    public final Map<String, IWorkItem> getItemMapByName() {
        return this.itemMapByName;
    }

    @Override
    public final Map<String, IWorkItem> getItemMapByUuid() {
        return this.itemMapByUuid;
    }

    @Override
    public final IWorkItem get(IWorkItem item) {
        IWorkItem result = null;
        result = this.hasItemList ? this.getItemList(item) : (this.hasItemMapByName ? this.getItemMapByName(item) : this.getItemMapByUuid(item));
        return result;
    }

    @Override
    public final IWorkItem get(String item) {
        if (Verification.isUUID((String)item)) {
            return this.getUuid(item);
        }
        return this.getName(item);
    }

    @Override
    public final IWorkItem getName(String name) {
        IWorkItem result = null;
        result = this.hasItemMapByName ? this.getItemMapByName(name) : this.getItemListByName(name);
        return result;
    }

    @Override
    public final IWorkItem getUuid(String uuid) {
        IWorkItem result = null;
        result = this.hasItemMapByUuid ? this.getItemMapByUuid(uuid) : this.getItemListByUuid(uuid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IWorkItem getItemList(int location) {
        IWorkItem result = null;
        if (this.hasItemList) {
            ItemArrayList<IWorkItem> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                if (location <= this.itemList.size()) {
                    result = (IWorkItem)this.itemList.get(location);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IWorkItem getItemList(IWorkItem item) {
        IWorkItem result = null;
        if (this.hasItemList) {
            ItemArrayList<IWorkItem> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = (IWorkItem)this.itemList.get((IItemHandle)item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IWorkItem getItemListByName(String name) {
        IWorkItem result = null;
        if (name != null) {
            if (this.hasItemList) {
                ItemArrayList<IWorkItem> itemArrayList = this.itemList;
                synchronized (itemArrayList) {
                    for (IWorkItem item : this.itemList) {
                        if (!name.equals(Integer.toString(item.getId()))) continue;
                        result = item;
                        break;
                    }
                }
            }
            if (this.hasItemMapByUuid) {
                Map<String, IWorkItem> map = this.itemMapByUuid;
                synchronized (map) {
                    for (IWorkItem item : this.itemMapByUuid.values()) {
                        if (!name.equals(Integer.toString(item.getId()))) continue;
                        result = item;
                        break;
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IWorkItem getItemListByUuid(String uuid) {
        IWorkItem result = null;
        if (uuid != null) {
            if (this.hasItemList) {
                ItemArrayList<IWorkItem> itemArrayList = this.itemList;
                synchronized (itemArrayList) {
                    for (IWorkItem item : this.itemList) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = item;
                        break;
                    }
                }
            }
            if (this.hasItemMapByName) {
                Map<String, IWorkItem> map = this.itemMapByName;
                synchronized (map) {
                    for (IWorkItem item : this.itemMapByName.values()) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = item;
                        break;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public final IWorkItem getItemMapByName(String name) {
        IWorkItem result = null;
        if (this.hasItemMapByName) {
            result = this.itemMapByName.get(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IWorkItem getItemMapByName(IWorkItem itemArg) {
        IWorkItem result = null;
        if (this.hasItemMapByName) {
            Map<String, IWorkItem> map = this.itemMapByName;
            synchronized (map) {
                for (IWorkItem item : this.itemMapByName.values()) {
                    if (!itemArg.sameItemId((IItemHandle)item)) continue;
                    result = item;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public final IWorkItem getItemMapByUuid(String uuid) {
        IWorkItem result = null;
        if (this.hasItemMapByUuid) {
            result = this.itemMapByUuid.get(uuid);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IWorkItem getItemMapByUuid(IWorkItem itemArg) {
        IWorkItem result = null;
        if (this.hasItemMapByUuid) {
            Map<String, IWorkItem> map = this.itemMapByUuid;
            synchronized (map) {
                for (IWorkItem item : this.itemMapByUuid.values()) {
                    if (!itemArg.sameItemId((IItemHandle)item)) continue;
                    result = item;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public final boolean hasRepository() {
        return this.repository != null;
    }

    @Override
    public final boolean hasProcessArea() {
        return this.processArea != null;
    }

    @Override
    public final boolean hasItemHandle() {
        return this.itemHandle != null;
    }

    @Override
    public final boolean hasRepositoryId() {
        return this.repositoryId != null;
    }

    @Override
    public final boolean hasProcessAreaId() {
        return this.processAreaId != null;
    }

    @Override
    public final boolean hasItemHandleId() {
        return this.itemHandleId != null;
    }

    @Override
    public final boolean hasItemList() {
        return this.hasItemList;
    }

    @Override
    public final boolean hasItemMapByName() {
        return this.hasItemMapByName;
    }

    @Override
    public final boolean hasItemMapByUuid() {
        return this.hasItemMapByUuid;
    }

    @Override
    public final boolean isPartial() {
        return this.partial;
    }

    @Override
    public final boolean isStandard() {
        return this.standard;
    }

    @Override
    public final boolean isComplete() {
        return this.complete;
    }

    @Override
    public final boolean isEmpty() {
        return this.isItemListEmpty() && this.isItemMapByNameEmpty() && this.isItemMapByUuidEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isItemListEmpty() {
        boolean result = true;
        if (this.hasItemList) {
            ItemArrayList<IWorkItem> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = this.itemList.size() == 0;
            }
        }
        return result;
    }

    @Override
    public final boolean isItemMapByNameEmpty() {
        return this.hasItemMapByName ? this.itemMapByName.size() == 0 : true;
    }

    @Override
    public final boolean isItemMapByUuidEmpty() {
        return this.hasItemMapByUuid ? this.itemMapByUuid.size() == 0 : true;
    }

    @Override
    public final void setRepository(ITeamRepository repository) {
        this.repository = repository;
    }

    @Override
    public final void setProcessArea(IProcessAreaHandle processArea) {
        this.processArea = processArea;
    }

    @Override
    public final void setItemHandle(IItemHandle itemHandle) {
        this.itemHandle = itemHandle;
    }

    @Override
    public final void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Override
    public final void setProcessAreaId(String processAreaId) {
        this.processAreaId = processAreaId;
    }

    @Override
    public final void setItemHandleId(String itemHandleId) {
        this.itemHandleId = itemHandleId;
    }

    @Override
    public final void setPartial() {
        this.partial = true;
        this.standard = false;
        this.complete = false;
    }

    @Override
    public final void setStandard() {
        this.partial = false;
        this.standard = true;
        this.complete = false;
    }

    @Override
    public final void setComplete() {
        this.partial = false;
        this.standard = false;
        this.complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setItemList(List<IWorkItem> itemList) {
        if (this.hasItemList) {
            ItemArrayList<IWorkItem> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                this.itemList.clear();
                this.itemList.addAll(itemList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setItemMapByName(Map<String, IWorkItem> itemMapByName) {
        if (this.hasItemMapByName) {
            Map<String, IWorkItem> map = this.itemMapByName;
            synchronized (map) {
                this.itemMapByName.clear();
                this.itemMapByName.putAll(itemMapByName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setItemMapByUuid(Map<String, IWorkItem> itemMapByUuid) {
        if (this.hasItemMapByUuid) {
            Map<String, IWorkItem> map = this.itemMapByUuid;
            synchronized (map) {
                this.itemMapByUuid.clear();
                this.itemMapByUuid.putAll(itemMapByUuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<IWorkItem> toItemList() {
        ItemArrayList result = null;
        if (this.hasItemList) {
            ItemArrayList<IWorkItem> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = new ItemArrayList(this.itemList);
            }
        }
        return result;
    }

    @Override
    public final Map<String, IWorkItem> toItemMapByName() {
        HashMap<String, IWorkItem> result = null;
        if (this.hasItemMapByName) {
            result = new HashMap<String, IWorkItem>(this.itemMapByName);
        }
        return result;
    }

    @Override
    public final Map<String, IWorkItem> toItemMapByUuid() {
        HashMap<String, IWorkItem> result = null;
        if (this.hasItemMapByUuid) {
            result = new HashMap<String, IWorkItem>(this.itemMapByUuid);
        }
        return result;
    }

    @Override
    public final void add(IWorkItem item) {
        if (this.hasItemList) {
            this.addItemList(item);
        }
        if (this.hasItemMapByName) {
            this.addItemMapByName(Integer.toString(item.getId()), item);
        }
        if (this.hasItemMapByUuid) {
            this.addItemMapByUuid(item.getItemId().getUuidValue(), item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addItemList(IWorkItem item) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<IWorkItem> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                this.itemList.removeAny((Object)item);
                result = this.itemList.add((Object)item);
            }
        }
        return result;
    }

    @Override
    public final void addItemMapByName(String name, IWorkItem item) {
        if (this.hasItemMapByName) {
            this.itemMapByName.put(name, item);
        }
    }

    @Override
    public final void addItemMapByUuid(String uuid, IWorkItem item) {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.put(uuid, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addAllItemList(List<IWorkItem> items) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<IWorkItem> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                for (IWorkItem item : items) {
                    if (!this.itemList.contains((Object)item)) continue;
                    this.itemList.removeAny((Object)item);
                }
                result = this.itemList.addAll(items);
            }
        }
        return result;
    }

    @Override
    public final void addAllItemMapByName(Map<String, IWorkItem> items) {
        if (this.hasItemMapByName) {
            this.itemMapByName.putAll(items);
        }
    }

    @Override
    public final void addAllItemMapByUuid(Map<String, IWorkItem> items) {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.putAll(items);
        }
    }

    @Override
    public final void clear() {
        this.clearItemList();
        this.clearItemMapByName();
        this.clearItemMapByUuid();
        this.clearPlatformEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearItemList() {
        if (this.hasItemList) {
            ItemArrayList<IWorkItem> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                this.itemList.clear();
            }
        }
    }

    @Override
    public final void clearItemMapByName() {
        if (this.hasItemMapByName) {
            this.itemMapByName.clear();
        }
    }

    @Override
    public final void clearItemMapByUuid() {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.clear();
        }
    }

    @Override
    public final boolean contains(IWorkItem item) {
        boolean result = false;
        result = this.hasItemList ? this.itemListContains(item) : (this.hasItemMapByName ? this.itemMapByNameContains(item) : this.itemMapByUuidContains(item));
        return result;
    }

    @Override
    public final boolean contains(String item) {
        if (Verification.isUUID((String)item)) {
            return this.containsUuid(item);
        }
        return this.containsName(item);
    }

    @Override
    public final boolean contains(UUID item) {
        return this.containsUuid(item.getUuidValue());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final boolean containsAll(List<?> itemList) {
        block4: {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            result = false;
                            if (itemList == null || itemList.size() <= 0) break block4;
                            search = true;
                            iterator = itemList.iterator();
                            if (!(itemList.get(0) instanceof IWorkItem)) break block5;
                            while (search && iterator.hasNext() && iterator.next() != null) {
                                search = this.contains((IWorkItem)iterator.next());
                            }
                            break block6;
                        }
                        if (!(itemList.get(0) instanceof UUID)) break block7;
                        while (search && iterator.hasNext() && iterator.next() != null) {
                            search = this.contains((UUID)iterator.next());
                        }
                        break block6;
                    }
                    if (!(itemList.get(0) instanceof String)) break block8;
                    if (!Verification.isUUID((String)((String)itemList.get(0)))) ** GOTO lbl24
                    while (search && iterator.hasNext() && iterator.next() != null) {
                        search = this.containsUuid((String)iterator.next());
                    }
                    break block6;
lbl-1000:
                    // 1 sources

                    {
                        search = this.containsName((String)iterator.next());
lbl24:
                        // 2 sources

                        ** while (search && iterator.hasNext() && iterator.next() != null)
                    }
lbl25:
                    // 1 sources

                    break block6;
                }
                search = false;
            }
            result = search;
        }
        return result;
    }

    @Override
    public final boolean containsName(String name) {
        boolean result = false;
        result = this.hasItemMapByName ? this.itemMapByNameContains(name) : this.itemListContainsName(name);
        return result;
    }

    @Override
    public final boolean containsUuid(String uuid) {
        boolean result = false;
        result = this.hasItemMapByUuid ? this.itemMapByUuidContains(uuid) : this.itemListContainsUuid(uuid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean itemListContains(IWorkItem item) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<IWorkItem> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = this.itemList.contains((Object)item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean itemListContainsName(String name) {
        boolean result = false;
        if (name != null) {
            if (this.hasItemList) {
                ItemArrayList<IWorkItem> itemArrayList = this.itemList;
                synchronized (itemArrayList) {
                    for (IWorkItem item : this.itemList) {
                        if (!name.equals(Integer.toString(item.getId()))) continue;
                        result = true;
                        break;
                    }
                }
            }
            if (this.hasItemMapByUuid) {
                Map<String, IWorkItem> map = this.itemMapByUuid;
                synchronized (map) {
                    for (IWorkItem item : this.itemMapByUuid.values()) {
                        if (!name.equals(Integer.toString(item.getId()))) continue;
                        result = true;
                        break;
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean itemListContainsUuid(String uuid) {
        boolean result = false;
        if (uuid != null) {
            if (this.hasItemList) {
                ItemArrayList<IWorkItem> itemArrayList = this.itemList;
                synchronized (itemArrayList) {
                    for (IWorkItem item : this.itemList) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = true;
                        break;
                    }
                }
            }
            if (this.hasItemMapByName) {
                Map<String, IWorkItem> map = this.itemMapByName;
                synchronized (map) {
                    for (IWorkItem item : this.itemMapByName.values()) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = true;
                        break;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public final boolean itemMapByNameContains(String name) {
        boolean result = false;
        if (this.hasItemMapByName) {
            result = this.itemMapByName.containsKey(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean itemMapByNameContains(IWorkItem itemArg) {
        boolean result = false;
        if (this.hasItemMapByName) {
            Map<String, IWorkItem> map = this.itemMapByName;
            synchronized (map) {
                for (IWorkItem item : this.itemMapByName.values()) {
                    if (item == null || !item.sameItemId((IItemHandle)itemArg)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public final boolean itemMapByUuidContains(String uuid) {
        boolean result = false;
        if (this.hasItemMapByUuid) {
            result = this.itemMapByUuid.containsKey(uuid);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean itemMapByUuidContains(IWorkItem itemArg) {
        boolean result = false;
        if (this.hasItemMapByUuid) {
            Map<String, IWorkItem> map = this.itemMapByUuid;
            synchronized (map) {
                for (IWorkItem item : this.itemMapByUuid.values()) {
                    if (item == null || !item.sameItemId((IItemHandle)itemArg)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeItemList(IWorkItem item) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<IWorkItem> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = this.itemList.remove((Object)item);
            }
        }
        return result;
    }

    @Override
    public final void removeItemMapByName(String name) {
        if (this.hasItemMapByName) {
            this.itemMapByName.remove(name);
        }
    }

    @Override
    public final void removeItemMapByUuid(String uuid) {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.remove(uuid);
        }
    }
}

