/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.client.util.SCMWorkspace;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildCacheAddWorkspaceHandle {
    private static final String className = BuildCacheAddWorkspaceHandle.class.getSimpleName();

    public static IWorkspaceHandle add(ITeamRepository repository, IBuildCacheItem<IWorkspaceHandle> buildCacheItem, IWorkspace item, IWorkspaceHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IWorkspace itemDefinition = null;
        if (item != null) {
            if (buildCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (buildCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = itemHandle;
        } else if (itemString != null) {
            if (buildCacheItem.contains(itemString)) {
                return buildCacheItem.get(itemString);
            }
            itemDefinition = SCMWorkspace.getWorkspaceHandle(repository, itemString, monitor, dbg);
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = buildCacheItem.hasItemMapByName() ? SCMWorkspace.getWorkspaceName(repository, (IWorkspaceHandle)itemDefinition, monitor, dbg) : null;
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addItemList((IWorkspaceHandle)itemDefinition);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addItemMapByName(itemDefinitionName, (IWorkspaceHandle)itemDefinition);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addItemMapByUuid(itemDefinitionUuid, (IWorkspaceHandle)itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<IWorkspaceHandle> add(ITeamRepository repository, IBuildCacheItem<IWorkspaceHandle> buildCacheItem, List<IWorkspace> items, List<IWorkspaceHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IWorkspaceHandle> itemList = new ArrayList<IWorkspaceHandle>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(itemHandles);
        } else if (itemStrings != null) {
            itemList.addAll(SCMWorkspace.getWorkspaceHandles(repository, itemStrings, monitor, dbg));
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IWorkspaceHandle> itemMapByName = new HashMap<String, IWorkspaceHandle>();
        HashMap<String, IWorkspaceHandle> itemMapByUuid = new HashMap<String, IWorkspaceHandle>();
        for (IWorkspaceHandle item : itemList) {
            if (buildCacheItem.hasItemMapByName()) {
                String itemName = SCMWorkspace.getWorkspaceName(repository, item, monitor, dbg);
                itemMapByName.put(itemName, item);
            }
            if (!buildCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addAllItemList(itemList);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }
}

