/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.client.util.SCMComponent;
import com.ibm.team.build.extensions.client.util.SCMWorkspace;
import com.ibm.team.build.extensions.common.IWorkspaceContent;
import com.ibm.team.build.extensions.common.WorkspaceContent;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildCacheAddWorkspace {
    private static final String className = BuildCacheAddWorkspace.class.getSimpleName();

    public static IWorkspaceContent add(ITeamRepository repository, IBuildCacheItem<IWorkspaceContent> buildCacheItem, IWorkspace item, IWorkspaceHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IItemManager client = repository.itemManager();
        IWorkspace itemDefinition = null;
        WorkspaceContent workspaceContent = null;
        if (item != null) {
            if (buildCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (buildCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = (IWorkspace)client.fetchCompleteItem((IItemHandle)itemHandle, 0, monitor);
        } else if (itemString != null) {
            if (buildCacheItem.contains(itemString)) {
                return buildCacheItem.get(itemString);
            }
            itemDefinition = SCMWorkspace.getWorkspace(repository, itemString, monitor, dbg);
        }
        if (itemDefinition == null) {
            return null;
        }
        String itemDefinitionName = itemDefinition.getName();
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        IWorkspaceConnection workspaceConnection = SCMWorkspace.getWorkspaceConnection(repository, (IWorkspaceHandle)itemDefinition.getItemHandle(), dbg);
        List<IComponentHandle> componentHandleList = SCMComponent.getComponentByWorkspace(repository, workspaceConnection, dbg);
        List<IComponent> componentList = SCMComponent.getComponentList(repository, componentHandleList, dbg);
        HashMap<String, IComponent> componentMapByName = new HashMap<String, IComponent>();
        HashMap<String, IComponent> componentMapByUuid = new HashMap<String, IComponent>();
        for (IComponent component : componentList) {
            String componentName = component.getName();
            componentMapByName.put(componentName, component);
            String componentUuid = component.getItemId().getUuidValue();
            componentMapByUuid.put(componentUuid, component);
        }
        workspaceContent = new WorkspaceContent(itemDefinition);
        workspaceContent.setWorkspaceName(itemDefinitionName);
        workspaceContent.setWorkspaceUuid(itemDefinitionUuid);
        workspaceContent.setComponentList(componentList);
        workspaceContent.setComponentHandleList(componentHandleList);
        workspaceContent.setComponentMapByName(componentMapByName);
        workspaceContent.setComponentMapByUuid(componentMapByUuid);
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addItemList((IWorkspaceContent)workspaceContent);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addItemMapByName(itemDefinitionName, (IWorkspaceContent)workspaceContent);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addItemMapByUuid(itemDefinitionUuid, (IWorkspaceContent)workspaceContent);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)workspaceContent)});
        }
        return workspaceContent;
    }

    public static List<IWorkspaceContent> add(ITeamRepository repository, IBuildCacheItem<IWorkspaceContent> buildCacheItem, List<IWorkspace> items, List<IWorkspaceHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IItemManager client = repository.itemManager();
        ArrayList<IWorkspace> itemList = new ArrayList<IWorkspace>();
        ArrayList<IWorkspaceContent> contentList = new ArrayList<IWorkspaceContent>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(client.fetchCompleteItems(itemHandles, 0, monitor));
        } else if (itemStrings != null) {
            itemList.addAll(SCMWorkspace.getWorkspaces(repository, itemStrings, monitor, dbg));
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, WorkspaceContent> itemMapByName = new HashMap<String, WorkspaceContent>();
        HashMap<String, WorkspaceContent> itemMapByUuid = new HashMap<String, WorkspaceContent>();
        for (IWorkspace item : itemList) {
            WorkspaceContent workspaceContent = null;
            String itemDefinitionName = item.getName();
            String itemDefinitionUuid = item.getItemId().getUuidValue();
            IWorkspaceConnection workspaceConnection = SCMWorkspace.getWorkspaceConnection(repository, (IWorkspaceHandle)item.getItemHandle(), dbg);
            List<IComponentHandle> componentHandleList = SCMComponent.getComponentByWorkspace(repository, workspaceConnection, dbg);
            List<IComponent> componentList = SCMComponent.getComponentList(repository, componentHandleList, dbg);
            HashMap<String, IComponent> componentMapByName = new HashMap<String, IComponent>();
            HashMap<String, IComponent> componentMapByUuid = new HashMap<String, IComponent>();
            for (IComponent component : componentList) {
                String componentName = component.getName();
                componentMapByName.put(componentName, component);
                String componentUuid = component.getItemId().getUuidValue();
                componentMapByUuid.put(componentUuid, component);
            }
            workspaceContent = new WorkspaceContent(item);
            workspaceContent.setWorkspaceName(itemDefinitionName);
            workspaceContent.setWorkspaceUuid(itemDefinitionUuid);
            workspaceContent.setComponentList(componentList);
            workspaceContent.setComponentHandleList(componentHandleList);
            workspaceContent.setComponentMapByName(componentMapByName);
            workspaceContent.setComponentMapByUuid(componentMapByUuid);
            if (buildCacheItem.hasItemMapByName()) {
                itemMapByName.put(itemDefinitionName, workspaceContent);
            }
            if (!buildCacheItem.hasItemMapByUuid()) continue;
            itemMapByUuid.put(itemDefinitionUuid, workspaceContent);
        }
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addAllItemList(contentList);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(contentList)});
        }
        return contentList;
    }
}

