/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.client.util.CCMWorkItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildCacheAddWorkItem {
    private static final String className = BuildCacheAddWorkItem.class.getSimpleName();

    public static IWorkItem add(ITeamRepository repository, IBuildCacheItem<IWorkItem> buildCacheItem, IWorkItem item, IWorkItemHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IItemManager client = repository.itemManager();
        IWorkItem itemDefinition = null;
        if (item != null) {
            if (buildCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (buildCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = (IWorkItem)client.fetchCompleteItem((IItemHandle)itemHandle, 0, monitor);
        } else if (itemString != null) {
            if (buildCacheItem.contains(itemString)) {
                return buildCacheItem.get(itemString);
            }
            itemDefinition = CCMWorkItem.getWorkItem(repository, itemString, monitor, dbg);
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = Integer.toString(itemDefinition.getId());
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addItemList(itemDefinition);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addItemMapByName(itemDefinitionName, itemDefinition);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addItemMapByUuid(itemDefinitionUuid, itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<IWorkItem> add(ITeamRepository repository, IBuildCacheItem<IWorkItem> buildCacheItem, List<IWorkItem> items, List<IWorkItemHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IItemManager client = repository.itemManager();
        ArrayList<IWorkItem> itemList = new ArrayList<IWorkItem>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(client.fetchCompleteItems(itemHandles, 0, monitor));
        } else if (itemStrings != null) {
            itemList.addAll(CCMWorkItem.getWorkItems(repository, itemStrings, monitor, dbg));
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IWorkItem> itemMapByName = new HashMap<String, IWorkItem>();
        HashMap<String, IWorkItem> itemMapByUuid = new HashMap<String, IWorkItem>();
        for (IWorkItem item : itemList) {
            if (buildCacheItem.hasItemMapByName()) {
                String itemName = Integer.toString(item.getId());
                itemMapByName.put(itemName, item);
            }
            if (!buildCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addAllItemList(itemList);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }
}

