/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.client.util.BuildResult;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildCacheAddBuildResult {
    private static final String className = BuildCacheAddBuildResult.class.getSimpleName();

    public static IBuildResult add(ITeamRepository repository, IBuildCacheItem<IBuildResult> buildCacheItem, IBuildResult item, IBuildResultHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IItemManager client = repository.itemManager();
        IBuildResult itemDefinition = null;
        if (item != null) {
            if (buildCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (buildCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = (IBuildResult)client.fetchCompleteItem((IItemHandle)itemHandle, 0, monitor);
        } else if (itemString != null) {
            if (buildCacheItem.contains(itemString)) {
                return buildCacheItem.get(itemString);
            }
            itemDefinition = BuildResult.getBuildResult(repository, itemString, monitor, dbg);
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = itemDefinition.getLabel();
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addItemList(itemDefinition);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addItemMapByName(itemDefinitionName, itemDefinition);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addItemMapByUuid(itemDefinitionUuid, itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<IBuildResult> add(ITeamRepository repository, IBuildCacheItem<IBuildResult> buildCacheItem, List<IBuildResult> items, List<IBuildResultHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IItemManager client = repository.itemManager();
        ArrayList<IBuildResult> itemList = new ArrayList<IBuildResult>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(client.fetchCompleteItems(itemHandles, 0, monitor));
        } else if (itemStrings != null) {
            itemList.addAll(BuildResult.getBuildResults(repository, itemStrings, monitor, dbg));
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IBuildResult> itemMapByName = new HashMap<String, IBuildResult>();
        HashMap<String, IBuildResult> itemMapByUuid = new HashMap<String, IBuildResult>();
        for (IBuildResult item : itemList) {
            if (buildCacheItem.hasItemMapByName()) {
                String itemName = item.getLabel();
                itemMapByName.put(itemName, item);
            }
            if (!buildCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addAllItemList(itemList);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }

    public static IBuildCacheItem<IBuildResult> add(ITeamRepository repository, IBuildCacheItem<IBuildResult> buildCacheItem, IBuildDefinition definition, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        if (!buildCacheItem.isEmpty() && (buildCacheItem.isStandard() || buildCacheItem.isComplete())) {
            return buildCacheItem;
        }
        IFetchResult fetchResult = BuildResult.getBuildResults(repository, definition, dbg);
        List itemList = fetchResult.getRetrievedItems();
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IBuildResult> itemMapByName = new HashMap<String, IBuildResult>();
        HashMap<String, IBuildResult> itemMapByUuid = new HashMap<String, IBuildResult>();
        for (IBuildResult item : itemList) {
            if (buildCacheItem.hasItemMapByName()) {
                String itemName = item.getLabel();
                itemMapByName.put(itemName, item);
            }
            if (!buildCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        buildCacheItem.setStandard();
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.setItemList(itemList);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.setItemMapByName(itemMapByName);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.setItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        return buildCacheItem;
    }
}

