/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.client.util.BuildFolder;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildCacheAddBuildFolderHandle {
    private static final String className = BuildCacheAddBuildFolderHandle.class.getSimpleName();

    public static IBuildFolderHandle add(ITeamRepository repository, IBuildCacheItem<IBuildFolderHandle> buildCacheItem, IBuildFolder item, IBuildFolderHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildFolder itemDefinition = null;
        if (item != null) {
            if (buildCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (buildCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = itemHandle;
        } else if (itemString != null) {
            if (buildCacheItem.contains(itemString)) {
                return buildCacheItem.get(itemString);
            }
            itemDefinition = Verification.isUUID((String)itemString) ? (IBuildFolderHandle)IBuildFolder.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemString), null) : BuildFolder.findBuildFolderByPath(repository, buildCacheItem.getProcessArea(), itemString, monitor, dbg);
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = buildCacheItem.hasItemMapByName() ? BuildFolder.getFolderPath(repository, (IBuildFolderHandle)itemDefinition, monitor, dbg) : null;
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addItemList((IBuildFolderHandle)itemDefinition);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addItemMapByName(itemDefinitionName, (IBuildFolderHandle)itemDefinition);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addItemMapByUuid(itemDefinitionUuid, (IBuildFolderHandle)itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<IBuildFolderHandle> add(ITeamRepository repository, IBuildCacheItem<IBuildFolderHandle> buildCacheItem, List<IBuildFolder> items, List<IBuildFolderHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IBuildFolderHandle> itemList = new ArrayList<IBuildFolderHandle>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(itemHandles);
        } else if (itemStrings != null) {
            for (String itemId : itemStrings) {
                if (Verification.isUUID((String)itemId)) {
                    itemList.add((IBuildFolderHandle)IBuildFolder.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null));
                    continue;
                }
                itemList.add(BuildFolder.findBuildFolderByPath(repository, buildCacheItem.getProcessArea(), itemId, monitor, dbg));
            }
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IBuildFolderHandle> itemMapByName = new HashMap<String, IBuildFolderHandle>();
        HashMap<String, IBuildFolderHandle> itemMapByUuid = new HashMap<String, IBuildFolderHandle>();
        for (IBuildFolderHandle item : itemList) {
            if (buildCacheItem.hasItemMapByName()) {
                String itemName = BuildFolder.getFolderPath(repository, item, monitor, dbg);
                itemMapByName.put(itemName, item);
            }
            if (!buildCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addAllItemList(itemList);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }
}

