/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.client.util.BuildEngine;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildCacheAddBuildEngine {
    private static final String className = BuildCacheAddBuildEngine.class.getSimpleName();

    public static IBuildEngine add(ITeamRepository repository, IBuildCacheItem<IBuildEngine> buildCacheItem, IBuildEngine item, IBuildEngineHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IItemManager client = repository.itemManager();
        IBuildEngine itemDefinition = null;
        if (item != null) {
            if (buildCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (buildCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return buildCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = (IBuildEngine)client.fetchCompleteItem((IItemHandle)itemHandle, 0, monitor);
        } else if (itemString != null) {
            if (buildCacheItem.contains(itemString)) {
                return buildCacheItem.get(itemString);
            }
            itemDefinition = BuildEngine.getBuildEngine(repository, itemString, monitor, dbg);
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = itemDefinition.getId();
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addItemList(itemDefinition);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addItemMapByName(itemDefinitionName, itemDefinition);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addItemMapByUuid(itemDefinitionUuid, itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<IBuildEngine> add(ITeamRepository repository, IBuildCacheItem<IBuildEngine> buildCacheItem, List<IBuildEngine> items, List<IBuildEngineHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IItemManager client = repository.itemManager();
        ArrayList<IBuildEngine> itemList = new ArrayList<IBuildEngine>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(client.fetchCompleteItems(itemHandles, 0, monitor));
        } else if (itemStrings != null) {
            itemList.addAll(BuildEngine.getBuildEngines(repository, itemStrings, monitor, dbg));
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IBuildEngine> itemMapByName = new HashMap<String, IBuildEngine>();
        HashMap<String, IBuildEngine> itemMapByUuid = new HashMap<String, IBuildEngine>();
        for (IBuildEngine item : itemList) {
            if (buildCacheItem.hasItemMapByName()) {
                String itemName = item.getId();
                itemMapByName.put(itemName, item);
            }
            if (!buildCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addAllItemList(itemList);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }
}

