/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class BuildCache {
    private static volatile BuildCache instance;
    private final Map<String, Object> buildCacheMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, UUID> buildCacheRepoMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Object> buildCacheItemMap = Collections.synchronizedMap(new HashMap());
    private final AtomicInteger cacheCounter = new AtomicInteger(0);
    private final AtomicInteger macroCounter = new AtomicInteger(0);

    private BuildCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean contains(String id) {
        Map<String, Object> map = this.buildCacheMap;
        synchronized (map) {
            block4: {
                if (!this.buildCacheMap.containsKey(id)) break block4;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(String id) {
        Object result = null;
        Map<String, Object> map = this.buildCacheMap;
        synchronized (map) {
            if (this.buildCacheMap.containsKey(id)) {
                result = this.buildCacheMap.get(id);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object remove(String id) {
        Object result = null;
        Map<String, Object> map = this.buildCacheMap;
        synchronized (map) {
            if (this.buildCacheMap.containsKey(id)) {
                result = this.buildCacheMap.remove(id);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object set(String id, Object object) {
        Object result = null;
        Map<String, Object> map = this.buildCacheMap;
        synchronized (map) {
            result = this.buildCacheMap.put(id, object);
        }
        return result;
    }

    public final UUID getRepo(String url) {
        return this.buildCacheRepoMap.get(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsItem(String itemId) {
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            block4: {
                if (!this.buildCacheItemMap.containsKey(itemId)) break block4;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsItem(Object repository, String itemId) {
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            block4: {
                Object repositoryObject;
                String repositoryId;
                HashMap repositoryMap;
                Object itemObject;
                if (!this.buildCacheItemMap.containsKey(itemId) || !((itemObject = this.buildCacheItemMap.get(itemId)) instanceof HashMap) || !(repositoryMap = (HashMap)itemObject).containsKey(repositoryId = BuildCache.getRepositoryId(repository)) || !((repositoryObject = repositoryMap.get(repositoryId)) instanceof IBuildCacheItem)) break block4;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsItem(Object repository, IProcessAreaHandle processArea, String itemId) {
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            block4: {
                Object processAreaObject;
                String processAreaId;
                HashMap processAreaMap;
                Object repositoryObject;
                String repositoryId;
                HashMap repositoryMap;
                Object itemObject;
                if (!this.buildCacheItemMap.containsKey(itemId) || !((itemObject = this.buildCacheItemMap.get(itemId)) instanceof HashMap) || !(repositoryMap = (HashMap)itemObject).containsKey(repositoryId = BuildCache.getRepositoryId(repository)) || !((repositoryObject = repositoryMap.get(repositoryId)) instanceof HashMap) || !(processAreaMap = (HashMap)repositoryObject).containsKey(processAreaId = processArea.getItemId().getUuidValue()) || !((processAreaObject = processAreaMap.get(processAreaId)) instanceof IBuildCacheItem)) break block4;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsItem(Object repository, IItemHandle itemHandle, String itemId) {
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            block4: {
                Object itemHandleObject;
                String itemHandleId;
                HashMap itemHandleMap;
                Object repositoryObject;
                String repositoryId;
                HashMap repositoryMap;
                Object itemObject;
                if (!this.buildCacheItemMap.containsKey(itemId) || !((itemObject = this.buildCacheItemMap.get(itemId)) instanceof HashMap) || !(repositoryMap = (HashMap)itemObject).containsKey(repositoryId = BuildCache.getRepositoryId(repository)) || !((repositoryObject = repositoryMap.get(repositoryId)) instanceof HashMap) || !(itemHandleMap = (HashMap)repositoryObject).containsKey(itemHandleId = itemHandle.getItemId().getUuidValue()) || !((itemHandleObject = itemHandleMap.get(itemHandleId)) instanceof IBuildCacheItem)) break block4;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IBuildCacheItem getItem(String itemId) {
        IBuildCacheItem result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            Object itemObject;
            if (this.buildCacheItemMap.containsKey(itemId) && (itemObject = this.buildCacheItemMap.get(itemId)) instanceof IBuildCacheItem) {
                result = (IBuildCacheItem)itemObject;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IBuildCacheItem getItem(Object repository, String itemId) {
        IBuildCacheItem result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            Object repositoryObject;
            String repositoryId;
            HashMap repositoryMap;
            Object itemObject;
            if (this.buildCacheItemMap.containsKey(itemId) && (itemObject = this.buildCacheItemMap.get(itemId)) instanceof HashMap && (repositoryMap = (HashMap)itemObject).containsKey(repositoryId = BuildCache.getRepositoryId(repository)) && (repositoryObject = repositoryMap.get(repositoryId)) instanceof IBuildCacheItem) {
                result = (IBuildCacheItem)repositoryObject;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IBuildCacheItem getItem(Object repository, IProcessAreaHandle processArea, String itemId) {
        IBuildCacheItem result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            Object processAreaObject;
            String processAreaId;
            HashMap processAreaMap;
            Object repositoryObject;
            String repositoryId;
            HashMap repositoryMap;
            Object itemObject;
            if (this.buildCacheItemMap.containsKey(itemId) && (itemObject = this.buildCacheItemMap.get(itemId)) instanceof HashMap && (repositoryMap = (HashMap)itemObject).containsKey(repositoryId = BuildCache.getRepositoryId(repository)) && (repositoryObject = repositoryMap.get(repositoryId)) instanceof HashMap && (processAreaMap = (HashMap)repositoryObject).containsKey(processAreaId = processArea.getItemId().getUuidValue()) && (processAreaObject = processAreaMap.get(processAreaId)) instanceof IBuildCacheItem) {
                result = (IBuildCacheItem)processAreaObject;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IBuildCacheItem getItem(Object repository, IItemHandle itemHandle, String itemId) {
        IBuildCacheItem result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            Object itemHandleObject;
            String itemHandleId;
            HashMap itemHandleMap;
            Object repositoryObject;
            String repositoryId;
            HashMap repositoryMap;
            Object itemObject;
            if (this.buildCacheItemMap.containsKey(itemId) && (itemObject = this.buildCacheItemMap.get(itemId)) instanceof HashMap && (repositoryMap = (HashMap)itemObject).containsKey(repositoryId = BuildCache.getRepositoryId(repository)) && (repositoryObject = repositoryMap.get(repositoryId)) instanceof HashMap && (itemHandleMap = (HashMap)repositoryObject).containsKey(itemHandleId = itemHandle.getItemId().getUuidValue()) && (itemHandleObject = itemHandleMap.get(itemHandleId)) instanceof IBuildCacheItem) {
                result = (IBuildCacheItem)itemHandleObject;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object removeItem(String itemId) {
        Object result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            Object itemObject;
            if (this.buildCacheItemMap.containsKey(itemId) && (itemObject = this.buildCacheItemMap.get(itemId)) instanceof IBuildCacheItem) {
                result = this.buildCacheItemMap.remove(itemId);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object removeItem(Object repository, String itemId) {
        Object result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            Object repositoryObject;
            String repositoryId;
            HashMap repositoryMap;
            Object itemObject;
            if (this.buildCacheItemMap.containsKey(itemId) && (itemObject = this.buildCacheItemMap.get(itemId)) != null && itemObject instanceof HashMap && (repositoryMap = (HashMap)itemObject).containsKey(repositoryId = BuildCache.getRepositoryId(repository)) && (repositoryObject = repositoryMap.get(repositoryId)) instanceof IBuildCacheItem) {
                result = repositoryMap.remove(repositoryId);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object removeItem(Object repository, IProcessAreaHandle processArea, String itemId) {
        Object result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            Object processAreaObject;
            String processAreaId;
            HashMap processAreaMap;
            Object repositoryObject;
            String repositoryId;
            HashMap repositoryMap;
            Object itemObject;
            if (this.buildCacheItemMap.containsKey(itemId) && (itemObject = this.buildCacheItemMap.get(itemId)) != null && itemObject instanceof HashMap && (repositoryMap = (HashMap)itemObject).containsKey(repositoryId = BuildCache.getRepositoryId(repository)) && (repositoryObject = repositoryMap.get(repositoryId)) != null && repositoryObject instanceof HashMap && (processAreaMap = (HashMap)repositoryObject).containsKey(processAreaId = processArea.getItemId().getUuidValue()) && (processAreaObject = processAreaMap.get(processAreaId)) instanceof IBuildCacheItem) {
                result = processAreaMap.remove(processAreaId);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object removeItem(Object repository, IItemHandle itemHandle, String itemId) {
        Object result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            Object itemHandleObject;
            String itemHandleId;
            HashMap itemHandleMap;
            Object repositoryObject;
            String repositoryId;
            HashMap repositoryMap;
            Object itemObject;
            if (this.buildCacheItemMap.containsKey(itemId) && (itemObject = this.buildCacheItemMap.get(itemId)) != null && itemObject instanceof HashMap && (repositoryMap = (HashMap)itemObject).containsKey(repositoryId = BuildCache.getRepositoryId(repository)) && (repositoryObject = repositoryMap.get(repositoryId)) != null && repositoryObject instanceof HashMap && (itemHandleMap = (HashMap)repositoryObject).containsKey(itemHandleId = itemHandle.getItemId().getUuidValue()) && (itemHandleObject = itemHandleMap.get(itemHandleId)) instanceof IBuildCacheItem) {
                result = itemHandleMap.remove(itemHandleId);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object setItem(String itemId, IBuildCacheItem buildCacheItem) {
        Object result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            result = this.buildCacheItemMap.put(itemId, buildCacheItem);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IBuildCacheItem setItem(ITeamRepository repository, String itemId, IBuildCacheItem buildCacheItem) throws TeamRepositoryException {
        IBuildCacheItem result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            if (this.buildCacheItemMap.containsKey(itemId)) {
                Object itemObject = this.buildCacheItemMap.get(itemId);
                if (!(itemObject instanceof HashMap)) throw new TeamRepositoryException(Common.COMMON_BUILDCACHE_ITEM_INVALID);
                HashMap repositoryMap = (HashMap)itemObject;
                String repositoryId = repository.getId().getUuidValue();
                return repositoryMap.put(repositoryId, buildCacheItem);
            }
            HashMap<String, IBuildCacheItem> repositoryMap = new HashMap<String, IBuildCacheItem>();
            String repositoryId = repository.getId().getUuidValue();
            result = repositoryMap.put(repositoryId, buildCacheItem);
            this.buildCacheItemMap.put(itemId, repositoryMap);
            Map<String, UUID> map2 = this.buildCacheRepoMap;
            synchronized (map2) {
                this.buildCacheRepoMap.put(repository.getRepositoryURI(), repository.getId());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IBuildCacheItem setItem(ITeamRepository repository, IProcessAreaHandle processArea, String itemId, IBuildCacheItem buildCacheItem) throws TeamRepositoryException {
        IBuildCacheItem result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            if (this.buildCacheItemMap.containsKey(itemId)) {
                Object itemObject = this.buildCacheItemMap.get(itemId);
                if (!(itemObject instanceof HashMap)) throw new TeamRepositoryException(Common.COMMON_BUILDCACHE_ITEM_INVALID);
                HashMap repositoryMap = (HashMap)itemObject;
                String repositoryId = repository.getId().getUuidValue();
                if (repositoryMap.containsKey(repositoryId)) {
                    Object repositoryObject = repositoryMap.get(repositoryId);
                    if (!(repositoryObject instanceof HashMap)) throw new TeamRepositoryException(Common.COMMON_BUILDCACHE_ITEM_INVALID);
                    HashMap processAreaMap = (HashMap)repositoryObject;
                    String processAreaId = processArea.getItemId().getUuidValue();
                    return processAreaMap.put(processAreaId, buildCacheItem);
                }
                HashMap<String, IBuildCacheItem> processAreaMap = new HashMap<String, IBuildCacheItem>();
                String processAreaId = processArea.getItemId().getUuidValue();
                result = processAreaMap.put(processAreaId, buildCacheItem);
                repositoryMap.put(repositoryId, processAreaMap);
                Map<String, UUID> map2 = this.buildCacheRepoMap;
                synchronized (map2) {
                    this.buildCacheRepoMap.put(repository.getRepositoryURI(), repository.getId());
                }
            } else {
                HashMap<String, IBuildCacheItem> processAreaMap = new HashMap<String, IBuildCacheItem>();
                String processAreaId = processArea.getItemId().getUuidValue();
                result = processAreaMap.put(processAreaId, buildCacheItem);
                HashMap<String, HashMap<String, IBuildCacheItem>> repositoryMap = new HashMap<String, HashMap<String, IBuildCacheItem>>();
                String repositoryId = repository.getId().getUuidValue();
                repositoryMap.put(repositoryId, processAreaMap);
                this.buildCacheItemMap.put(itemId, repositoryMap);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IBuildCacheItem setItem(ITeamRepository repository, IItemHandle itemHandle, String itemId, IBuildCacheItem buildCacheItem) throws TeamRepositoryException {
        IBuildCacheItem result = null;
        Map<String, Object> map = this.buildCacheItemMap;
        synchronized (map) {
            if (this.buildCacheItemMap.containsKey(itemId)) {
                Object itemObject = this.buildCacheItemMap.get(itemId);
                if (!(itemObject instanceof HashMap)) throw new TeamRepositoryException(Common.COMMON_BUILDCACHE_ITEM_INVALID);
                HashMap repositoryMap = (HashMap)itemObject;
                String repositoryId = repository.getId().getUuidValue();
                if (repositoryMap.containsKey(repositoryId)) {
                    Object repositoryObject = repositoryMap.get(repositoryId);
                    if (!(repositoryObject instanceof HashMap)) throw new TeamRepositoryException(Common.COMMON_BUILDCACHE_ITEM_INVALID);
                    HashMap itemHandleMap = (HashMap)repositoryObject;
                    String itemHandleId = itemHandle.getItemId().getUuidValue();
                    return itemHandleMap.put(itemHandleId, buildCacheItem);
                }
                HashMap<String, IBuildCacheItem> itemHandleMap = new HashMap<String, IBuildCacheItem>();
                String itemHandleId = itemHandle.getItemId().getUuidValue();
                result = itemHandleMap.put(itemHandleId, buildCacheItem);
                repositoryMap.put(repositoryId, itemHandleMap);
                Map<String, UUID> map2 = this.buildCacheRepoMap;
                synchronized (map2) {
                    this.buildCacheRepoMap.put(repository.getRepositoryURI(), repository.getId());
                }
            } else {
                HashMap<String, IBuildCacheItem> itemHandleMap = new HashMap<String, IBuildCacheItem>();
                String itemHandleId = itemHandle.getItemId().getUuidValue();
                result = itemHandleMap.put(itemHandleId, buildCacheItem);
                HashMap<String, HashMap<String, IBuildCacheItem>> repositoryMap = new HashMap<String, HashMap<String, IBuildCacheItem>>();
                String repositoryId = repository.getId().getUuidValue();
                repositoryMap.put(repositoryId, itemHandleMap);
                this.buildCacheItemMap.put(itemId, repositoryMap);
            }
            return result;
        }
    }

    private static final String getRepositoryId(Object repository) {
        if (repository instanceof ITeamRepository) {
            return ((ITeamRepository)repository).getId().getUuidValue();
        }
        if (repository instanceof UUID) {
            return ((UUID)repository).getUuidValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BuildCache getInstance() {
        if (instance != null) return instance;
        Class<BuildCache> clazz = BuildCache.class;
        synchronized (BuildCache.class) {
            if (instance != null) return instance;
            instance = new BuildCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int getCount() {
        return this.cacheCounter.incrementAndGet();
    }

    public int getNextMacroCounter() {
        return this.macroCounter.incrementAndGet();
    }

    public void setCount(int value) {
        this.cacheCounter.set(value);
    }
}

