/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.registry;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.registry.AbstractBuildExtension;
import com.ibm.team.build.internal.common.registry.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class AbstractBuildTemplateExtension
extends AbstractBuildExtension {
    private final Map<String, List<IConfigurationProperty>> fConfigurationElementIds = new LinkedHashMap<String, List<IConfigurationProperty>>();
    private final Map<String, List<IConfigurationProperty>> fAvailableConfigurationElementIds = new LinkedHashMap<String, List<IConfigurationProperty>>();
    private final List<IBuildProperty> fGenericProperties = new ArrayList<IBuildProperty>();
    private final boolean fSupportsHiddenPropertyAttribute;

    public AbstractBuildTemplateExtension(IConfigurationElement pluginConfigurationElement) {
        super(pluginConfigurationElement);
        this.fSupportsHiddenPropertyAttribute = Boolean.parseBoolean(pluginConfigurationElement.getAttribute("supportsHiddenProperty"));
        this.processConfigurationElements(pluginConfigurationElement);
        this.processGenericProperties(pluginConfigurationElement, this.fGenericProperties, true);
        this.processAvailableConfigurationElements(pluginConfigurationElement);
    }

    protected abstract String getConfigurationElementName();

    private void processConfigurationElements(IConfigurationElement pluginConfigurationElement) {
        IConfigurationElement[] pluginElements;
        String elementName = this.getConfigurationElementName();
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren(elementName);
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String id = pluginElement.getAttribute("id");
            ValidationHelper.validateNotNull("id", id);
            ValidationHelper.validateNotEmpty("id", id.trim());
            if (!this.fConfigurationElementIds.containsKey(id)) {
                ArrayList<IConfigurationProperty> properties = new ArrayList<IConfigurationProperty>();
                IConfigurationElement[] propsElement = pluginElement.getChildren("configurationProperty");
                if (propsElement != null) {
                    IConfigurationElement[] iConfigurationElementArray2 = propsElement;
                    int n3 = propsElement.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement propElement = iConfigurationElementArray2[n4];
                        String name = propElement.getAttribute("name");
                        ValidationHelper.validateNotNull("name", name);
                        ValidationHelper.validateNotEmpty("name", name.trim());
                        String defaultValue = propElement.getAttribute("defaultValue");
                        ValidationHelper.validateNotNull("defaultValue", defaultValue);
                        ValidationHelper.validateNotEmpty("defaultValue", defaultValue.trim());
                        IConfigurationProperty property = BuildItemFactory.createConfigurationProperty();
                        property.setName(name);
                        property.setValue(defaultValue.trim());
                        properties.add(property);
                        ++n4;
                    }
                }
                this.fConfigurationElementIds.put(id, properties);
            }
            ++n2;
        }
        if (this.fConfigurationElementIds.isEmpty()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.AbstractBuildTemplateExtension_MISSING_CONFIG_ELEMENT, (Object)elementName, (Object[])new Object[0]));
        }
    }

    public String[] getConfigurationElementIds() {
        return this.fConfigurationElementIds.keySet().toArray(new String[this.fConfigurationElementIds.size()]);
    }

    private void processAvailableConfigurationElements(IConfigurationElement pluginConfigurationElement) {
        IConfigurationElement[] pluginElements;
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren("availableBuildConfigurationElement");
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String id = pluginElement.getAttribute("id");
            ValidationHelper.validateNotNull("id", id);
            ValidationHelper.validateNotEmpty("id", id.trim());
            if (!this.fAvailableConfigurationElementIds.containsKey(id) && !this.fConfigurationElementIds.containsKey(id)) {
                ArrayList<IConfigurationProperty> properties = new ArrayList<IConfigurationProperty>();
                IConfigurationElement[] propsElement = pluginElement.getChildren("configurationProperty");
                if (propsElement != null) {
                    IConfigurationElement[] iConfigurationElementArray2 = propsElement;
                    int n3 = propsElement.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement propElement = iConfigurationElementArray2[n4];
                        String name = propElement.getAttribute("name");
                        ValidationHelper.validateNotNull("name", name);
                        ValidationHelper.validateNotEmpty("name", name.trim());
                        String defaultValue = propElement.getAttribute("defaultValue");
                        ValidationHelper.validateNotNull("defaultValue", defaultValue);
                        ValidationHelper.validateNotEmpty("defaultValue", defaultValue.trim());
                        IConfigurationProperty property = BuildItemFactory.createConfigurationProperty();
                        property.setName(name);
                        property.setValue(defaultValue.trim());
                        properties.add(property);
                        ++n4;
                    }
                }
                this.fAvailableConfigurationElementIds.put(id, properties);
            }
            ++n2;
        }
    }

    public String[] getAvailableConfigurationElementIds() {
        return this.fAvailableConfigurationElementIds.keySet().toArray(new String[this.fAvailableConfigurationElementIds.size()]);
    }

    public IBuildProperty[] getGenericProperties() {
        return this.fGenericProperties.toArray(new IBuildProperty[this.fGenericProperties.size()]);
    }

    public boolean getSupportsHiddenProperty() {
        return this.fSupportsHiddenPropertyAttribute;
    }

    protected final List<IConfigurationProperty> getConfigurationPropertyForElement(String elementId) {
        if (this.fConfigurationElementIds.containsKey(elementId)) {
            return this.fConfigurationElementIds.get(elementId);
        }
        if (this.fAvailableConfigurationElementIds.containsKey(elementId)) {
            return this.fAvailableConfigurationElementIds.get(elementId);
        }
        return Collections.EMPTY_LIST;
    }
}

